/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWAggregateDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWUserDefinedQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMappingFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregateMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWDirectToXmlTypeMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWManyToManyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToManyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalMappingFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWVariableOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.AffixStrippingPartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.CollectionStringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.ExhaustivePartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparator;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.SimplePartialStringMatcher;

public abstract class MWRelationalClassDescriptor
extends MWMappingDescriptor
implements MWRelationalDescriptor {
    private Collection userDefinedQueryKeys;
    public static final String QUERY_KEYS_COLLECTION = "userDefinedQueryKeys";
    protected static final PartialStringMatcher PARTIAL_STRING_MATCHER = new SimplePartialStringMatcher(PartialStringComparator.DEFAULT_COMPARATOR);
    protected static final float PARTIAL_STRING_AFFIX_THRESHOLD = 0.8f;
    protected static final PartialStringComparatorEngine PARTIAL_STRING_COMPARATOR_ENGINE = AffixStrippingPartialStringComparatorEngine.forPrefixStripping(AffixStrippingPartialStringComparatorEngine.forSuffixStripping((PartialStringComparatorEngine)new ExhaustivePartialStringComparatorEngine(PartialStringComparator.DEFAULT_COMPARATOR), 0.8f), 0.8f);

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWRelationalClassDescriptor.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWMappingDescriptor.class);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(QUERY_KEYS_COLLECTION);
        xMLCompositeCollectionMapping.setGetMethodName("getUserDefinedQueryKeysForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setUserDefinedQueryKeysForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWUserDefinedQueryKey.class);
        xMLCompositeCollectionMapping.setXPath("user-defined-query-keys/user-defined-query-key");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    protected MWRelationalClassDescriptor() {
    }

    protected MWRelationalClassDescriptor(MWRelationalProject mWRelationalProject, MWClass mWClass, String string) {
        super(mWRelationalProject, mWClass, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.userDefinedQueryKeys = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.userDefinedQueryKeys;
        synchronized (collection) {
            list.addAll(this.userDefinedQueryKeys);
        }
    }

    public boolean isTableDescriptor() {
        return false;
    }

    public boolean isAggregateDescriptor() {
        return false;
    }

    public boolean isInterfaceDescriptor() {
        return false;
    }

    public Iterator implementors() {
        return NullIterator.instance();
    }

    public Iterator allAssociatedColumns() {
        return new CompositeIterator(new TransformationIterator(this.associatedTables()){

            protected Object transform(Object object) {
                return ((MWTable)object).columns();
            }
        });
    }

    public int allAssociatedColumnsSize() {
        int n = 0;
        Iterator iterator = this.associatedTables();
        while (iterator.hasNext()) {
            n += ((MWTable)iterator.next()).columnsSize();
        }
        return n;
    }

    public Iterator associatedTablesIncludingInherited() {
        return new CompositeIterator(new TransformationIterator(this.inheritanceHierarchy()){

            protected Object transform(Object object) {
                return ((MWRelationalDescriptor)object).associatedTables();
            }
        });
    }

    public int associatedTablesIncludingInheritedSize() {
        return CollectionTools.size(this.associatedTablesIncludingInherited());
    }

    public Iterator candidateTables() {
        if (this.associatedTablesSize() == 0) {
            return this.getDatabase().tables();
        }
        return this.associatedTables();
    }

    public int candidateTablesSize() {
        return CollectionTools.size(this.candidateTables());
    }

    public Iterator candidateTablesIncludingInherited() {
        if (this.associatedTablesIncludingInheritedSize() == 0) {
            return this.getDatabase().tables();
        }
        return this.associatedTablesIncludingInherited();
    }

    public int candidateTablesIncludingInheritedSize() {
        return CollectionTools.size(this.candidateTablesIncludingInherited());
    }

    public MWAggregateDescriptor asMWAggregateDescriptor() {
        MWAggregateDescriptor mWAggregateDescriptor = ((MWRelationalProject)this.getProject()).addAggregateDescriptorForType(this.getMWClass());
        this.initializeDescriptorAfterMorphing(mWAggregateDescriptor);
        return mWAggregateDescriptor;
    }

    public MWTableDescriptor asMWTableDescriptor() throws InterfaceDescriptorCreationException {
        MWTableDescriptor mWTableDescriptor;
        try {
            mWTableDescriptor = (MWTableDescriptor)this.getProject().addDescriptorForType(this.getMWClass());
        }
        catch (InterfaceDescriptorCreationException interfaceDescriptorCreationException) {
            throw new RuntimeException(interfaceDescriptorCreationException);
        }
        this.initializeDescriptorAfterMorphing(mWTableDescriptor);
        return mWTableDescriptor;
    }

    public MWInterfaceDescriptor asMWInterfaceDescriptor() throws InterfaceDescriptorCreationException {
        MWInterfaceDescriptor mWInterfaceDescriptor = (MWInterfaceDescriptor)this.getProject().addDescriptorForType(this.getMWClass());
        this.initializeDescriptorAfterMorphing(mWInterfaceDescriptor);
        return mWInterfaceDescriptor;
    }

    public void initializeFromMWAggregateDescriptor(MWAggregateDescriptor mWAggregateDescriptor) {
        this.initializeFromMWRelationalClassDescriptor(mWAggregateDescriptor);
    }

    public void initializeFromMWRelationalClassDescriptor(MWRelationalClassDescriptor mWRelationalClassDescriptor) {
        this.initializeFromMWMappingDescriptor(mWRelationalClassDescriptor);
        Iterator iterator = mWRelationalClassDescriptor.userDefinedQueryKeys();
        while (iterator.hasNext()) {
            this.addQueryKey((MWUserDefinedQueryKey)iterator.next());
        }
    }

    public void initializeFromMWTableDescriptor(MWTableDescriptor mWTableDescriptor) {
        this.initializeFromMWRelationalClassDescriptor(mWTableDescriptor);
    }

    public void initializeFromMWInterfaceDescriptor(MWInterfaceDescriptor mWInterfaceDescriptor) {
        this.initializeFromMWDescriptor(mWInterfaceDescriptor);
    }

    protected void refreshClass(MWClassRefreshPolicy mWClassRefreshPolicy) throws ExternalClassNotFoundException, InterfaceDescriptorCreationException {
        super.refreshClass(mWClassRefreshPolicy);
        if (this.getMWClass().isInterface()) {
            this.asMWInterfaceDescriptor();
        }
    }

    public MWMappingFactory mappingFactory() {
        return MWRelationalMappingFactory.instance();
    }

    public MWManyToManyMapping addManyToManyMapping(MWClassAttribute mWClassAttribute) {
        MWManyToManyMapping mWManyToManyMapping = ((MWRelationalMappingFactory)this.mappingFactory()).createManyToManyMapping(this, mWClassAttribute, mWClassAttribute.getName());
        this.addMapping(mWManyToManyMapping);
        return mWManyToManyMapping;
    }

    public MWOneToManyMapping addOneToManyMapping(MWClassAttribute mWClassAttribute) {
        MWOneToManyMapping mWOneToManyMapping = ((MWRelationalMappingFactory)this.mappingFactory()).createOneToManyMapping(this, mWClassAttribute, mWClassAttribute.getName());
        this.addMapping(mWOneToManyMapping);
        return mWOneToManyMapping;
    }

    public MWOneToOneMapping addOneToOneMapping(MWClassAttribute mWClassAttribute) {
        MWOneToOneMapping mWOneToOneMapping = ((MWRelationalMappingFactory)this.mappingFactory()).createOneToOneMapping(this, mWClassAttribute, mWClassAttribute.getName());
        this.addMapping(mWOneToOneMapping);
        return mWOneToOneMapping;
    }

    public MWVariableOneToOneMapping addVariableOneToOneMapping(MWClassAttribute mWClassAttribute) {
        MWVariableOneToOneMapping mWVariableOneToOneMapping = ((MWRelationalMappingFactory)this.mappingFactory()).createVariableOneToOneMapping(this, mWClassAttribute, mWClassAttribute.getName());
        this.addMapping(mWVariableOneToOneMapping);
        return mWVariableOneToOneMapping;
    }

    public MWDirectToXmlTypeMapping addDirectToXmlTypeMapping(MWClassAttribute mWClassAttribute) {
        MWDirectToXmlTypeMapping mWDirectToXmlTypeMapping = ((MWRelationalMappingFactory)this.mappingFactory()).createDirectToXmlTypeMapping(this, mWClassAttribute, mWClassAttribute.getName());
        this.addMapping(mWDirectToXmlTypeMapping);
        return mWDirectToXmlTypeMapping;
    }

    public MWAggregateMapping addAggregateMapping(MWClassAttribute mWClassAttribute) {
        MWAggregateMapping mWAggregateMapping = ((MWRelationalMappingFactory)this.mappingFactory()).createAggregateMapping(this, mWClassAttribute, mWClassAttribute.getName());
        this.addMapping(mWAggregateMapping);
        return mWAggregateMapping;
    }

    public MWUserDefinedQueryKey addQueryKey(String string, MWColumn mWColumn) {
        this.checkQueryKeyName(string);
        MWUserDefinedQueryKey mWUserDefinedQueryKey = new MWUserDefinedQueryKey(string, this, mWColumn);
        this.addQueryKey(mWUserDefinedQueryKey);
        return mWUserDefinedQueryKey;
    }

    void checkQueryKeyName(String string) {
        if (string == null || string == "") {
            throw new NullPointerException();
        }
        if (this.queryKeyNamed(string) != null) {
            throw new IllegalArgumentException(string);
        }
    }

    private void addQueryKey(MWUserDefinedQueryKey mWUserDefinedQueryKey) {
        this.userDefinedQueryKeys.add(mWUserDefinedQueryKey);
        this.fireItemAdded(QUERY_KEYS_COLLECTION, mWUserDefinedQueryKey);
        this.getProject().recalculateAggregatePathsToColumn(this);
    }

    public void removeQueryKey(MWUserDefinedQueryKey mWUserDefinedQueryKey) {
        this.removeNodeFromCollection(mWUserDefinedQueryKey, this.userDefinedQueryKeys, QUERY_KEYS_COLLECTION);
        this.getProject().recalculateAggregatePathsToColumn(this);
    }

    public Iterator allQueryKeys() {
        return this.getAllQueryKeys().iterator();
    }

    public Iterator allQueryKeysIncludingInherited() {
        return this.getAllQueryKeysIncludingInherited().iterator();
    }

    public Iterator allQueryKeyNames() {
        return new TransformationIterator(this.allQueryKeys()){

            protected Object transform(Object object) {
                return ((MWQueryKey)object).getName();
            }
        };
    }

    public Iterator userDefinedQueryKeys() {
        return new CloneIterator(this.userDefinedQueryKeys);
    }

    public SortedSet getAllQueryKeys() {
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(this.userDefinedQueryKeys);
        treeSet.addAll(this.getAutoGeneratedQueryKeys());
        return treeSet;
    }

    public Collection getAutoGeneratedQueryKeys() {
        ArrayList<MWQueryKey> arrayList = new ArrayList<MWQueryKey>();
        Iterator iterator = this.mappings();
        while (iterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)iterator.next();
            MWQueryKey mWQueryKey = mWMapping.getAutoGeneratedQueryKey();
            if (mWQueryKey == null) continue;
            arrayList.add(mWQueryKey);
        }
        return arrayList;
    }

    public Collection getAutoGeneratedQueryKeysIncludingInherited() {
        Collection collection = super.getAutoGeneratedQueryKeysIncludingInherited();
        if (this.getInheritancePolicy().isRoot()) {
            collection = this.getAutoGeneratedQueryKeys();
        } else if (this.getInheritancePolicy().getParentDescriptor() != null) {
            collection = this.getInheritancePolicy().getParentDescriptor().getAutoGeneratedQueryKeysIncludingInherited();
            collection.addAll(this.getAutoGeneratedQueryKeys());
        }
        return collection;
    }

    public Collection getAllQueryKeysIncludingInherited() {
        Collection collection = super.getAllQueryKeysIncludingInherited();
        collection.addAll(this.getAllQueryKeys());
        if (this.getInheritancePolicy().isActive() && this.getInheritancePolicy().getParentDescriptor() != null) {
            collection.addAll(this.getInheritancePolicy().getParentDescriptor().getAllQueryKeysIncludingInherited());
        }
        return collection;
    }

    public MWQueryKey queryKeyNamed(String string) {
        Iterator iterator = this.allQueryKeys();
        while (iterator.hasNext()) {
            MWQueryKey mWQueryKey = (MWQueryKey)iterator.next();
            if (!mWQueryKey.getName().equals(string)) continue;
            return mWQueryKey;
        }
        return null;
    }

    public MWQueryKey queryKeyNamedIncludingInherited(String string) {
        Iterator iterator = this.allQueryKeysIncludingInherited();
        while (iterator.hasNext()) {
            MWQueryKey mWQueryKey = (MWQueryKey)iterator.next();
            if (!mWQueryKey.getName().equals(string)) continue;
            return mWQueryKey;
        }
        return null;
    }

    public MWTable getPrimaryTable() {
        return null;
    }

    public MWQueryable queryableNamed(String string) {
        for (MWQueryable mWQueryable : this.getQueryables(Filter.NULL_INSTANCE)) {
            if (!mWQueryable.getName().equals(string)) continue;
            return mWQueryable;
        }
        return null;
    }

    public List getQueryables(Filter filter) {
        MWModel mWModel;
        ArrayList<MWMapping> arrayList = new ArrayList<MWMapping>();
        Iterator iterator = this.mappingsIncludingInherited();
        while (iterator.hasNext()) {
            mWModel = (MWMapping)iterator.next();
            if (!filter.accept(mWModel)) continue;
            arrayList.add((MWMapping)mWModel);
        }
        iterator = this.userDefinedQueryKeys();
        while (iterator.hasNext()) {
            mWModel = (MWUserDefinedQueryKey)iterator.next();
            if (!filter.accept(mWModel)) continue;
            arrayList.add((MWMapping)mWModel);
        }
        return arrayList;
    }

    protected MWDescriptorInheritancePolicy buildInheritancePolicy() {
        return new MWRelationalDescriptorInheritancePolicy(this);
    }

    public boolean supportsInterfaceAliasPolicy() {
        return false;
    }

    public boolean supportsMultitablePolicy() {
        return false;
    }

    public void unmap() {
        super.unmap();
        this.fireCollectionChanged(QUERY_KEYS_COLLECTION);
    }

    protected void automapSuperDescriptorInheritance(Collection collection) {
        this.automapInheritanceHierarchy(collection);
        MWInheritancePolicy mWInheritancePolicy = this.getInheritancePolicy();
        if (!mWInheritancePolicy.isActive()) {
            this.addInheritancePolicy();
            mWInheritancePolicy = this.getInheritancePolicy();
        }
        if (mWInheritancePolicy.getParentDescriptor() == null) {
            ((MWDescriptorInheritancePolicy)mWInheritancePolicy).setIsRoot(true);
        }
        if (mWInheritancePolicy.getParentDescriptor() == null && !this.getMWClass().isAbstract()) {
            MWClassIndicatorFieldPolicy mWClassIndicatorFieldPolicy = (MWClassIndicatorFieldPolicy)mWInheritancePolicy.getClassIndicatorPolicy();
            MWClassIndicatorValue mWClassIndicatorValue = mWClassIndicatorFieldPolicy.getClassIndicatorValueForDescriptor(this);
            mWClassIndicatorValue.setInclude(true);
            mWClassIndicatorValue.setIndicatorValue(this.getName());
        }
    }

    protected void automapInternal() {
        this.automapUnmappedAttributes();
        this.automapDirectMappingColumns();
        super.automapInternal();
    }

    private void automapUnmappedAttributes() {
        Set set = this.allAttributes();
        CollectionTools.removeAll((Collection)set, this.mappedAttributes());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.automapUnmappedAttribute((MWClassAttribute)iterator.next());
        }
    }

    private Set allAttributes() {
        Set set = CollectionTools.set(this.getMWClass().attributes());
        CollectionTools.addAll((Collection)set, this.inheritedAttributes());
        CollectionTools.addAll((Collection)set, this.getMWClass().ejb20Attributes());
        return set;
    }

    private Iterator mappedAttributes() {
        return new TransformationIterator(this.mappings()){

            protected Object transform(Object object) {
                return ((MWMapping)object).getInstanceVariable();
            }
        };
    }

    private void automapUnmappedAttribute(MWClassAttribute mWClassAttribute) {
        MWModel mWModel;
        if (mWClassAttribute.getDimensionality() > 0) {
            return;
        }
        MWClass mWClass = mWClassAttribute.getType();
        if (mWClass.isValueHolder() && (mWClass = mWClassAttribute.getValueType()).isObject() && (mWModel = mWClassAttribute.standardValueGetMethod()) != null) {
            mWClass = ((MWMethod)mWModel).getReturnType();
        }
        if (mWClass.isContainer()) {
            mWModel = this.findReferenceDescriptorForCollectionAttribute(mWClassAttribute);
            if (mWModel == null) {
                this.automapAsDirectContainerMapping(mWClassAttribute, mWClass);
            } else {
                this.automapAsCollectionMapping(mWClassAttribute, (MWDescriptor)mWModel);
            }
        } else {
            mWModel = this.findReferenceDescriptorForType(mWClass);
            if (mWModel != null) {
                this.automapAsReferenceMapping(mWClassAttribute, (MWDescriptor)mWModel);
            } else {
                this.automapAsDirectMapping(mWClassAttribute);
            }
        }
    }

    private MWDescriptor findReferenceDescriptorForCollectionAttribute(MWClassAttribute mWClassAttribute) {
        CollectionStringHolder[] collectionStringHolderArray = this.buildMultiDescriptorStringHolders();
        PartialStringMatcher.StringHolderScore stringHolderScore = this.match(mWClassAttribute.getName().toLowerCase(), collectionStringHolderArray);
        if (stringHolderScore.getScore() < 0.8) {
            return null;
        }
        String string = this.packageName();
        MWDescriptor mWDescriptor = null;
        Iterator iterator = ((CollectionStringHolder)stringHolderScore.getStringHolder()).iterator();
        while (iterator.hasNext()) {
            mWDescriptor = (MWDescriptor)iterator.next();
            if (!mWDescriptor.packageName().equals(string)) continue;
            return mWDescriptor;
        }
        return mWDescriptor;
    }

    private CollectionStringHolder[] buildMultiDescriptorStringHolders() {
        HashMap<String, CollectionStringHolder> hashMap = new HashMap<String, CollectionStringHolder>(this.getProject().descriptorsSize());
        Iterator iterator = this.getProject().descriptors();
        while (iterator.hasNext()) {
            MWDescriptor mWDescriptor = (MWDescriptor)iterator.next();
            String string = mWDescriptor.shortName().toLowerCase();
            CollectionStringHolder collectionStringHolder = (CollectionStringHolder)hashMap.get(string);
            if (collectionStringHolder == null) {
                collectionStringHolder = new CollectionStringHolder(string);
                hashMap.put(string, collectionStringHolder);
            }
            collectionStringHolder.add(mWDescriptor);
        }
        return hashMap.values().toArray(new CollectionStringHolder[hashMap.size()]);
    }

    private PartialStringMatcher.StringHolderScore match(String string, CollectionStringHolder[] collectionStringHolderArray) {
        return PARTIAL_STRING_MATCHER.match(string, collectionStringHolderArray);
    }

    private void automapAsDirectContainerMapping(MWClassAttribute mWClassAttribute, MWClass mWClass) {
        if (mWClass.isAssignableToCollection()) {
            this.addDirectCollectionMapping(mWClassAttribute);
        } else {
            this.addDirectMapMapping(mWClassAttribute);
        }
    }

    private void automapAsCollectionMapping(MWClassAttribute mWClassAttribute, MWDescriptor mWDescriptor) {
        MWOneToManyMapping mWOneToManyMapping = this.addOneToManyMapping(mWClassAttribute);
        mWOneToManyMapping.setReferenceDescriptor(mWDescriptor);
    }

    private MWDescriptor findReferenceDescriptorForType(MWClass mWClass) {
        MWDescriptor mWDescriptor = this.getProject().descriptorForType(mWClass);
        if (mWDescriptor != null) {
            return mWDescriptor;
        }
        if (mWClass.isInterface()) {
            Iterator iterator = this.getProject().descriptors();
            while (iterator.hasNext()) {
                mWDescriptor = (MWDescriptor)iterator.next();
                if (!mWDescriptor.getMWClass().isAssignableTo(mWClass)) continue;
                return mWDescriptor;
            }
        }
        return null;
    }

    private void automapAsReferenceMapping(MWClassAttribute mWClassAttribute, MWDescriptor mWDescriptor) {
        MWRelationalDescriptor mWRelationalDescriptor = (MWRelationalDescriptor)((Object)mWDescriptor);
        if (mWRelationalDescriptor.isInterfaceDescriptor()) {
            MWClass mWClass = mWRelationalDescriptor.getMWClass();
            int n = 0;
            MWDescriptor mWDescriptor2 = null;
            Object object = this.getProject().descriptors();
            while (object.hasNext()) {
                MWDescriptor mWDescriptor3 = (MWDescriptor)object.next();
                if (mWDescriptor3 == mWDescriptor || !mWDescriptor3.getMWClass().allInterfacesContains(mWClass)) continue;
                mWDescriptor2 = mWDescriptor3;
                ++n;
            }
            if (n == 1) {
                object = this.addOneToOneMapping(mWClassAttribute);
                object.setReferenceDescriptor(mWDescriptor2);
            } else {
                object = this.addVariableOneToOneMapping(mWClassAttribute);
                object.setReferenceDescriptor(mWDescriptor);
            }
        } else if (mWRelationalDescriptor.isAggregateDescriptor()) {
            MWAggregateMapping mWAggregateMapping = this.addAggregateMapping(mWClassAttribute);
            mWAggregateMapping.setReferenceDescriptor(mWDescriptor);
        } else if (mWRelationalDescriptor.isTableDescriptor()) {
            MWOneToOneMapping mWOneToOneMapping = this.addOneToOneMapping(mWClassAttribute);
            mWOneToOneMapping.setReferenceDescriptor(mWDescriptor);
        }
    }

    private void automapAsDirectMapping(MWClassAttribute mWClassAttribute) {
        this.addDirectMapping(mWClassAttribute);
    }

    protected void automapDirectMappingColumns() {
    }

    public Collection buildAggregateFieldNameGenerators() {
        ArrayList<MWUserDefinedQueryKey> arrayList = new ArrayList<MWUserDefinedQueryKey>();
        if (this.getInheritancePolicy().isRoot()) {
            this.getInheritancePolicy().getClassIndicatorPolicy().addToAggregateFieldNameGenerators(arrayList);
        } else if (this.getInheritancePolicy().getParentDescriptor() != null) {
            arrayList.addAll(((MWRelationalDescriptor)((Object)this.getInheritancePolicy().getParentDescriptor())).buildAggregateFieldNameGenerators());
        }
        Iterator iterator = this.userDefinedQueryKeys();
        while (iterator.hasNext()) {
            MWUserDefinedQueryKey mWUserDefinedQueryKey = (MWUserDefinedQueryKey)iterator.next();
            arrayList.add(mWUserDefinedQueryKey);
        }
        return arrayList;
    }

    public ClassDescriptor buildRuntimeDescriptor() {
        ClassDescriptor classDescriptor = super.buildRuntimeDescriptor();
        this.adjustUserDefinedQueryKeys(classDescriptor);
        return classDescriptor;
    }

    protected abstract void adjustUserDefinedQueryKeys(ClassDescriptor var1);

    private Collection getUserDefinedQueryKeysForTopLink() {
        return CollectionTools.sort((List)this.userDefinedQueryKeys);
    }

    private void setUserDefinedQueryKeysForTopLink(Collection collection) {
        this.userDefinedQueryKeys = collection;
    }
}

