/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangeTrackingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.ColumnStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAdvancedPropertyAdditionException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAdvancedPropertyRemovalException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInterfaceAliasPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInterfaceAliasDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWNullDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWRefreshCachePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWReturningPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWDescriptorMultiTableInfoPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalPrimaryKeyPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalReturningPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWUserDefinedQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWTableHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MappingStringHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQueryManager;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWTableDescriptor
extends MWRelationalClassDescriptor
implements MWTransactionalDescriptor,
MWInterfaceAliasDescriptor {
    private MWTableHandle primaryTableHandle;
    public static final String PRIMARY_TABLE_PROPERTY = "primaryTable";
    private volatile boolean usesSequencing;
    public static final String USES_SEQUENCING_PROPERTY = "usesSequencing";
    private volatile String sequenceNumberName;
    public static final String SEQUENCE_NUMBER_NAME_PROPERTY = "sequenceNumberName";
    private MWTableHandle sequenceNumberTableHandle;
    public static final String SEQUENCE_NUMBER_TABLE_PROPERTY = "sequenceNumberTable";
    private MWColumnHandle sequenceNumberColumnHandle;
    public static final String SEQUENCE_NUMBER_COLUMN_PROPERTY = "sequenceNumberColumn";
    private volatile MWDescriptorPolicy multiTableInfoPolicy;
    public static final String MULTI_TABLE_INFO_POLICY_PROPERTY = "multiTableInfoPolicy";
    private volatile MWDescriptorPolicy interfaceAliasPolicy;
    public static final String INTERFACE_ALIAS_POLICY_PROPERTY = "interfaceAliasPolicy";
    private volatile MWDescriptorPolicy returningPolicy;
    private volatile String changeTrackingType;
    public static final String CHANGE_TRACKING_TYPE_PROPERTY = "changeTrackingType";
    public static final String OBJECT_LEVEL_CHANGE_TRACKING = "objectLevelChangeTracking";
    public static final String ATTRIBUTE_LEVEL_CHANGE_TRACKING = "attributeLevelChangeTracking";

    private MWTableDescriptor() {
    }

    public MWTableDescriptor(MWRelationalProject mWRelationalProject, MWClass mWClass, String string) {
        super(mWRelationalProject, mWClass, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.primaryTableHandle = new MWTableHandle(this, this.buildPrimaryTableScrubber());
        this.sequenceNumberColumnHandle = new MWColumnHandle(this, this.buildSequenceNumberColumnScrubber());
        this.sequenceNumberTableHandle = new MWTableHandle(this, this.buildSequenceNumberTableScrubber());
        this.sequenceNumberName = "";
        this.interfaceAliasPolicy = new MWNullDescriptorPolicy(this);
        this.multiTableInfoPolicy = new MWNullDescriptorPolicy(this);
        this.returningPolicy = new MWNullDescriptorPolicy(this);
    }

    public MWTable getPrimaryTable() {
        return this.primaryTableHandle.getTable();
    }

    public void setPrimaryTable(MWTable mWTable) {
        MWTable mWTable2 = this.getPrimaryTable();
        this.primaryTableHandle.setTable(mWTable);
        this.firePropertyChanged(PRIMARY_TABLE_PROPERTY, mWTable2, mWTable);
        this.primaryKeyPolicy().descriptorPrimaryTableChanged(mWTable);
    }

    public void notifyExpressionsToRecalculateQueryables() {
        this.getRelationalQueryManager().notifyExpressionsToRecalculateQueryables();
    }

    protected MWTransactionalPolicy buildDefaultTransactionalPolicy() {
        return new MWRelationalTransactionalPolicy(this);
    }

    public MWRelationalTransactionalPolicy getRelationalTransactionalPolicy() {
        return (MWRelationalTransactionalPolicy)this.getTransactionalPolicy();
    }

    public MWRelationalPrimaryKeyPolicy primaryKeyPolicy() {
        return this.getRelationalTransactionalPolicy().getPrimaryKeyPolicy();
    }

    public Iterator primaryKeyChoices() {
        return this.primaryKeyPolicy().primaryKeyChoices();
    }

    public Iterator primaryKeyAttributes() {
        Vector<MWClassAttribute> vector = new Vector<MWClassAttribute>();
        Iterator iterator = this.primaryKeyMappings();
        while (iterator.hasNext()) {
            vector.add(((MWMapping)iterator.next()).getInstanceVariable());
        }
        return vector.iterator();
    }

    public Iterator primaryKeyMappings() {
        Vector vector = new Vector();
        Iterator iterator = this.primaryKeyPolicy().primaryKeys();
        while (iterator.hasNext()) {
            vector.addAll(this.allWritableMappingsForField((MWColumn)iterator.next()));
        }
        return vector.iterator();
    }

    public Iterator primaryKeyNames() {
        return new TransformationIterator(this.primaryKeys()){

            protected Object transform(Object object) {
                return ((MWColumn)object).getName();
            }
        };
    }

    public Iterator primaryKeys() {
        return this.primaryKeyPolicy().primaryKeys();
    }

    public int primaryKeysSize() {
        return this.primaryKeyPolicy().primaryKeysSize();
    }

    public boolean usesSequencing() {
        return this.usesSequencing;
    }

    public void setUsesSequencing(boolean bl) {
        boolean bl2 = this.usesSequencing;
        this.usesSequencing = bl;
        if (bl2 != bl) {
            if (!bl) {
                this.setSequenceNumberName("");
                this.setSequenceNumberTable(null);
            } else {
                this.initializeDefaultSequenceTableInfo();
            }
            this.firePropertyChanged(USES_SEQUENCING_PROPERTY, bl2, bl);
        }
    }

    private void initializeDefaultSequenceTableInfo() {
        this.setSequenceNumberName("SEQ");
        if (this.getPrimaryTable() != null) {
            this.setSequenceNumberTable(this.getPrimaryTable());
            if (this.getPrimaryTable().primaryKeyColumnsSize() > 0) {
                this.setSequenceNumberColumn((MWColumn)this.getPrimaryTable().primaryKeyColumns().next());
            }
        }
    }

    public boolean usesSequencingInDescriptorHierarchy() {
        if (this.usesSequencing()) {
            return true;
        }
        MWDescriptor mWDescriptor = this.getInheritancePolicy().getParentDescriptor();
        return mWDescriptor == null ? false : mWDescriptor.usesSequencingInDescriptorHierarchy();
    }

    public String getSequenceNumberName() {
        return this.sequenceNumberName;
    }

    public void setSequenceNumberName(String string) {
        if (!this.usesSequencing() && !string.equals("")) {
            throw new IllegalStateException("Must have useSequencing set to true to set the sequence number name");
        }
        String string2 = this.sequenceNumberName;
        this.sequenceNumberName = string;
        this.firePropertyChanged(SEQUENCE_NUMBER_NAME_PROPERTY, string2, string);
    }

    public MWColumn getSequenceNumberColumn() {
        return this.sequenceNumberColumnHandle.getColumn();
    }

    public void setSequenceNumberColumn(MWColumn mWColumn) {
        if (!this.usesSequencing() && mWColumn != null) {
            throw new IllegalStateException("Must have useSequencing set to true to set the sequence column");
        }
        if (this.getSequenceNumberTable() == null && mWColumn != null) {
            throw new IllegalStateException("Must have the sequence table set to set the sequence column");
        }
        if (mWColumn != null && this.getSequenceNumberTable() != mWColumn.getTable()) {
            throw new IllegalArgumentException("The column must be in the current sequence number table");
        }
        MWColumn mWColumn2 = this.sequenceNumberColumnHandle.getColumn();
        this.sequenceNumberColumnHandle.setColumn(mWColumn);
        this.firePropertyChanged(SEQUENCE_NUMBER_COLUMN_PROPERTY, mWColumn2, mWColumn);
    }

    public MWTable getSequenceNumberTable() {
        return this.sequenceNumberTableHandle.getTable();
    }

    public void setSequenceNumberTable(MWTable mWTable) {
        if (!this.usesSequencing() && mWTable != null) {
            throw new IllegalStateException("Must have useSequencing set to true to set the sequence table");
        }
        MWTable mWTable2 = this.getSequenceNumberTable();
        this.sequenceNumberTableHandle.setTable(mWTable);
        this.setSequenceNumberColumn(null);
        this.firePropertyChanged(SEQUENCE_NUMBER_TABLE_PROPERTY, mWTable2, mWTable);
    }

    public MWRefreshCachePolicy getRefreshCachePolicy() {
        return this.getRelationalTransactionalPolicy().getRefreshCachePolicy();
    }

    public MWRelationalQueryManager getRelationalQueryManager() {
        return (MWRelationalQueryManager)this.getRelationalTransactionalPolicy().getQueryManager();
    }

    public MWQueryable firstQueryable() {
        for (MWQueryable mWQueryable : this.getQueryables(Filter.NULL_INSTANCE)) {
            if (!mWQueryable.isLeaf(Filter.NULL_INSTANCE)) continue;
            return mWQueryable;
        }
        return null;
    }

    private MWDescriptorMultiTableInfoPolicy getMultiTableInfoPolicyForTopLink() {
        return (MWDescriptorMultiTableInfoPolicy)this.multiTableInfoPolicy.getPersistedPolicy();
    }

    private void setMultiTableInfoPolicyForTopLink(MWDescriptorMultiTableInfoPolicy mWDescriptorMultiTableInfoPolicy) {
        this.multiTableInfoPolicy = mWDescriptorMultiTableInfoPolicy == null ? new MWNullDescriptorPolicy(this) : mWDescriptorMultiTableInfoPolicy;
    }

    private void setMultiTableInfoPolicy(MWDescriptorPolicy mWDescriptorPolicy) {
        MWDescriptorPolicy mWDescriptorPolicy2 = this.multiTableInfoPolicy;
        this.multiTableInfoPolicy = mWDescriptorPolicy;
        this.firePropertyChanged(MULTI_TABLE_INFO_POLICY_PROPERTY, mWDescriptorPolicy2, this.multiTableInfoPolicy);
    }

    public MWDescriptorPolicy getMultiTableInfoPolicy() {
        return this.multiTableInfoPolicy;
    }

    public void addMultiTableInfoPolicy() throws MWAdvancedPropertyAdditionException {
        if (this.multiTableInfoPolicy.isActive()) {
            throw new MWAdvancedPropertyAdditionException(MULTI_TABLE_INFO_POLICY_PROPERTY, "policy already exists on descriptor");
        }
        this.setMultiTableInfoPolicy(new MWDescriptorMultiTableInfoPolicy(this));
    }

    public void removeMultiTableInfoPolicy() {
        if (!this.multiTableInfoPolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException(MULTI_TABLE_INFO_POLICY_PROPERTY, "policy does not exist on the descriptor");
        }
        this.getMultiTableInfoPolicy().dispose();
        this.setMultiTableInfoPolicy(new MWNullDescriptorPolicy(this));
    }

    private void setInterfaceAliasPolicyForTopLink(MWDescriptorInterfaceAliasPolicy mWDescriptorInterfaceAliasPolicy) {
        this.interfaceAliasPolicy = mWDescriptorInterfaceAliasPolicy == null ? new MWNullDescriptorPolicy(this) : mWDescriptorInterfaceAliasPolicy;
    }

    private MWDescriptorInterfaceAliasPolicy getInterfaceAliasPolicyForTopLink() {
        return (MWDescriptorInterfaceAliasPolicy)this.interfaceAliasPolicy.getPersistedPolicy();
    }

    protected void setInterfaceAliasPolicy(MWDescriptorPolicy mWDescriptorPolicy) {
        MWDescriptorPolicy mWDescriptorPolicy2 = this.interfaceAliasPolicy;
        this.interfaceAliasPolicy = mWDescriptorPolicy;
        this.firePropertyChanged(INTERFACE_ALIAS_POLICY_PROPERTY, mWDescriptorPolicy2, this.interfaceAliasPolicy);
    }

    public MWDescriptorPolicy getInterfaceAliasPolicy() {
        return this.interfaceAliasPolicy;
    }

    public void removeInterfaceAliasPolicy() {
        if (!this.interfaceAliasPolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException(INTERFACE_ALIAS_POLICY_PROPERTY, "policy does not exist on the descriptor");
        }
        this.setInterfaceAliasPolicy(new MWNullDescriptorPolicy(this));
    }

    public void addInterfaceAliasPolicy() throws MWAdvancedPropertyAdditionException {
        if (this.interfaceAliasPolicy.isActive()) {
            throw new MWAdvancedPropertyAdditionException(INTERFACE_ALIAS_POLICY_PROPERTY, "policy already exists on descriptor");
        }
        this.setInterfaceAliasPolicy(new MWDescriptorInterfaceAliasPolicy(this));
    }

    public boolean supportsInterfaceAliasPolicy() {
        return true;
    }

    public boolean supportsMultitablePolicy() {
        return true;
    }

    public void addAssociatedTable(MWTable mWTable) {
        if (!this.getMultiTableInfoPolicy().isActive()) {
            throw new IllegalStateException("Cannot add associated tables unless the descriptor has the Multitable info policy");
        }
        ((MWDescriptorMultiTableInfoPolicy)this.getMultiTableInfoPolicy()).addSecondaryTable(mWTable);
    }

    public void removeAssociatedTable(MWTable mWTable) {
        ((MWDescriptorMultiTableInfoPolicy)this.getMultiTableInfoPolicy()).removeSecondaryTable(mWTable);
    }

    public MWTable getAssociatedTableNamed(String string) {
        Iterator iterator = this.associatedTables();
        while (iterator.hasNext()) {
            MWTable mWTable = (MWTable)iterator.next();
            if (!mWTable.getName().equals(string)) continue;
            return mWTable;
        }
        return null;
    }

    public boolean hasAssociatedTable(MWTable mWTable) {
        Iterator iterator = this.associatedTables();
        while (iterator.hasNext()) {
            MWTable mWTable2 = (MWTable)iterator.next();
            if (mWTable2 != mWTable) continue;
            return true;
        }
        return false;
    }

    public Iterator associatedTables() {
        if (this.getPrimaryTable() != null && !CollectionTools.contains(this.secondaryTables(), (Object)this.getPrimaryTable())) {
            return new CompositeIterator(this.getPrimaryTable(), this.secondaryTables());
        }
        return this.secondaryTables();
    }

    public int associatedTablesSize() {
        return CollectionTools.size(this.associatedTables());
    }

    public Iterator secondaryTables() {
        if (this.getMultiTableInfoPolicy().isActive()) {
            return ((MWDescriptorMultiTableInfoPolicy)this.getMultiTableInfoPolicy()).secondaryTables();
        }
        return NullIterator.instance();
    }

    public String getChangeTrackingType() {
        return this.changeTrackingType;
    }

    public void setChangeTrackingType(String string) {
        String string2 = this.changeTrackingType;
        this.changeTrackingType = string;
        this.firePropertyChanged(CHANGE_TRACKING_TYPE_PROPERTY, string2, string);
    }

    public MWDescriptorPolicy getReturningPolicy() {
        return this.returningPolicy;
    }

    private MWReturningPolicy getReturningPolicyForTopLink() {
        return (MWReturningPolicy)this.returningPolicy.getPersistedPolicy();
    }

    private void setReturningPolicyForTopLink(MWReturningPolicy mWReturningPolicy) {
        this.returningPolicy = mWReturningPolicy == null ? new MWNullDescriptorPolicy(this) : mWReturningPolicy;
    }

    private void setReturningPolicy(MWDescriptorPolicy mWDescriptorPolicy) {
        MWDescriptorPolicy mWDescriptorPolicy2 = this.returningPolicy;
        this.returningPolicy = mWDescriptorPolicy;
        this.firePropertyChanged("returningPolicy", mWDescriptorPolicy2, mWDescriptorPolicy);
    }

    public void addReturningPolicy() throws MWAdvancedPropertyAdditionException {
        if (this.returningPolicy.isActive()) {
            throw new MWAdvancedPropertyAdditionException("returningPolicy", "policy already exists on descriptor");
        }
        this.setReturningPolicy(new MWRelationalReturningPolicy(this));
    }

    public void removeReturningPolicy() {
        if (!this.returningPolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException("returningPolicy", "policy does not exist on the descriptor");
        }
        this.getReturningPolicy().dispose();
        this.setReturningPolicy(new MWNullDescriptorPolicy(this));
    }

    public boolean supportsReturningPolicy() {
        return true;
    }

    public boolean supportsCachingPolicy() {
        return true;
    }

    public MWTableDescriptor asMWTableDescriptor() {
        return this;
    }

    public void initializeOn(MWDescriptor mWDescriptor) {
        ((MWRelationalDescriptor)((Object)mWDescriptor)).initializeFromMWTableDescriptor(this);
    }

    public boolean isRootDescriptor() {
        return true;
    }

    public boolean isTableDescriptor() {
        return true;
    }

    public void applyAdvancedPolicyDefaults(MWProjectDefaultsPolicy mWProjectDefaultsPolicy) {
        mWProjectDefaultsPolicy.applyAdvancedPolicyDefaults(this);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.sequenceNumberColumnHandle);
        list.add(this.sequenceNumberTableHandle);
        list.add(this.primaryTableHandle);
        list.add(this.interfaceAliasPolicy);
        list.add(this.multiTableInfoPolicy);
        list.add(this.returningPolicy);
    }

    private MWHandle.NodeReferenceScrubber buildSequenceNumberColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWTableDescriptor.this.setSequenceNumberColumn(null);
            }

            public String toString() {
                return "MWTableDescriptor.buildSequenceNumberColumnScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildSequenceNumberTableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWTableDescriptor.this.setSequenceNumberTable(null);
            }

            public String toString() {
                return "MWTableDescriptor.buildSequenceNumberTableScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildPrimaryTableScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWTableDescriptor.this.setPrimaryTable(null);
            }

            public String toString() {
                return "MWTableDescriptor.buildPrimaryTableScrubber()";
            }
        };
    }

    protected void automapInheritanceHierarchyInternal(Collection collection) {
        super.automapInheritanceHierarchyInternal(collection);
        MWRelationalClassDescriptor mWRelationalClassDescriptor = this.automapFindParentDescriptor();
        if (mWRelationalClassDescriptor == null) {
            return;
        }
        if (collection.contains(mWRelationalClassDescriptor)) {
            mWRelationalClassDescriptor.automapSuperDescriptorInheritance(collection);
        }
        this.automapDescriptorInheritance(mWRelationalClassDescriptor);
        if (mWRelationalClassDescriptor.isAggregateDescriptor()) {
            this.asMWAggregateDescriptor();
        }
    }

    private MWRelationalClassDescriptor automapFindParentDescriptor() {
        for (MWClass mWClass = this.getMWClass().getSuperclass(); mWClass != null; mWClass = mWClass.getSuperclass()) {
            if (mWClass.isInterface()) {
                return null;
            }
            MWDescriptor mWDescriptor = this.getProject().descriptorForType(mWClass);
            if (mWDescriptor == null || !mWDescriptor.isActive()) continue;
            return (MWRelationalClassDescriptor)mWDescriptor;
        }
        return null;
    }

    private void automapDescriptorInheritance(MWRelationalClassDescriptor mWRelationalClassDescriptor) {
        MWInheritancePolicy mWInheritancePolicy;
        MWInheritancePolicy mWInheritancePolicy2 = this.getInheritancePolicy();
        if (!mWInheritancePolicy2.isActive()) {
            this.addInheritancePolicy();
            mWInheritancePolicy2 = this.getInheritancePolicy();
        }
        ((MWDescriptorInheritancePolicy)mWInheritancePolicy2).setIsRoot(false);
        ((MWDescriptorInheritancePolicy)mWInheritancePolicy2).setParentDescriptor(mWRelationalClassDescriptor);
        if (!this.getMWClass().isAbstract() && (mWInheritancePolicy = mWInheritancePolicy2.getRootDescriptor().getInheritancePolicy()).isActive()) {
            MWClassIndicatorFieldPolicy mWClassIndicatorFieldPolicy = (MWClassIndicatorFieldPolicy)mWInheritancePolicy.getClassIndicatorPolicy();
            MWClassIndicatorValue mWClassIndicatorValue = mWClassIndicatorFieldPolicy.getClassIndicatorValueForDescriptor(this);
            if (mWClassIndicatorValue == null) {
                mWClassIndicatorValue = mWClassIndicatorFieldPolicy.addIndicator(this.getName(), this);
            } else {
                mWClassIndicatorValue.setIndicatorValue(this.getName());
            }
            mWClassIndicatorValue.setInclude(true);
        }
    }

    protected boolean autoMapRequiresMetaDataInternal() {
        return this.getPrimaryTable() == null;
    }

    protected void automapDirectMappingColumns() {
        StringHolder[] stringHolderArray = this.buildColumnlessDirectMappingStringHolders();
        StringHolder[] stringHolderArray2 = this.buildAllUnmappedColumnStringHolders();
        PartialStringComparatorEngine.StringHolderPair[] stringHolderPairArray = PARTIAL_STRING_COMPARATOR_ENGINE.match(stringHolderArray, stringHolderArray2);
        int n = stringHolderPairArray.length;
        while (n-- > 0) {
            PartialStringComparatorEngine.StringHolderPair stringHolderPair = stringHolderPairArray[n];
            MappingStringHolder mappingStringHolder = (MappingStringHolder)stringHolderPair.getStringHolder1();
            ColumnStringHolder columnStringHolder = (ColumnStringHolder)stringHolderPair.getStringHolder2();
            if (mappingStringHolder == null || columnStringHolder == null || !(stringHolderPair.getScore() > 0.5)) continue;
            MWRelationalDirectMapping mWRelationalDirectMapping = (MWRelationalDirectMapping)mappingStringHolder.getMapping();
            mWRelationalDirectMapping.setColumn(columnStringHolder.getColumn());
        }
    }

    private MappingStringHolder[] buildColumnlessDirectMappingStringHolders() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.mappings();
        while (iterator.hasNext()) {
            ((MWMapping)iterator.next()).addColumnlessDirectMappingTo(arrayList);
        }
        return MappingStringHolder.buildHolders(arrayList);
    }

    private ColumnStringHolder[] buildAllUnmappedColumnStringHolders() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.associatedTables();
        while (iterator.hasNext()) {
            CollectionTools.addAll(arrayList, ((MWTable)iterator.next()).columns());
        }
        iterator = this.mappings();
        while (iterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)iterator.next();
            ArrayList arrayList2 = new ArrayList();
            mWMapping.addWrittenFieldsTo(arrayList2);
            arrayList.removeAll(arrayList2);
        }
        return ColumnStringHolder.buildHolders(arrayList);
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkPrimaryTable(list);
        this.checkPrimaryKeys(list);
        this.checkPrimaryKeysMapped(list);
        this.checkPrimaryKeysMatchParent(list);
        this.checkPrimaryKeyMappingsNotReadOnly(list);
        this.checkSequencing(list);
        this.checkClassIndicatorFieldMapping(list);
        this.checkQueries(list);
    }

    private void checkPrimaryTable(List list) {
        if (this.getPrimaryTable() == null) {
            list.add(this.buildProblem("0230"));
        }
    }

    private void checkPrimaryKeys(List list) {
        boolean bl;
        boolean bl2 = bl = this.getInheritancePolicy().getParentDescriptor() != null;
        if (!bl && this.getPrimaryTable() != null && this.primaryKeyPolicy().primaryKeysSize() == 0) {
            list.add(this.buildProblem("0231"));
        }
    }

    private void checkPrimaryKeysMapped(List list) {
        boolean bl;
        boolean bl2 = this.getInheritancePolicy().getParentDescriptor() != null;
        boolean bl3 = bl = this.getPrimaryTable() == null;
        if (bl2 || bl) {
            return;
        }
        Iterator iterator = this.primaryKeyPolicy().primaryKeys();
        while (iterator.hasNext()) {
            MWColumn mWColumn = (MWColumn)iterator.next();
            Collection collection = this.allWritableMappingsForField(mWColumn);
            if (collection.size() != 0) continue;
            list.add(this.buildProblem("0232", mWColumn.getName()));
        }
    }

    private void checkPrimaryKeysMatchParent(List list) {
        boolean bl;
        boolean bl2 = !this.getInheritancePolicy().isActive() || this.getInheritancePolicy().getParentDescriptor() == null;
        boolean bl3 = bl = this.getPrimaryTable() == null;
        if (bl2 || bl) {
            return;
        }
        if (this.getMultiTableInfoPolicy().isActive() && ((MWDescriptorMultiTableInfoPolicy)this.getMultiTableInfoPolicy()).pksAcrossMultipleTablesTest(true)) {
            return;
        }
        if (this.getInheritancePolicy().getParentDescriptor() instanceof MWTableDescriptor) {
            Object object;
            Collection collection = CollectionTools.collection(((MWTableDescriptor)this.getInheritancePolicy().getParentDescriptor()).primaryKeyNames());
            if (this.primaryKeysSize() != collection.size()) {
                list.add(this.buildProblem("0233"));
            }
            Object object2 = this.primaryKeys();
            while (object2.hasNext()) {
                object = (MWColumn)object2.next();
                if (collection.contains(((MWColumn)object).getName())) continue;
                list.add(this.buildProblem("0234"));
            }
            object2 = (MWTableDescriptor)this.getInheritancePolicy().getParentDescriptor();
            object = ((MWTableDescriptor)object2).primaryKeyMappings();
            while (object.hasNext()) {
                MWMapping mWMapping = (MWMapping)object.next();
                MWMapping mWMapping2 = this.mappingNamed(mWMapping.getInstanceVariable().getName());
                if (mWMapping2 == null || !CollectionTools.collection(this.primaryKeyMappings()).contains(mWMapping2) || ((MWRelationalDirectMapping)mWMapping).getColumn() != ((MWRelationalDirectMapping)mWMapping2).getColumn()) continue;
                list.add(this.buildProblem("0226", mWMapping2));
            }
        }
    }

    private void checkSequencing(List list) {
        if (!this.usesSequencing()) {
            return;
        }
        if (StringTools.stringIsEmpty(this.getSequenceNumberName())) {
            list.add(this.buildProblem("0237"));
        }
        if (this.getSequenceNumberTable() == null) {
            list.add(this.buildProblem("0238"));
            return;
        }
        if (this.getSequenceNumberColumn() == null) {
            list.add(this.buildProblem("0236"));
        }
        if (!CollectionTools.contains(this.associatedTables(), (Object)this.getSequenceNumberTable())) {
            list.add(this.buildProblem("0239"));
        }
    }

    private void checkQueries(List list) {
        Iterator iterator = this.getRelationalQueryManager().queries();
        while (iterator.hasNext()) {
            String string = ((MWQuery)iterator.next()).signature();
            boolean bl = true;
            Iterator iterator2 = this.getRelationalQueryManager().queries();
            while (iterator2.hasNext()) {
                MWQuery mWQuery = (MWQuery)iterator2.next();
                if (!mWQuery.signature().equals(string)) continue;
                if (!bl) {
                    String string2 = mWQuery.getName();
                    list.add(this.buildProblem("0240", string2));
                    continue;
                }
                bl = false;
            }
        }
    }

    private void checkPrimaryKeyMappingsNotReadOnly(List list) {
        boolean bl;
        MWInheritancePolicy mWInheritancePolicy = this.getInheritancePolicy();
        boolean bl2 = mWInheritancePolicy.getParentDescriptor() != null;
        boolean bl3 = this.getPrimaryTable() == null;
        boolean bl4 = bl = this.getRelationalTransactionalPolicy().getPrimaryKeyPolicy().primaryKeysSize() == 0;
        if (bl2 || bl3 || bl) {
            return;
        }
        Iterator iterator = this.getRelationalTransactionalPolicy().getPrimaryKeyPolicy().primaryKeys();
        while (iterator.hasNext()) {
            MWColumn mWColumn = (MWColumn)iterator.next();
            if (this.allWritableMappingsForField(mWColumn).size() != 0) continue;
            list.add(this.buildProblem("0235", mWColumn.getName()));
        }
    }

    protected String multipleMappingsWriteFieldProblemResourceStringKey() {
        return "0106";
    }

    private void checkClassIndicatorFieldMapping(List list) {
        MWInheritancePolicy mWInheritancePolicy = this.getInheritancePolicy();
        if (!mWInheritancePolicy.isRoot()) {
            return;
        }
        MWClassIndicatorPolicy mWClassIndicatorPolicy = mWInheritancePolicy.getClassIndicatorPolicy();
        if (mWClassIndicatorPolicy.getType() == "classExtractionMethodClassIndicatorPolicy" || mWClassIndicatorPolicy.getType() == "nullPolicy") {
            return;
        }
        MWColumn mWColumn = ((MWRelationalClassIndicatorFieldPolicy)mWClassIndicatorPolicy).getColumn();
        if (mWColumn == null || mWColumn.isPrimaryKey()) {
            return;
        }
        if (this.allWritableMappingsForField(mWColumn).size() != 0) {
            list.add(this.buildProblem("0126", mWColumn.getName()));
        }
    }

    protected ClassDescriptor buildBasicRuntimeDescriptor() {
        RelationalDescriptor relationalDescriptor = new RelationalDescriptor();
        relationalDescriptor.setJavaClassName(this.getMWClass().getName());
        return relationalDescriptor;
    }

    public ClassDescriptor buildRuntimeDescriptor() {
        String string;
        ClassDescriptor classDescriptor = super.buildRuntimeDescriptor();
        if (this.getPrimaryTable() != null) {
            classDescriptor.setTableName(this.getPrimaryTable().getName());
        }
        if (this.usesSequencing() && this.getSequenceNumberColumn() != null) {
            classDescriptor.setSequenceNumberField(new DatabaseField(this.getSequenceNumberColumn().qualifiedName()));
            classDescriptor.setSequenceNumberName(this.getSequenceNumberName());
        }
        if (ATTRIBUTE_LEVEL_CHANGE_TRACKING.equals(string = this.getChangeTrackingType())) {
            classDescriptor.setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
        } else if (OBJECT_LEVEL_CHANGE_TRACKING.equals(string)) {
            classDescriptor.setObjectChangePolicy((ObjectChangePolicy)new ObjectChangeTrackingPolicy());
        }
        this.interfaceAliasPolicy.adjustRuntimeDescriptor(classDescriptor);
        this.multiTableInfoPolicy.adjustRuntimeDescriptor(classDescriptor);
        this.returningPolicy.adjustRuntimeDescriptor(classDescriptor);
        return classDescriptor;
    }

    protected void adjustUserDefinedQueryKeys(ClassDescriptor classDescriptor) {
        Iterator iterator = this.userDefinedQueryKeys();
        while (iterator.hasNext()) {
            MWUserDefinedQueryKey mWUserDefinedQueryKey = (MWUserDefinedQueryKey)iterator.next();
            if (mWUserDefinedQueryKey.getColumn() == null) continue;
            classDescriptor.addDirectQueryKey(mWUserDefinedQueryKey.getName(), mWUserDefinedQueryKey.getColumn().qualifiedName());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWTableDescriptor.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWRelationalClassDescriptor.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("primaryTableHandle");
        xMLCompositeObjectMapping.setGetMethodName("getPrimaryTableHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setPrimaryTableHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWTableHandle.class);
        xMLCompositeObjectMapping.setXPath("primary-table-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping(USES_SEQUENCING_PROPERTY, "uses-sequencing/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.FALSE);
        XMLDirectMapping xMLDirectMapping2 = (XMLDirectMapping)xMLDescriptor.addDirectMapping(SEQUENCE_NUMBER_NAME_PROPERTY, "sequence-number-name/text()");
        xMLDirectMapping2.setNullValue((Object)"");
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("sequenceNumberTableHandle");
        xMLCompositeObjectMapping2.setGetMethodName("getSequenceNumberTableHandleForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setSequenceNumberTableHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWTableHandle.class);
        xMLCompositeObjectMapping2.setXPath("sequence-number-table-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLCompositeObjectMapping xMLCompositeObjectMapping3 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping3.setAttributeName("sequenceNumberColumnHandle");
        xMLCompositeObjectMapping3.setGetMethodName("getSequenceNumberColumnHandleForTopLink");
        xMLCompositeObjectMapping3.setSetMethodName("setSequenceNumberColumnHandleForTopLink");
        xMLCompositeObjectMapping3.setReferenceClass(MWColumnHandle.class);
        xMLCompositeObjectMapping3.setXPath("sequence-number-column-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping3);
        xMLDescriptor.addDirectMapping(CHANGE_TRACKING_TYPE_PROPERTY, "change-tracking-type/text()");
        XMLCompositeObjectMapping xMLCompositeObjectMapping4 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping4.setAttributeName(INTERFACE_ALIAS_POLICY_PROPERTY);
        xMLCompositeObjectMapping4.setReferenceClass(MWDescriptorInterfaceAliasPolicy.class);
        xMLCompositeObjectMapping4.setSetMethodName("setInterfaceAliasPolicyForTopLink");
        xMLCompositeObjectMapping4.setGetMethodName("getInterfaceAliasPolicyForTopLink");
        xMLCompositeObjectMapping4.setXPath("interface-alias-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping4);
        XMLCompositeObjectMapping xMLCompositeObjectMapping5 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping5.setAttributeName(MULTI_TABLE_INFO_POLICY_PROPERTY);
        xMLCompositeObjectMapping5.setReferenceClass(MWDescriptorMultiTableInfoPolicy.class);
        xMLCompositeObjectMapping5.setSetMethodName("setMultiTableInfoPolicyForTopLink");
        xMLCompositeObjectMapping5.setGetMethodName("getMultiTableInfoPolicyForTopLink");
        xMLCompositeObjectMapping5.setXPath("multi-table-info-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping5);
        XMLCompositeObjectMapping xMLCompositeObjectMapping6 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping6.setAttributeName("returningPolicy");
        xMLCompositeObjectMapping6.setReferenceClass(MWRelationalReturningPolicy.class);
        xMLCompositeObjectMapping6.setSetMethodName("setReturningPolicyForTopLink");
        xMLCompositeObjectMapping6.setGetMethodName("getReturningPolicyForTopLink");
        xMLCompositeObjectMapping6.setXPath("returning-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping6);
        return xMLDescriptor;
    }

    private MWTableHandle getPrimaryTableHandleForTopLink() {
        return this.primaryTableHandle.getTable() == null ? null : this.primaryTableHandle;
    }

    private void setPrimaryTableHandleForTopLink(MWTableHandle mWTableHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildPrimaryTableScrubber();
        this.primaryTableHandle = mWTableHandle == null ? new MWTableHandle(this, nodeReferenceScrubber) : mWTableHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWTableHandle getSequenceNumberTableHandleForTopLink() {
        return this.sequenceNumberTableHandle.getTable() == null ? null : this.sequenceNumberTableHandle;
    }

    private void setSequenceNumberTableHandleForTopLink(MWTableHandle mWTableHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildSequenceNumberTableScrubber();
        this.sequenceNumberTableHandle = mWTableHandle == null ? new MWTableHandle(this, nodeReferenceScrubber) : mWTableHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWColumnHandle getSequenceNumberColumnHandleForTopLink() {
        return this.sequenceNumberColumnHandle.getColumn() == null ? null : this.sequenceNumberColumnHandle;
    }

    private void setSequenceNumberColumnHandleForTopLink(MWColumnHandle mWColumnHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildSequenceNumberColumnScrubber();
        this.sequenceNumberColumnHandle = mWColumnHandle == null ? new MWColumnHandle(this, nodeReferenceScrubber) : mWColumnHandle.setScrubber(nodeReferenceScrubber);
    }
}

