/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWXmlPrimaryKeyPolicy
extends MWModel
implements MWXmlNode,
MWXpathContext {
    protected List primaryKeys;
    public static final String PRIMARY_KEYS_COLLECTION = "primaryKeys";

    private MWXmlPrimaryKeyPolicy() {
    }

    MWXmlPrimaryKeyPolicy(MWAbstractTransactionalPolicy mWAbstractTransactionalPolicy) {
        super(mWAbstractTransactionalPolicy);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.primaryKeys = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        List list2 = this.primaryKeys;
        synchronized (list2) {
            list.addAll(this.primaryKeys);
        }
    }

    public Iterator primaryKeys() {
        return new CloneIterator(this.primaryKeys);
    }

    public int primaryKeysSize() {
        return this.primaryKeys.size();
    }

    public void clearPrimaryKeys() {
        this.primaryKeys.clear();
        this.fireCollectionChanged(PRIMARY_KEYS_COLLECTION);
    }

    public Iterator primaryKeyXpaths() {
        return new TransformationIterator(this.primaryKeys()){

            protected Object transform(Object object) {
                return ((MWXmlField)object).getXpath();
            }
        };
    }

    public MWXmlField addPrimaryKey(String string) {
        MWXmlField mWXmlField = this.buildEmptyPrimaryKey();
        mWXmlField.setXpath(string);
        this.addPrimaryKey(mWXmlField);
        return mWXmlField;
    }

    public MWXmlField buildEmptyPrimaryKey() {
        return new MWXmlField(this);
    }

    public void addPrimaryKey(MWXmlField mWXmlField) {
        this.addItemToCollection(mWXmlField, this.primaryKeys, PRIMARY_KEYS_COLLECTION);
    }

    public void removePrimaryKey(MWXmlField mWXmlField) {
        this.removeItemFromCollection(mWXmlField, this.primaryKeys, PRIMARY_KEYS_COLLECTION);
    }

    public MWSchemaContextComponent schemaContext(MWXmlField mWXmlField) {
        return this.xmlDescriptor().getSchemaContext();
    }

    private MWXmlDescriptor xmlDescriptor() {
        return (MWXmlDescriptor)this.getParent().getParent();
    }

    public MWXpathSpec xpathSpec(MWXmlField mWXmlField) {
        return this.buildXpathSpec();
    }

    protected MWXpathSpec buildXpathSpec() {
        return new MWXpathSpec(){

            public boolean mayUseCollectionData() {
                return false;
            }

            public boolean mayUseComplexData() {
                return false;
            }

            public boolean mayUseSimpleData() {
                return true;
            }
        };
    }

    public void resolveXpaths() {
        Iterator iterator = this.primaryKeys();
        while (iterator.hasNext()) {
            ((MWXmlNode)iterator.next()).resolveXpaths();
        }
    }

    public void schemaChanged(SchemaChange schemaChange) {
        Iterator iterator = this.primaryKeys();
        while (iterator.hasNext()) {
            ((MWXmlNode)iterator.next()).schemaChanged(schemaChange);
        }
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        Iterator iterator = this.primaryKeys();
        while (iterator.hasNext()) {
            classDescriptor.addPrimaryKeyField(((MWDataField)iterator.next()).runtimeField());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWXmlPrimaryKeyPolicy.class);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setReferenceClass(MWXmlField.class);
        xMLCompositeCollectionMapping.setAttributeName(PRIMARY_KEYS_COLLECTION);
        xMLCompositeCollectionMapping.setGetMethodName("getPrimaryKeysForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setPrimaryKeysForTopLink");
        xMLCompositeCollectionMapping.setXPath("primary-keys/xml-field");
        xMLCompositeCollectionMapping.useCollectionClass(Vector.class);
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    private List getPrimaryKeysForTopLink() {
        return CollectionTools.list(this.specifiedPrimaryKeys());
    }

    private Iterator specifiedPrimaryKeys() {
        return new FilteringIterator(this.primaryKeys()){

            protected boolean accept(Object object) {
                return ((MWXmlField)object).isSpecified();
            }
        };
    }

    private void setPrimaryKeysForTopLink(List list) {
        this.primaryKeys = list;
    }
}

