/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.generation;

import java.text.Collator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;

public class MWRelationshipHolder
implements Comparable {
    private volatile MWReference reference;
    private volatile boolean foreignKeyInTargetTable;
    private volatile String relationshipType;
    private static String ONE_TO_MANY = "oneToMany";
    private static String ONE_TO_ONE = "oneToOne";

    public MWRelationshipHolder(MWReference mWReference, boolean bl) {
        this.reference = mWReference;
        this.foreignKeyInTargetTable = bl;
    }

    public boolean canMapOneToMany() {
        return this.foreignKeyInTargetTable;
    }

    public boolean canMapOneToOne() {
        return true;
    }

    public int compareTo(Object object) {
        MWRelationshipHolder mWRelationshipHolder = (MWRelationshipHolder)object;
        if (this.getReference().getName().equals(mWRelationshipHolder.getReference().getName())) {
            return Collator.getInstance().compare(this.displayString(), mWRelationshipHolder.displayString());
        }
        return Collator.getInstance().compare(this.getReference().getName(), mWRelationshipHolder.getReference().getName());
    }

    public String displayString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        MWTable mWTable = this.getRelationshipSourceTable();
        stringBuffer.append(mWTable.getShortName());
        if (this.reference.columnPairsSize() > 0) {
            stringBuffer.append(" (");
            object2 = this.reference.columnPairs();
            while (object2.hasNext()) {
                object = (MWColumnPair)object2.next();
                if (this.foreignKeyInTargetTable) {
                    if (((MWColumnPair)object).getTargetColumn() != null) {
                        stringBuffer.append(((MWColumnPair)object).getTargetColumn().getName());
                    }
                } else if (((MWColumnPair)object).getSourceColumn() != null) {
                    stringBuffer.append(((MWColumnPair)object).getSourceColumn().getName());
                }
                if (!object2.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        stringBuffer.append(" -> ");
        object2 = this.getRelationshipTargetTable();
        stringBuffer.append(((MWTable)object2).getShortName());
        if (this.reference.columnPairsSize() > 0) {
            stringBuffer.append(" (");
            object = this.reference.columnPairs();
            while (object.hasNext()) {
                MWColumnPair mWColumnPair = (MWColumnPair)object.next();
                if (this.foreignKeyInTargetTable) {
                    if (mWColumnPair.getSourceColumn() != null) {
                        stringBuffer.append(mWColumnPair.getSourceColumn().getName());
                    }
                } else if (mWColumnPair.getTargetColumn() != null) {
                    stringBuffer.append(mWColumnPair.getTargetColumn().getName());
                }
                if (!object.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    protected MWReference getReference() {
        return this.reference;
    }

    public MWTable getRelationshipSourceTable() {
        if (this.foreignKeyInTargetTable) {
            return this.reference.getTargetTable();
        }
        return this.reference.getSourceTable();
    }

    public MWTable getRelationshipTargetTable() {
        if (this.foreignKeyInTargetTable) {
            return this.reference.getSourceTable();
        }
        return this.reference.getTargetTable();
    }

    public boolean isForeignKeyInTargetTable() {
        return this.foreignKeyInTargetTable;
    }

    public boolean isOneToMany() {
        return this.relationshipType == ONE_TO_MANY;
    }

    public boolean isOneToOne() {
        return this.relationshipType == ONE_TO_ONE;
    }

    public void setNoRelationship() {
        this.relationshipType = null;
    }

    public void setOneToMany() {
        this.relationshipType = ONE_TO_MANY;
    }

    public void setOneToOne() {
        this.relationshipType = ONE_TO_ONE;
    }
}

