/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.text.Collator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWConverterMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConverter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWObjectTypeConverter
extends MWTypeConverter {
    private Collection valuePairs;
    public static final String VALUE_PAIRS_COLLECTION = "valuePairs";
    private volatile ValuePair defaultValuePair;
    public static final String DEFAULT_ATTRIBUTE_VALUE_PROPERTY = "defaultAttributeProperty";

    private MWObjectTypeConverter() {
    }

    public MWObjectTypeConverter(MWConverterMapping mWConverterMapping) {
        super(mWConverterMapping);
    }

    public MWObjectTypeConverter(MWConverterMapping mWConverterMapping, Map map) {
        super(mWConverterMapping, map);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.valuePairs = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.valuePairs;
        synchronized (collection) {
            list.addAll(this.valuePairs);
        }
    }

    public Iterator valuePairs() {
        return new CloneIterator(this.valuePairs);
    }

    public int valuePairsSize() {
        return this.valuePairs.size();
    }

    public void addValuePair(String string, String string2) throws ConversionValueException, ConversionException {
        Object object = this.buildAttributeValue(string2);
        Object object2 = this.buildDataValue(string);
        this.addValuePair(object2, object);
    }

    public ValuePair addValuePair(Object object, Object object2) throws ConversionValueException {
        if (this.duplicateDataValue(object)) {
            throw ConversionValueException.duplicateDataValueException(object);
        }
        if (this.duplicateAttributeValue(object2)) {
            throw ConversionValueException.duplicateAttributeValueException(object2);
        }
        ValuePair valuePair = new ValuePair(this, object, object2);
        this.addValuePairInternal(valuePair);
        return valuePair;
    }

    public void editValuePair(ValuePair valuePair, String string, String string2) throws ConversionValueException, ConversionException {
        Object object = this.buildDataValue(string);
        Object object2 = this.buildAttributeValue(string2);
        if (!valuePair.dataValue.equals(object) && this.duplicateDataValue(object)) {
            throw ConversionValueException.duplicateDataValueException(object);
        }
        if (!valuePair.attributeValue.equals(object2) && this.duplicateAttributeValue(object2)) {
            throw ConversionValueException.duplicateAttributeValueException(object2);
        }
        valuePair.setDataValue(object);
        valuePair.setAttributeValue(object2);
    }

    public void removeValuePair(ValuePair valuePair) {
        this.valuePairs.remove(valuePair);
        this.fireItemRemoved(VALUE_PAIRS_COLLECTION, valuePair);
        if (this.defaultValuePair == valuePair) {
            this.setDefaultValuePair(null);
        }
    }

    public void clearValuePairs() {
        this.valuePairs.clear();
        this.fireCollectionChanged(VALUE_PAIRS_COLLECTION);
        this.setDefaultValuePair(null);
    }

    public Object getDefaultAttributeValue() {
        return this.defaultValuePair == null ? null : this.defaultValuePair.attributeValue;
    }

    public void setDefaultAttributeValue(Object object) {
        this.setDefaultValuePair(this.valuePairForAttributeValue(object));
    }

    public void setDefaultAttributeValue(String string) throws ConversionException {
        this.setDefaultAttributeValue(this.buildAttributeValue(string));
    }

    public String accessibleNameKey() {
        return "ACCESSIBLE_SERIALIZED_MAPPING_NODE";
    }

    public String getType() {
        return "object-type-converter";
    }

    public String iconKey() {
        return "mapping.objectType";
    }

    private Iterator dataValues() {
        return new TransformationIterator(this.valuePairs()){

            protected Object transform(Object object) {
                return ((ValuePair)object).dataValue;
            }
        };
    }

    private Iterator attributeValues() {
        return new TransformationIterator(this.valuePairs()){

            protected Object transform(Object object) {
                return ((ValuePair)object).attributeValue;
            }
        };
    }

    private void addValuePairInternal(ValuePair valuePair) {
        this.valuePairs.add(valuePair);
        this.fireItemAdded(VALUE_PAIRS_COLLECTION, valuePair);
    }

    protected void rebuildValuePairs() {
        Iterator iterator = this.valuePairs();
        this.clearValuePairs();
        if (this.getDataType() == null || this.getAttributeType() == null) {
            return;
        }
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            ValuePair valuePair = (ValuePair)iterator2.next();
            ValuePair valuePair2 = null;
            try {
                valuePair2 = this.addValuePair(this.buildDataValue(valuePair.dataValue), this.buildAttributeValue(valuePair.attributeValue));
            }
            catch (ConversionException conversionException) {
            }
            catch (ConversionValueException conversionValueException) {
                // empty catch block
            }
            if (this.defaultValuePair != valuePair) continue;
            this.setDefaultValuePair(valuePair2);
        }
    }

    private boolean duplicateDataValue(Object object) {
        Iterator iterator = this.dataValues();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(object)) continue;
            return true;
        }
        return false;
    }

    private boolean duplicateAttributeValue(Object object) {
        Iterator iterator = this.attributeValues();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(object)) continue;
            return true;
        }
        return false;
    }

    private ValuePair valuePairForAttributeValue(Object object) {
        Iterator iterator = this.valuePairs();
        while (iterator.hasNext()) {
            ValuePair valuePair = (ValuePair)iterator.next();
            if (!valuePair.attributeValue.equals(object)) continue;
            return valuePair;
        }
        if (object == null) {
            return null;
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    private void setDefaultValuePair(ValuePair valuePair) {
        Object object = this.defaultValuePair == null ? null : this.defaultValuePair.attributeValue;
        this.defaultValuePair = valuePair;
        Object object2 = this.defaultValuePair == null ? null : this.defaultValuePair.attributeValue;
        this.firePropertyChanged(DEFAULT_ATTRIBUTE_VALUE_PROPERTY, object, object2);
    }

    private Object buildAttributeValue(Object object) throws ConversionException {
        Class clazz = null;
        try {
            clazz = ClassTools.classForTypeDeclaration(this.getAttributeType().typeName(), this.getAttributeType().getDimensionality());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        return ConversionManager.getDefaultManager().convertObject(object, clazz);
    }

    private Object buildDataValue(Object object) throws ConversionException {
        Class clazz = null;
        try {
            clazz = ClassTools.classForTypeDeclaration(this.getDataType().typeName(), this.getDataType().getDimensionality());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        return ConversionManager.getDefaultManager().convertObject(object, clazz);
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkValuePairs(list);
    }

    private void checkValuePairs(List list) {
        if (this.valuePairsSize() == 0) {
            list.add(this.buildProblem("0542"));
        }
    }

    public Converter runtimeConverter(DatabaseMapping databaseMapping) {
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter(databaseMapping);
        Iterator iterator = this.valuePairs();
        while (iterator.hasNext()) {
            ValuePair valuePair = (ValuePair)iterator.next();
            objectTypeConverter.addConversionValue(valuePair.dataValue, valuePair.attributeValue);
        }
        objectTypeConverter.setDefaultAttributeValue(this.getDefaultAttributeValue());
        return objectTypeConverter;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWObjectTypeConverter.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWTypeConverter.class);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(VALUE_PAIRS_COLLECTION);
        xMLCompositeCollectionMapping.setXPath("value-pairs/value-pair");
        xMLCompositeCollectionMapping.setGetMethodName("getValuePairsForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setValuePairsForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(ValuePair.class);
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        xMLDescriptor.addDirectMapping("defaultValuePair", "getDefaultAttributeValueForTopLink", "setDefaultAttributeValueForTopLink", "default-attribute-value/text()");
        return xMLDescriptor;
    }

    public void postProjectBuild() {
        super.postProjectBuild();
        Iterator iterator = this.valuePairs();
        while (iterator.hasNext()) {
            ValuePair valuePair = (ValuePair)iterator.next();
            valuePair.attributeValue = this.buildAttributeValue(valuePair.attributeValue);
            valuePair.dataValue = this.buildDataValue(valuePair.dataValue);
        }
    }

    private Collection getValuePairsForTopLink() {
        return CollectionTools.sort((List)this.valuePairs);
    }

    private void setValuePairsForTopLink(Collection collection) {
        this.valuePairs = collection;
    }

    private Object getDefaultAttributeValueForTopLink() {
        return this.getDefaultAttributeValue();
    }

    private void setDefaultAttributeValueForTopLink(Object object) {
        this.defaultValuePair = this.valuePairForAttributeValue(object);
    }

    public static class ConversionValueException
    extends Exception {
        private int error;
        private static final int DUPLICATE_DATA_VALUE = 0;
        private static final int DUPLICATE_ATTRIBUTE_VALUE = 1;
        private Object value;

        private ConversionValueException(int n, Object object) {
            this.error = n;
            this.value = object;
        }

        public static ConversionValueException duplicateDataValueException(Object object) {
            return new ConversionValueException(0, object);
        }

        public static ConversionValueException duplicateAttributeValueException(Object object) {
            return new ConversionValueException(1, object);
        }

        public boolean isRepeatedDataValue() {
            return this.error == 0;
        }

        public boolean isRepeatedAttributeValue() {
            return this.error == 1;
        }
    }

    public static class ValuePair
    extends MWModel
    implements Comparable {
        Object dataValue;
        public static final String DATA_VALUE_PROPERTY = "dataValue";
        Object attributeValue;
        public static final String ATTRIBUTE_VALUE_PROPERTY = "attributeValue";
        public static final String DEFAULT_ATTRIBUTE_VALUE_PROPERTY = "defaultAttributeValue";

        private ValuePair() {
        }

        private ValuePair(MWObjectTypeConverter mWObjectTypeConverter, Object object, Object object2) {
            super(mWObjectTypeConverter);
            this.dataValue = object;
            this.attributeValue = object2;
        }

        public Object getDataValue() {
            return this.dataValue;
        }

        public String getDataValueAsString() {
            return (String)ConversionManager.getDefaultManager().convertObject(this.dataValue, String.class);
        }

        private void setDataValue(Object object) {
            Object object2 = this.dataValue;
            this.dataValue = object;
            this.firePropertyChanged(DATA_VALUE_PROPERTY, object2, object);
        }

        public Object getAttributeValue() {
            return this.attributeValue;
        }

        public String getAttributeValueAsString() {
            return (String)ConversionManager.getDefaultManager().convertObject(this.attributeValue, String.class);
        }

        private void setAttributeValue(Object object) {
            Object object2 = this.attributeValue;
            this.attributeValue = object;
            this.firePropertyChanged(ATTRIBUTE_VALUE_PROPERTY, object2, object);
        }

        public boolean isDefaultAttributeValue() {
            return this.attributeValue == this.getObjectTypeConverter().getDefaultAttributeValue();
        }

        public void setDefaultAttributeValue(boolean bl) {
            boolean bl2;
            ValuePair valuePair = this.getObjectTypeConverter().defaultValuePair;
            boolean bl3 = bl2 = valuePair == this;
            if (bl == bl2) {
                return;
            }
            if (bl2) {
                this.getObjectTypeConverter().setDefaultAttributeValue(null);
            } else if (bl) {
                if (valuePair != null) {
                    valuePair.setDefaultAttributeValue(false);
                }
                this.getObjectTypeConverter().setDefaultAttributeValue(this.attributeValue);
            }
            this.firePropertyChanged(DEFAULT_ATTRIBUTE_VALUE_PROPERTY, bl2, bl);
        }

        public MWObjectTypeConverter getObjectTypeConverter() {
            return (MWObjectTypeConverter)this.getMWParent();
        }

        public int compareTo(Object object) {
            return Collator.getInstance().compare(this.dataValue.toString(), ((ValuePair)object).dataValue.toString());
        }

        public static XMLDescriptor buildDescriptor() {
            XMLDescriptor xMLDescriptor = new XMLDescriptor();
            xMLDescriptor.setJavaClass(ValuePair.class);
            xMLDescriptor.addDirectMapping(DATA_VALUE_PROPERTY, "getDataValueForTopLink", "setDataValueForTopLink", "data-value/text()");
            xMLDescriptor.addDirectMapping(ATTRIBUTE_VALUE_PROPERTY, "getAttributeValueForTopLink", "setAttributeValueForTopLink", "attribute-value/text()");
            return xMLDescriptor;
        }

        private Object getDataValueForTopLink() {
            return this.getDataValueAsString();
        }

        private void setDataValueForTopLink(Object object) {
            this.dataValue = object;
        }

        private Object getAttributeValueForTopLink() {
            return this.getAttributeValueAsString();
        }

        private void setAttributeValueForTopLink(Object object) {
            this.attributeValue = object;
        }

        public void toString(StringBuffer stringBuffer) {
            stringBuffer.append(this.dataValue);
            stringBuffer.append(" => ");
            stringBuffer.append(this.attributeValue);
        }
    }
}

