/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.util.ListIterator;
import org.eclipse.persistence.internal.codegen.NonreflectiveMethodDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethodParameter;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class MWMethodCodeGenPolicy {
    private volatile MWClassCodeGenPolicy classCodeGenPolicy;
    private volatile MWMethod method;
    private static final String ARRAY_SUFFIX = "Array";
    private static final String A_ARTICLE = "a";
    private static final String AN_ARTICLE = "an";

    MWMethodCodeGenPolicy(MWMethod mWMethod, MWClassCodeGenPolicy mWClassCodeGenPolicy) {
        this.method = mWMethod;
        this.classCodeGenPolicy = mWClassCodeGenPolicy;
    }

    MWClassCodeGenPolicy getClassCodeGenPolicy() {
        return this.classCodeGenPolicy;
    }

    MWMethod getMethod() {
        return this.method;
    }

    void insertArguments(NonreflectiveMethodDefinition nonreflectiveMethodDefinition) {
        ListIterator listIterator = this.getMethod().methodParameters();
        while (listIterator.hasNext()) {
            this.addArgument(nonreflectiveMethodDefinition, (MWMethodParameter)listIterator.next());
        }
    }

    void insertMethodBody(NonreflectiveMethodDefinition nonreflectiveMethodDefinition) {
        nonreflectiveMethodDefinition.addLine(this.classCodeGenPolicy.emptyMethodBodyComment());
        if (!this.method.isConstructor() && !this.method.getReturnType().isVoid()) {
            nonreflectiveMethodDefinition.addLine("return " + this.method.getReturnTypeDeclaration().defaultReturnValueString() + ";");
        }
    }

    protected void addArgument(NonreflectiveMethodDefinition nonreflectiveMethodDefinition, MWMethodParameter mWMethodParameter) {
        nonreflectiveMethodDefinition.addArgument(mWMethodParameter.declaration(), this.uniqueParameterName(mWMethodParameter, nonreflectiveMethodDefinition));
    }

    protected String uniqueParameterName(MWMethodParameter mWMethodParameter, NonreflectiveMethodDefinition nonreflectiveMethodDefinition) {
        String string = mWMethodParameter.getType().shortName();
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        if (StringTools.charIsVowel(string.charAt(0))) {
            stringBuffer.append(AN_ARTICLE);
        } else {
            stringBuffer.append(A_ARTICLE);
        }
        StringTools.capitalizeOn(string, stringBuffer);
        if (mWMethodParameter.getDimensionality() > 0) {
            stringBuffer.append(ARRAY_SUFFIX);
        }
        return NameTools.uniqueNameFor(stringBuffer.toString(), nonreflectiveMethodDefinition.argumentNames());
    }
}

