/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.project;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWNullCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWTransactionalProjectCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWEisProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWOXProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWProjectDefaultsPolicy
extends MWModel {
    public static final String COPY_POLICY = "Copy Policy";
    public static final String AFTER_LOAD_POLICY = "After Load";
    public static final String INSTANTIATION_POLICY = "Instantiation";
    public static final String INHERITANCE_POLICY = "Inheritance";
    private Collection defaultPolicies;
    public static final String DEFAULT_POLICY_COLLECTION = "defaultPolicyCollection";
    private Map policyBuilderMap;
    private MWCachingPolicy cachingPolicy;
    private volatile boolean methodAccessing;
    public static final String METHOD_ACCESSING_PROPERTY = "methodAccessing";

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWProjectDefaultsPolicy.class);
        InheritancePolicy inheritancePolicy = xMLDescriptor.getInheritancePolicy();
        inheritancePolicy.setClassIndicatorFieldName("@type");
        inheritancePolicy.addClassIndicator(MWRelationalProjectDefaultsPolicy.class, (Object)"relational");
        inheritancePolicy.addClassIndicator(MWEisProjectDefaultsPolicy.class, (Object)"eis");
        inheritancePolicy.addClassIndicator(MWOXProjectDefaultsPolicy.class, (Object)"o-x");
        xMLDescriptor.addDirectMapping(METHOD_ACCESSING_PROPERTY, "use-method-accessing/text()");
        XMLCompositeDirectCollectionMapping xMLCompositeDirectCollectionMapping = new XMLCompositeDirectCollectionMapping();
        xMLCompositeDirectCollectionMapping.setAttributeName("defaultPolicies");
        xMLCompositeDirectCollectionMapping.setXPath("default-descriptor-policies/policy-type/text()");
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)COPY_POLICY, (Object)COPY_POLICY);
        objectTypeConverter.addConversionValue((Object)AFTER_LOAD_POLICY, (Object)AFTER_LOAD_POLICY);
        objectTypeConverter.addConversionValue((Object)INSTANTIATION_POLICY, (Object)INSTANTIATION_POLICY);
        objectTypeConverter.addConversionValue((Object)INHERITANCE_POLICY, (Object)INHERITANCE_POLICY);
        objectTypeConverter.addConversionValue((Object)"Events", (Object)"Events");
        objectTypeConverter.addConversionValue((Object)"Returning", (Object)"Returning");
        objectTypeConverter.addConversionValue((Object)"Interface Alias", (Object)"Interface Alias");
        objectTypeConverter.addConversionValue((Object)"Multi-Table Info", (Object)"Multi-Table Info");
        xMLCompositeDirectCollectionMapping.setValueConverter((Converter)objectTypeConverter);
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeDirectCollectionMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("cachingPolicy");
        xMLCompositeObjectMapping.setSetMethodName("setProjectCachingPolicyForTopLink");
        xMLCompositeObjectMapping.setGetMethodName("getProjectCachingPolicyForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWTransactionalProjectCachingPolicy.class);
        xMLCompositeObjectMapping.setXPath("caching-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    protected MWProjectDefaultsPolicy() {
    }

    public MWProjectDefaultsPolicy(MWModel mWModel) {
        super(mWModel);
    }

    protected void initialize() {
        super.initialize();
        this.policyBuilderMap = new HashMap();
        this.initializePolicyDescriptors();
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.defaultPolicies = new Vector();
        this.cachingPolicy = this.buildCachingPolicy();
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.cachingPolicy);
    }

    protected MWCachingPolicy buildCachingPolicy() {
        return new MWNullCachingPolicy(this);
    }

    protected void initializePolicyDescriptors() {
        this.addPolicyDescriptor(COPY_POLICY, new CopyPolicyDescriptor());
        this.addPolicyDescriptor(AFTER_LOAD_POLICY, new AfterLoadPolicyDescriptor());
        this.addPolicyDescriptor(INHERITANCE_POLICY, new InheritancePolicyDescriptor());
        this.addPolicyDescriptor(INSTANTIATION_POLICY, new InstantiationPolicyDescriptor());
    }

    public Iterator defaultPolicies() {
        return this.defaultPolicies.iterator();
    }

    protected void addPolicyDescriptor(String string, PolicyDescriptor policyDescriptor) {
        this.policyBuilderMap.put(string, policyDescriptor);
    }

    protected PolicyDescriptor getPolicyDescriptor(String string) {
        return (PolicyDescriptor)this.policyBuilderMap.get(string);
    }

    public void applyAdvancedPolicyDefaults(MWMappingDescriptor mWMappingDescriptor) {
        Iterator iterator = this.defaultPolicies.iterator();
        while (iterator.hasNext()) {
            this.getPolicyDescriptor((String)iterator.next()).applyPolicyToDescriptor(mWMappingDescriptor);
        }
    }

    public boolean containsAdvancePolicyDefault(String string) {
        return this.defaultPolicies.contains(string);
    }

    public void addAdvancedPolicyDefault(String string) {
        this.defaultPolicies.add(string);
        this.fireItemAdded(DEFAULT_POLICY_COLLECTION, string);
    }

    public void removeAdvancedPolicyDefault(String string) {
        this.defaultPolicies.remove(string);
        this.fireItemRemoved(DEFAULT_POLICY_COLLECTION, string);
    }

    public MWCachingPolicy getCachingPolicy() {
        return this.cachingPolicy;
    }

    public boolean isMethodAccessing() {
        return this.methodAccessing;
    }

    public void setMethodAccessing(boolean bl) {
        boolean bl2 = this.methodAccessing;
        this.methodAccessing = bl;
        this.firePropertyChanged(METHOD_ACCESSING_PROPERTY, bl2, this.methodAccessing);
    }

    private MWTransactionalProjectCachingPolicy getProjectCachingPolicyForTopLink() {
        return (MWTransactionalProjectCachingPolicy)this.cachingPolicy.getPersistedPolicy();
    }

    private void setProjectCachingPolicyForTopLink(MWTransactionalProjectCachingPolicy mWTransactionalProjectCachingPolicy) {
        this.cachingPolicy = mWTransactionalProjectCachingPolicy == null ? this.buildCachingPolicy() : mWTransactionalProjectCachingPolicy;
    }

    protected void adjustRuntimeProject(Project project) {
    }

    private class InheritancePolicyDescriptor
    implements PolicyDescriptor {
        private InheritancePolicyDescriptor() {
        }

        public void applyPolicyToDescriptor(MWMappingDescriptor mWMappingDescriptor) {
            if (!mWMappingDescriptor.getInheritancePolicy().isActive()) {
                mWMappingDescriptor.addInheritancePolicy();
            }
        }
    }

    private class InstantiationPolicyDescriptor
    implements PolicyDescriptor {
        private InstantiationPolicyDescriptor() {
        }

        public void applyPolicyToDescriptor(MWMappingDescriptor mWMappingDescriptor) {
            if (!mWMappingDescriptor.getInstantiationPolicy().isActive()) {
                mWMappingDescriptor.addInstantiationPolicy();
            }
        }
    }

    private class CopyPolicyDescriptor
    implements PolicyDescriptor {
        private CopyPolicyDescriptor() {
        }

        public void applyPolicyToDescriptor(MWMappingDescriptor mWMappingDescriptor) {
            if (!mWMappingDescriptor.getCopyPolicy().isActive()) {
                mWMappingDescriptor.addCopyPolicy();
            }
        }
    }

    private class AfterLoadPolicyDescriptor
    implements PolicyDescriptor {
        private AfterLoadPolicyDescriptor() {
        }

        public void applyPolicyToDescriptor(MWMappingDescriptor mWMappingDescriptor) {
            if (!mWMappingDescriptor.getAfterLoadingPolicy().isActive()) {
                mWMappingDescriptor.addAfterLoadingPolicy();
            }
        }
    }

    protected static interface PolicyDescriptor {
        public void applyPolicyToDescriptor(MWMappingDescriptor var1);
    }
}

