/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.LogicalExpression;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWExpressionQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Undoable;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWCompoundExpression
extends MWExpression {
    private List expressions;
    public static final String EXPRESSIONS_LIST = "expressions";
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String NAND = "NAND";
    public static final String NOR = "NOR";
    private Stack changes;
    public static final String ADD_EXPRESSION = "addExpression";
    public static final String REMOVE_EXPRESSION = "removeExpression";
    public static final String CLEARED_EXPRESSIONS = "clearedExpressions";

    private MWCompoundExpression() {
    }

    MWCompoundExpression(MWModel mWModel) {
        super(mWModel, AND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        List list2 = this.expressions;
        synchronized (list2) {
            list.addAll(this.expressions);
        }
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.expressions = new Vector();
    }

    protected void initialize() {
        super.initialize();
        this.changes = new Stack();
    }

    private void addExpression(MWExpression mWExpression) {
        this.expressions.add(mWExpression);
        this.fireItemAdded(EXPRESSIONS_LIST, this.expressions.lastIndexOf(mWExpression), mWExpression);
        this.getRootCompoundExpression().propertyChanged(this, ADD_EXPRESSION, mWExpression);
    }

    public MWBasicExpression addBasicExpression() {
        MWBasicExpression mWBasicExpression = new MWBasicExpression(this, "EQUAL");
        this.addExpression(mWBasicExpression);
        return mWBasicExpression;
    }

    public MWCompoundExpression addSubCompoundExpression() {
        MWCompoundExpression mWCompoundExpression = new MWCompoundExpression(this);
        this.addExpression(mWCompoundExpression);
        mWCompoundExpression.addBasicExpression();
        return mWCompoundExpression;
    }

    public int expressionsSize() {
        return this.expressions.size();
    }

    public ListIterator expressions() {
        return new CloneListIterator(this.expressions);
    }

    public MWExpression getExpression(int n) {
        return (MWExpression)this.expressions.get(n);
    }

    public String getIndex() {
        if (this.getParentCompoundExpression() == null) {
            return "";
        }
        return this.getParentCompoundExpression().getIndex() + Integer.toString(this.getParentCompoundExpression().getIndexOf(this)) + ".";
    }

    int getIndexOf(MWExpression mWExpression) {
        ListIterator listIterator = this.expressions();
        int n = 1;
        while (listIterator.hasNext()) {
            if (listIterator.next() == mWExpression) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void clearExpressions() {
        for (int i = 0; i < this.expressions.size(); ++i) {
            this.removeExpression((MWExpression)this.expressions.get(i));
        }
    }

    public void removeExpression(MWExpression mWExpression) {
        int n = this.expressions.lastIndexOf(mWExpression);
        mWExpression.clearExpressions();
        this.expressions.remove(mWExpression);
        this.fireItemRemoved(EXPRESSIONS_LIST, n, mWExpression);
        this.getRootCompoundExpression().propertyChanged(this, REMOVE_EXPRESSION, mWExpression);
    }

    public String displayString() {
        return this.getOperatorType();
    }

    public MWCompoundExpression getParentCompoundExpression() {
        if (this.getParent().getClass().isAssignableFrom(MWExpressionQueryFormat.class)) {
            return null;
        }
        return (MWCompoundExpression)this.getParent();
    }

    public MWQuery getParentQuery() {
        if (this.getParent().getClass().isAssignableFrom(MWExpressionQueryFormat.class)) {
            return ((MWQueryFormat)this.getParent()).getQuery();
        }
        return ((MWCompoundExpression)this.getParent()).getParentQuery();
    }

    public MWCompoundExpression getRootCompoundExpression() {
        if (this.getParent().getClass().isAssignableFrom(MWExpressionQueryFormat.class)) {
            return this;
        }
        return ((MWCompoundExpression)this.getParent()).getRootCompoundExpression();
    }

    void recalculateQueryables() {
        ListIterator listIterator = this.expressions();
        while (listIterator.hasNext()) {
            ((MWExpression)listIterator.next()).recalculateQueryables();
        }
    }

    public void clearChanges() {
        this.changes.clear();
    }

    public void undoChange(String string, Object object, Object object2) {
        super.undoChange(string, object, object2);
        if (string == ADD_EXPRESSION) {
            this.removeExpression((MWExpression)object2);
        } else if (string == REMOVE_EXPRESSION) {
            this.addExpression((MWExpression)object2);
        } else if (string == CLEARED_EXPRESSIONS) {
            // empty if block
        }
    }

    void propertyChanged(Undoable undoable, String string, Object object, Object object2) {
        this.changes.push(new PropertyChangeHolder(undoable, string, object, object2));
    }

    void propertyChanged(Undoable undoable, String string, Object object) {
        this.changes.push(new PropertyChangeHolder(undoable, string, object));
    }

    public void restoreChanges() {
        Stack stack = new Stack();
        stack.addAll(this.changes);
        while (!stack.isEmpty()) {
            PropertyChangeHolder propertyChangeHolder = (PropertyChangeHolder)stack.pop();
            propertyChangeHolder.undoChange();
        }
        this.clearChanges();
    }

    public void toString(StringBuffer stringBuffer) {
        super.toString(stringBuffer);
        stringBuffer.append("operator = ");
        stringBuffer.append(this.getOperatorType());
        stringBuffer.append(", expressions = ");
        stringBuffer.append('(');
        ListIterator listIterator = this.expressions();
        while (listIterator.hasNext()) {
            MWExpression mWExpression = (MWExpression)listIterator.next();
            stringBuffer.append(mWExpression);
            if (!listIterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWCompoundExpression.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWExpression.class);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(EXPRESSIONS_LIST);
        xMLCompositeCollectionMapping.setReferenceClass(MWExpression.class);
        xMLCompositeCollectionMapping.setXPath("expression-list/expression");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    Expression buildRuntimeExpression(ExpressionBuilder expressionBuilder) {
        int n;
        Expression expression = null;
        boolean bl = false;
        if (this.getOperatorType() == AND) {
            n = 1;
        } else if (this.getOperatorType() == OR) {
            n = 2;
        } else if (this.getOperatorType() == NAND) {
            n = 1;
            bl = true;
        } else {
            n = 2;
            bl = true;
        }
        if (this.expressionsSize() > 0) {
            expression = expressionBuilder.and(((MWExpression)this.expressions.get(0)).buildRuntimeExpression(expressionBuilder));
            for (int i = 0; i < this.expressionsSize() - 1; ++i) {
                Expression expression2 = ((MWExpression)this.expressions.get(i + 1)).buildRuntimeExpression(expressionBuilder);
                expression = n == 1 ? expressionBuilder.and(expression).and(expression2) : expressionBuilder.or(expression).or(expression2);
            }
        }
        if (bl) {
            return expression.not();
        }
        return expression;
    }

    static MWCompoundExpression convertFromRuntime(MWModel mWModel, Expression expression) {
        MWCompoundExpression mWCompoundExpression = new MWCompoundExpression(mWModel);
        if (expression.isRelationExpression()) {
            mWCompoundExpression.addExpression(MWBasicExpression.convertFromRuntime(mWCompoundExpression, expression));
            mWCompoundExpression.setOperatorType(AND);
        } else {
            ExpressionOperator expressionOperator = expression.getOperator();
            boolean bl = false;
            if (expressionOperator == ExpressionOperator.getOperator((Integer)new Integer(3))) {
                expression = ((FunctionExpression)expression).getBaseExpression();
                bl = true;
                expressionOperator = expression.getOperator();
            }
            if (expressionOperator == ExpressionOperator.getOperator((Integer)new Integer(1))) {
                if (!bl) {
                    mWCompoundExpression.setOperatorType(AND);
                } else {
                    mWCompoundExpression.setOperatorType(NAND);
                }
            } else if (expressionOperator == ExpressionOperator.getOperator((Integer)new Integer(2))) {
                if (!bl) {
                    mWCompoundExpression.setOperatorType(OR);
                } else {
                    mWCompoundExpression.setOperatorType(NOR);
                }
            } else {
                if (expression.isFunctionExpression()) {
                    mWCompoundExpression.addExpression(MWBasicExpression.convertFromRuntime(mWCompoundExpression, expression));
                    return mWCompoundExpression;
                }
                if (expression.isRelationExpression()) {
                    mWCompoundExpression.addExpression(MWBasicExpression.convertFromRuntime(mWCompoundExpression, expression));
                    if (!bl) {
                        mWCompoundExpression.setOperatorType(AND);
                    } else {
                        mWCompoundExpression.setOperatorType(NAND);
                    }
                    return mWCompoundExpression;
                }
            }
            Expression expression2 = ((LogicalExpression)expression).getFirstChild();
            if (expression2.isRelationExpression() || expression2.isFunctionExpression() && expression2.getOperator() != ExpressionOperator.getOperator((Integer)new Integer(3))) {
                mWCompoundExpression.addExpression(MWBasicExpression.convertFromRuntime(mWCompoundExpression, expression2));
            } else {
                mWCompoundExpression.addExpression(MWCompoundExpression.convertFromRuntime(mWCompoundExpression, expression2));
            }
            Expression expression3 = ((LogicalExpression)expression).getSecondChild();
            if (expression3.isRelationExpression() || expression3.isFunctionExpression() && expression3.getOperator() != ExpressionOperator.getOperator((Integer)new Integer(3))) {
                mWCompoundExpression.addExpression(MWBasicExpression.convertFromRuntime(mWCompoundExpression, expression3));
            } else {
                mWCompoundExpression.addExpression(MWCompoundExpression.convertFromRuntime(mWCompoundExpression, expression3));
            }
        }
        return mWCompoundExpression;
    }

    private class PropertyChangeHolder {
        private String propertyChangeName;
        private Undoable container;
        private Object oldValue;
        private Object newValue;

        private PropertyChangeHolder(Undoable undoable, String string, Object object, Object object2) {
            this.container = undoable;
            this.propertyChangeName = string;
            this.oldValue = object;
            this.newValue = object2;
        }

        private PropertyChangeHolder(Undoable undoable, String string, Object object) {
            this(undoable, string, null, object);
        }

        protected void undoChange() {
            this.container.undoChange(this.propertyChangeName, this.oldValue, this.newValue);
        }
    }
}

