/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.xs.XSObject;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.AbstractSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.Content;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroup;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWParticle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.NullParticle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.Wildcard;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class ComplexContent
extends Content {
    private volatile boolean mixedFlag;
    private volatile MWParticle particle;

    protected ComplexContent() {
    }

    ComplexContent(ExplicitComplexTypeDefinition explicitComplexTypeDefinition, boolean bl) {
        super(explicitComplexTypeDefinition);
        this.initialize(bl);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.particle = new NullParticle(this);
    }

    private void initialize(boolean bl) {
        this.mixedFlag = bl;
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.particle);
    }

    void addDirectlyOwnedComponentsTo(Collection collection) {
        if (this.particle instanceof MWElementDeclaration) {
            collection.add(this.particle);
        } else {
            this.particle.addDirectlyOwnedComponentsTo(collection);
        }
    }

    boolean hasTextContent() {
        return this.mixedFlag;
    }

    boolean containsWildcard() {
        if (this.particle instanceof Wildcard) {
            return true;
        }
        if (this.particle instanceof MWModelGroup) {
            return ((MWModelGroup)this.particle).containsWildcard();
        }
        return false;
    }

    int compareSchemaOrder(MWElementDeclaration mWElementDeclaration, MWElementDeclaration mWElementDeclaration2) {
        return this.particle.compareSchemaOrder(mWElementDeclaration, mWElementDeclaration2);
    }

    public Iterator structuralComponents() {
        return new SingleElementIterator(this.particle);
    }

    public Iterator descriptorContextComponents() {
        if (this.particle.isDescriptorContextComponent()) {
            return new SingleElementIterator(this.particle);
        }
        return this.particle.descriptorContextComponents();
    }

    public Iterator xpathComponents() {
        if (this.particle instanceof MWElementDeclaration) {
            return new SingleElementIterator(this.particle);
        }
        return this.particle.xpathComponents();
    }

    public MWElementDeclaration nestedElement(String string, String string2) {
        if (this.particle instanceof MWElementDeclaration) {
            MWElementDeclaration mWElementDeclaration = (MWElementDeclaration)this.particle;
            if (string.equals(mWElementDeclaration.getNamespaceUrl()) && string2.equals(mWElementDeclaration.getName())) {
                return mWElementDeclaration;
            }
            return null;
        }
        return this.particle.nestedElement(string, string2);
    }

    public int totalElementCount() {
        if (this.particle instanceof MWElementDeclaration) {
            return 1;
        }
        return this.particle.totalElementCount();
    }

    protected void reloadInternal(XSObject xSObject) {
        super.reloadInternal(xSObject);
        XSParticleDecl xSParticleDecl = (XSParticleDecl)((XSComplexTypeDecl)xSObject).getParticle();
        if (this.particle != null && this.particle.isEquivalentTo(xSParticleDecl)) {
            this.particle.reload((XSObject)xSParticleDecl);
        } else {
            MWParticle mWParticle = this.particle;
            this.particle = MWParticle.ParticleFactory.newParticle(this, xSParticleDecl);
            this.getProject().nodeRemoved(mWParticle);
        }
    }

    public void resolveReferences() {
        super.resolveReferences();
        this.particle.resolveReferences();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(ComplexContent.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(Content.class);
        xMLDescriptor.addDirectMapping("mixedFlag", "mixed-flag/text()");
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("particle");
        xMLCompositeObjectMapping.setReferenceClass(AbstractSchemaComponent.class);
        xMLCompositeObjectMapping.setXPath("particle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }
}

