/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.ProjectSubFileComponentContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWXmlProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWXmlSchemaRepository
extends MWModel
implements ProjectSubFileComponentContainer {
    private static final String SUB_DIRECTORY_NAME = "schemas";
    private Map schemas;
    public static final String SCHEMAS_COLLECTION = "schemas";
    private Collection schemaNames;
    private static final String SCHEMA_NAMES_COLLECTION = "schemaNames";

    private MWXmlSchemaRepository() {
    }

    public MWXmlSchemaRepository(MWXmlProject mWXmlProject) {
        super(mWXmlProject);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.schemas = new Hashtable();
        this.schemaNames = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Map map = this.schemas;
        synchronized (map) {
            list.addAll(this.schemas.values());
        }
    }

    public Iterator schemas() {
        return this.schemas.values().iterator();
    }

    public int schemasSize() {
        return this.schemas.size();
    }

    public MWXmlSchema getSchema(String string) {
        return (MWXmlSchema)this.schemas.get(string);
    }

    public MWXmlSchema createSchemaFromFile(String string, String string2) throws ResourceException {
        return this.addSchema(MWXmlSchema.createFromFile(this, string, string2));
    }

    public MWXmlSchema createSchemaFromUrl(String string, String string2) throws ResourceException {
        return this.addSchema(MWXmlSchema.createFromUrl(this, string, string2));
    }

    public MWXmlSchema createSchemaFromClasspath(String string, String string2) throws ResourceException {
        return this.addSchema(MWXmlSchema.createFromClasspath(this, string, string2));
    }

    private MWXmlSchema addSchema(MWXmlSchema mWXmlSchema) throws ResourceException {
        mWXmlSchema.reload();
        this.checkSchemaName(mWXmlSchema.getName(), mWXmlSchema);
        this.schemas.put(mWXmlSchema.getName(), mWXmlSchema);
        this.fireItemAdded("schemas", mWXmlSchema);
        return mWXmlSchema;
    }

    private void checkSchemaName(String string, MWXmlSchema mWXmlSchema) {
        if (this.getSchema(string) != null) {
            throw new IllegalArgumentException("Schema with name already exists.");
        }
        MWXmlSchema mWXmlSchema2 = this.getSchemaIgnoreCase(string);
        if (mWXmlSchema2 != null && mWXmlSchema2 != mWXmlSchema) {
            throw new IllegalArgumentException("Schema with name, but different case, already exists: \"" + mWXmlSchema2.getName() + "\".");
        }
    }

    public boolean containsSchemaIgnoreCase(String string) {
        return this.getSchemaIgnoreCase(string) != null;
    }

    public MWXmlSchema getSchemaIgnoreCase(String string) {
        for (MWXmlSchema mWXmlSchema : this.schemas.values()) {
            if (!mWXmlSchema.getName().equalsIgnoreCase(string)) continue;
            return mWXmlSchema;
        }
        return null;
    }

    public void removeSchema(MWXmlSchema mWXmlSchema) {
        if (this.getSchema(mWXmlSchema.getName()) == null) {
            throw new IllegalArgumentException("Schema with name does not exist.");
        }
        this.schemas.remove(mWXmlSchema.getName());
        this.fireItemRemoved("schemas", mWXmlSchema);
        this.getProject().nodeRemoved(mWXmlSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schemaRenamed(String string, String string2, MWXmlSchema mWXmlSchema) {
        Map map = this.schemas;
        synchronized (map) {
            this.checkSchemaName(string2, mWXmlSchema);
            this.schemas.put(string2, this.schemas.remove(string));
        }
        this.fireCollectionChanged(SCHEMA_NAMES_COLLECTION);
    }

    public void nodeRemoved(Node node) {
        if (node.isDescendantOf(this)) {
            super.nodeRemoved(node);
        }
    }

    public void nodeRenamed(Node node) {
        if (node.isDescendantOf(this)) {
            super.nodeRenamed(node);
        }
    }

    public void mappingReplaced(MWMapping mWMapping, MWMapping mWMapping2) {
    }

    public void descriptorReplaced(MWDescriptor mWDescriptor, MWDescriptor mWDescriptor2) {
    }

    public void descriptorUnmapped(Collection collection) {
    }

    public Iterator projectSubFileComponents() {
        return this.schemas();
    }

    public void setProjectSubFileComponents(Collection collection) {
        this.schemas = new Hashtable(collection.size());
        for (MWXmlSchema mWXmlSchema : collection) {
            this.schemas.put(mWXmlSchema.getName(), mWXmlSchema);
        }
    }

    public Iterator originalProjectSubFileComponentNames() {
        return this.schemaNames.iterator();
    }

    public void setOriginalProjectSubFileComponentNames(Collection collection) {
        this.schemaNames = collection;
    }

    public boolean hasChangedMainProjectSaveFile() {
        if (this.isDirty()) {
            return true;
        }
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            if (!this.childHasChangedTheProjectSaveFile(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean childHasChangedTheProjectSaveFile(Object object) {
        if (this.schemas.containsValue(object)) {
            return false;
        }
        return ((Node)object).isDirtyBranch();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWXmlSchemaRepository.class);
        XMLCompositeDirectCollectionMapping xMLCompositeDirectCollectionMapping = new XMLCompositeDirectCollectionMapping();
        xMLCompositeDirectCollectionMapping.setAttributeName(SCHEMA_NAMES_COLLECTION);
        xMLCompositeDirectCollectionMapping.setSetMethodName("setSchemaNamesForTopLink");
        xMLCompositeDirectCollectionMapping.setGetMethodName("getSchemaNamesForTopLink");
        xMLCompositeDirectCollectionMapping.useCollectionClass(HashSet.class);
        xMLCompositeDirectCollectionMapping.setXPath("schema-names/name/text()");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeDirectCollectionMapping);
        return xMLDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getSchemaNamesForTopLink() {
        ArrayList arrayList = new ArrayList(this.schemas.size());
        Map map = this.schemas;
        synchronized (map) {
            Iterator iterator = this.schemas.keySet().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return CollectionTools.sort(arrayList, (Comparator)Collator.getInstance());
    }

    private void setSchemaNamesForTopLink(Collection collection) {
        this.schemaNames = collection;
    }
}

