/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTableDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalTableDescription;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ResultSetIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class JDBCExternalDatabase
implements ExternalDatabase {
    private final Connection connection;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    JDBCExternalDatabase(Connection connection) {
        this.connection = connection;
    }

    public String[] getCatalogNames() {
        ResultSet resultSet;
        try {
            resultSet = this.metaData().getCatalogs();
        }
        catch (SQLException sQLException) {
            return EMPTY_STRING_ARRAY;
        }
        return this.buildStringArray(resultSet);
    }

    public String[] getSchemaNames() {
        ResultSet resultSet;
        try {
            resultSet = this.metaData().getSchemas();
        }
        catch (SQLException sQLException) {
            return EMPTY_STRING_ARRAY;
        }
        return this.buildStringArray(resultSet);
    }

    public String[] getTableTypeNames() {
        ResultSet resultSet;
        try {
            resultSet = this.metaData().getTableTypes();
        }
        catch (SQLException sQLException) {
            return EMPTY_STRING_ARRAY;
        }
        return this.buildStringArray(resultSet);
    }

    public ExternalTableDescription[] getTableDescriptions(String string, String string2, String string3, String[] stringArray) {
        ResultSet resultSet;
        if (string != null) {
            try {
                this.getConnection().setCatalog(string);
            }
            catch (SQLException sQLException) {
                throw new RuntimeException(sQLException);
            }
        }
        try {
            resultSet = this.metaData().getTables(string, string2, string3, stringArray);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        List list = CollectionTools.list(new ResultSetIterator(resultSet, new ExternalTableDescriptionResultSetAdapter()));
        return list.toArray(new ExternalTableDescription[list.size()]);
    }

    public ExternalTableDescription[] getTableDescriptions() {
        return this.getTableDescriptions(null, null, "%", null);
    }

    private Connection getConnection() {
        if (this.connection == null) {
            throw new IllegalStateException("not connected");
        }
        return this.connection;
    }

    DatabaseMetaData metaData() {
        try {
            return this.getConnection().getMetaData();
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this);
    }

    private String[] buildStringArray(ResultSet resultSet) {
        List list = CollectionTools.list(new ResultSetIterator(resultSet, new StringResultSetAdapter()));
        return list.toArray(new String[list.size()]);
    }

    private class ExternalTableDescriptionResultSetAdapter
    implements ResultSetIterator.Adapter {
        private ExternalTableDescriptionResultSetAdapter() {
        }

        public Object buildNext(ResultSet resultSet) throws SQLException {
            return new JDBCExternalTableDescription(resultSet, JDBCExternalDatabase.this);
        }
    }

    private static class StringResultSetAdapter
    implements ResultSetIterator.Adapter {
        private StringResultSetAdapter() {
        }

        public Object buildNext(ResultSet resultSet) throws SQLException {
            String string = resultSet.getString(1);
            return string == null ? null : string.trim();
        }
    }
}

