/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalClassDescription;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class CFExternalClassRepository
implements ExternalClassRepository {
    private final Classpath classpath;
    private ExternalClassDescription[] classDescriptions;
    private Map defaultClassDescriptions;
    private final Map stubClassDescriptions = new HashMap();
    private final Map arrayClassDescriptions = new HashMap();
    private static final int STARTING_SIZE = 20000;

    CFExternalClassRepository(File[] fileArray) {
        this.classpath = new Classpath(this.fileNames(fileArray)).compressed();
    }

    private String[] fileNames(File[] fileArray) {
        int n = fileArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = fileArray[i].getAbsolutePath();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalClassDescription getClassDescription(String string) {
        CFExternalClassRepository cFExternalClassRepository = this;
        synchronized (cFExternalClassRepository) {
            if (this.classDescriptions == null) {
                this.initializeClassDescriptions();
            }
        }
        return (ExternalClassDescription)this.defaultClassDescriptions.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalClassDescription[] getClassDescriptions() {
        CFExternalClassRepository cFExternalClassRepository = this;
        synchronized (cFExternalClassRepository) {
            if (this.classDescriptions == null) {
                this.initializeClassDescriptions();
            }
        }
        return this.classDescriptions;
    }

    private void initializeClassDescriptions() {
        ArrayList<ExternalClassDescription> arrayList = new ArrayList<ExternalClassDescription>(20000);
        this.defaultClassDescriptions = new HashMap(20000);
        int n = PRIMITIVE_EXTERNAL_CLASS_DESCRIPTIONS.length;
        while (n-- > 0) {
            ExternalClassDescription externalClassDescription = PRIMITIVE_EXTERNAL_CLASS_DESCRIPTIONS[n];
            arrayList.add(externalClassDescription);
            this.defaultClassDescriptions.put(externalClassDescription.getName(), externalClassDescription);
        }
        Classpath.Entry[] entryArray = this.classpath.getEntries();
        int n2 = entryArray.length;
        for (int i = 0; i < n2; ++i) {
            this.addClassDescriptionsFromClasspathEntryTo(entryArray[i], arrayList, this.defaultClassDescriptions);
        }
        this.classDescriptions = arrayList.toArray(new ExternalClassDescription[arrayList.size()]);
    }

    private void addClassDescriptionsFromClasspathEntryTo(Classpath.Entry entry, List list, Map map) {
        Iterator iterator = entry.classNamesStream();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            CFExternalClassDescription cFExternalClassDescription = new CFExternalClassDescription(string, entry.canonicalFileName(), this);
            list.add(cFExternalClassDescription);
            if (map.containsKey(string)) continue;
            map.put(string, cFExternalClassDescription);
        }
    }

    ExternalClassDescription getClassDescriptionNamed(String string) {
        if (ClassTools.classNamedIsArray(string)) {
            return this.getArrayClassDescriptionNamed(string);
        }
        ExternalClassDescription externalClassDescription = (ExternalClassDescription)this.defaultClassDescriptions.get(string);
        if (externalClassDescription == null) {
            externalClassDescription = this.getStubClassDescriptionNamed(string);
        }
        return externalClassDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalClassDescription getStubClassDescriptionNamed(String string) {
        Map map = this.stubClassDescriptions;
        synchronized (map) {
            ExternalClassDescription externalClassDescription = (ExternalClassDescription)this.stubClassDescriptions.get(string);
            if (externalClassDescription == null) {
                externalClassDescription = new CFExternalClassDescription(string, this);
                this.stubClassDescriptions.put(string, externalClassDescription);
            }
            return externalClassDescription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalClassDescription getArrayClassDescriptionNamed(String string) {
        Map map = this.arrayClassDescriptions;
        synchronized (map) {
            ExternalClassDescription externalClassDescription = (ExternalClassDescription)this.arrayClassDescriptions.get(string);
            if (externalClassDescription == null) {
                externalClassDescription = new CFExternalClassDescription(string, this);
                this.arrayClassDescriptions.put(string, externalClassDescription);
            }
            return externalClassDescription;
        }
    }

    public String toString() {
        String string = this.classDescriptions == null ? "uninitialized" : String.valueOf(this.classDescriptions.length) + " types";
        return StringTools.buildToStringFor(this, string);
    }
}

