/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.AnnotationDefaultAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.ClassFile;
import org.eclipse.persistence.tools.workbench.utility.classfile.CodeAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantValueAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.DeprecatedAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.EnclosingMethodAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.ExceptionsAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.InnerClass;
import org.eclipse.persistence.tools.workbench.utility.classfile.InnerClassesAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.LineNumberTableAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.LocalVariableTableAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.LocalVariableTypeTableAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.RuntimeInvisibleAnnotationsAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.RuntimeInvisibleParameterAnnotationsAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.RuntimeVisibleAnnotationsAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.RuntimeVisibleParameterAnnotationsAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.SignatureAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.SourceDebugExtensionAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.SourceFileAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.SyntheticAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.UnknownAttribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;
import org.eclipse.persistence.tools.workbench.utility.io.StringBufferWriter;

public abstract class Attribute {
    private AttributePool pool;
    private short nameIndex;
    private int length;
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    static Attribute read(ClassFileDataInputStream classFileDataInputStream, AttributePool attributePool) throws IOException {
        short s = classFileDataInputStream.readU2();
        String string = attributePool.constantPool().getUTF8String(s);
        if (string.equals("ConstantValue")) {
            return new ConstantValueAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("Code")) {
            return new CodeAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("Exceptions")) {
            return new ExceptionsAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("InnerClasses")) {
            return new InnerClassesAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("EnclosingMethod")) {
            return new EnclosingMethodAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("Synthetic")) {
            return new SyntheticAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("Signature")) {
            return new SignatureAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("SourceFile")) {
            return new SourceFileAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("SourceDebugExtension")) {
            return new SourceDebugExtensionAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("LineNumberTable")) {
            return new LineNumberTableAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("LocalVariableTable")) {
            return new LocalVariableTableAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("LocalVariableTypeTable")) {
            return new LocalVariableTypeTableAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("Deprecated")) {
            return new DeprecatedAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("RuntimeVisibleAnnotations")) {
            return new RuntimeVisibleAnnotationsAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("RuntimeInvisibleAnnotations")) {
            return new RuntimeInvisibleAnnotationsAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("RuntimeVisibleParameterAnnotations")) {
            return new RuntimeVisibleParameterAnnotationsAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("RuntimeInvisibleParameterAnnotations")) {
            return new RuntimeInvisibleParameterAnnotationsAttribute(classFileDataInputStream, s, attributePool);
        }
        if (string.equals("AnnotationDefault")) {
            return new AnnotationDefaultAttribute(classFileDataInputStream, s, attributePool);
        }
        return new UnknownAttribute(classFileDataInputStream, s, attributePool);
    }

    Attribute(ClassFileDataInputStream classFileDataInputStream, short s, AttributePool attributePool) throws IOException {
        this.pool = attributePool;
        this.nameIndex = s;
        this.initialize(classFileDataInputStream);
    }

    void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.length = classFileDataInputStream.readU4();
        this.initializeInfo(classFileDataInputStream);
    }

    abstract void initializeInfo(ClassFileDataInputStream var1) throws IOException;

    public String displayString() {
        StringWriter stringWriter = new StringWriter(1000);
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
        this.displayStringOn(indentingPrintWriter);
        return stringWriter.toString();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        this.displayNameOn(indentingPrintWriter);
        indentingPrintWriter.println();
        indentingPrintWriter.indent();
        this.displayInfoStringOn(indentingPrintWriter);
        indentingPrintWriter.undent();
    }

    public void displayNameOn(IndentingPrintWriter indentingPrintWriter) {
        indentingPrintWriter.print(this.name());
    }

    abstract void displayInfoStringOn(IndentingPrintWriter var1);

    public Object fieldConstantValue() {
        return null;
    }

    public void printFieldInitializationClauseOn(PrintWriter printWriter) {
    }

    public String[] exceptionClassNames() {
        return null;
    }

    public String sourceFileName() {
        return null;
    }

    public InnerClass innerClassNamed(String string) {
        return null;
    }

    public String declaringClassName() {
        return null;
    }

    public String nestedClassName() {
        return null;
    }

    public short nestedClassAccessFlags() {
        return 0;
    }

    public String[] nestedClassNames() {
        return null;
    }

    public String[] declaredMemberClassNames() {
        return null;
    }

    public void printThrowsClauseOn(PrintWriter printWriter) {
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isNestedClass() {
        return false;
    }

    public boolean isMemberClass() {
        return false;
    }

    public boolean isLocalClass() {
        return false;
    }

    public boolean isAnonymousClass() {
        return false;
    }

    public ClassFile classFile() {
        return this.pool.getClassFile();
    }

    public ConstantPool constantPool() {
        return this.classFile().getConstantPool();
    }

    public String name() {
        return this.constantPool().getUTF8String(this.nameIndex);
    }

    public AttributePool getPool() {
        return this.pool;
    }

    public short getNameIndex() {
        return this.nameIndex;
    }

    public int getLength() {
        return this.length;
    }

    void appendHexStringTo(byte[] byArray, StringBuffer stringBuffer) {
        this.writeHexStringOn(byArray, new StringBufferWriter(stringBuffer));
    }

    void writeHexStringOn(byte[] byArray, Writer writer) {
        try {
            this.writeHexStringOnInternal(byArray, writer);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void writeHexStringOnInternal(byte[] byArray, Writer writer) throws IOException {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i];
            if (n2 < 0) {
                n2 += 256;
            }
            n2 = (byte)(n2 / 16);
            writer.write(HEX_CHARS[n2]);
            n2 = byArray[i];
            if (n2 < 0) {
                n2 += 256;
            }
            n2 = (byte)(n2 % 16);
            writer.write(HEX_CHARS[n2]);
        }
    }

    public abstract void accept(Visitor var1);

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ClassTools.shortClassNameForObject(this));
        stringBuffer.append('(');
        this.toString(stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    void toString(StringBuffer stringBuffer) {
    }
}

