/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class IntegerConstant
extends Constant {
    private int value;

    IntegerConstant(ConstantPool constantPool, byte by, ClassFileDataInputStream classFileDataInputStream) throws IOException {
        super(constantPool, by, classFileDataInputStream);
    }

    void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.value = classFileDataInputStream.readU4();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        super.displayStringOn(indentingPrintWriter);
        indentingPrintWriter.print(" value: ");
        indentingPrintWriter.println(this.value);
    }

    public String description() {
        return "int";
    }

    public void printFieldInitializationClauseOn(PrintWriter printWriter) {
        printWriter.print(this.value);
    }

    public int intValue() {
        return this.value;
    }

    public Object value() {
        return new Integer(this.value);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

