/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.diff;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.diff.ContainerDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.Diff;
import org.eclipse.persistence.tools.workbench.utility.diff.Differentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.DifferentiatorAdapter;
import org.eclipse.persistence.tools.workbench.utility.diff.EqualityDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.NullDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.NullDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.OrderedContainerDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.ReferenceDifferentiator;
import org.eclipse.persistence.tools.workbench.utility.diff.ReflectiveDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.ReflectiveFieldDiff;
import org.eclipse.persistence.tools.workbench.utility.diff.SimpleDiff;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ReflectiveDifferentiator
implements Differentiator {
    private final Class javaClass;
    private final Differentiator defaultFieldDifferentiator;
    private final Map fieldDifferentiators;
    private KeyDifferentiator keyDifferentiator;
    private boolean comparesValueObjects;
    private OrderedContainerDifferentiator listDifferentiator;
    private OrderedContainerDifferentiator arrayDifferentiator;
    private ContainerDifferentiator collectionDifferentiator;
    private ContainerDifferentiator unorderedArrayDifferentiator;
    private ContainerDifferentiator mapDifferentiator;

    public ReflectiveDifferentiator(Class clazz) {
        this(clazz, EqualityDifferentiator.instance());
    }

    public ReflectiveDifferentiator(Class clazz, Differentiator differentiator) {
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("interfaces cannot be compared reflectively: " + clazz.getName());
        }
        this.javaClass = clazz;
        if (differentiator == null) {
            throw new NullPointerException();
        }
        this.defaultFieldDifferentiator = differentiator;
        this.fieldDifferentiators = this.buildDefaultFieldDifferentiators(false);
        this.keyDifferentiator = new DefaultKeyDifferentiator();
        this.comparesValueObjects = false;
    }

    private Map buildDefaultFieldDifferentiators(boolean bl) {
        HashMap<Field, Differentiator> hashMap = new HashMap<Field, Differentiator>();
        Field[] fieldArray = this.javaClass.getDeclaredFields();
        int n = fieldArray.length;
        while (n-- > 0) {
            Field field = fieldArray[n];
            field.setAccessible(true);
            if (Modifier.isStatic(field.getModifiers()) && !bl) continue;
            hashMap.put(field, this.defaultFieldDifferentiator(field));
        }
        return hashMap;
    }

    private Differentiator defaultFieldDifferentiator(Field field) {
        Class<?> clazz = field.getType();
        if (List.class.isAssignableFrom(clazz)) {
            return this.getListDifferentiator();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return this.getCollectionDifferentiator();
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.getMapDifferentiator();
        }
        if (clazz.isArray()) {
            return this.getArrayDifferentiator();
        }
        return this.defaultFieldDifferentiator;
    }

    private Differentiator defaultFieldDifferentiator(String string) {
        return this.defaultFieldDifferentiator(this.field(string));
    }

    public Diff diff(Object object, Object object2) {
        return this.diff(object, object2, this.fieldDifferentiators, DifferentiatorAdapter.NORMAL);
    }

    public Diff keyDiff(Object object, Object object2) {
        return this.keyDifferentiator.keyDiff(object, object2);
    }

    Diff diff(Object object, Object object2, Map map, DifferentiatorAdapter differentiatorAdapter) {
        if (object == object2) {
            return new NullDiff(object, object2, this);
        }
        if (this.diffIsFatal(object, object2)) {
            return new SimpleDiff(object, object2, this.fatalDescriptionTitle(), this);
        }
        Object[] objectArray = new ReflectiveFieldDiff[map.size()];
        int n = 0;
        for (Map.Entry entry : map.entrySet()) {
            Field field = (Field)entry.getKey();
            Differentiator differentiator = (Differentiator)entry.getValue();
            Object object3 = this.fieldValue(field, object);
            Object object4 = this.fieldValue(field, object2);
            Diff diff = differentiatorAdapter.diff(differentiator, object3, object4);
            objectArray[n++] = new ReflectiveFieldDiff(field, diff, this);
        }
        return new ReflectiveDiff(this.javaClass, object, object2, (ReflectiveFieldDiff[])CollectionTools.sort(objectArray), this);
    }

    public boolean comparesValueObjects() {
        return this.comparesValueObjects;
    }

    private OrderedContainerDifferentiator getListDifferentiator() {
        if (this.listDifferentiator == null) {
            this.listDifferentiator = OrderedContainerDifferentiator.forLists(this.defaultFieldDifferentiator);
        }
        return this.listDifferentiator;
    }

    private OrderedContainerDifferentiator getArrayDifferentiator() {
        if (this.arrayDifferentiator == null) {
            this.arrayDifferentiator = OrderedContainerDifferentiator.forArrays(this.defaultFieldDifferentiator);
        }
        return this.arrayDifferentiator;
    }

    private ContainerDifferentiator getCollectionDifferentiator() {
        if (this.collectionDifferentiator == null) {
            this.collectionDifferentiator = ContainerDifferentiator.forCollections(this.defaultFieldDifferentiator);
        }
        return this.collectionDifferentiator;
    }

    private ContainerDifferentiator getUnorderedArrayDifferentiator() {
        if (this.unorderedArrayDifferentiator == null) {
            this.unorderedArrayDifferentiator = ContainerDifferentiator.forArrays(this.defaultFieldDifferentiator);
        }
        return this.unorderedArrayDifferentiator;
    }

    private ContainerDifferentiator getMapDifferentiator() {
        if (this.mapDifferentiator == null) {
            this.mapDifferentiator = ContainerDifferentiator.forMaps(this.defaultFieldDifferentiator, this.defaultFieldDifferentiator);
        }
        return this.mapDifferentiator;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public Differentiator getDefaultFieldDifferentiator() {
        return this.defaultFieldDifferentiator;
    }

    public KeyDifferentiator getKeyDifferentiator() {
        return this.keyDifferentiator;
    }

    private boolean diffIsFatal(Object object, Object object2) {
        if (object == null) {
            return true;
        }
        if (object2 == null) {
            return true;
        }
        return object.getClass() != object2.getClass();
    }

    protected String fatalDescriptionTitle() {
        return "Objects cannot be compared via reflection (" + this.javaClass.getName() + ")";
    }

    public String toString() {
        return StringTools.buildToStringFor(this, ClassTools.shortNameFor(this.javaClass));
    }

    public void setKeyDifferentiator(KeyDifferentiator keyDifferentiator) {
        this.keyDifferentiator = keyDifferentiator;
    }

    public void setComparesValueObjects(boolean bl) {
        this.comparesValueObjects = bl;
    }

    public Differentiator setFieldDifferentiator(String string, Differentiator differentiator) {
        return this.setFieldDifferentiator(this.field(string), differentiator);
    }

    private Differentiator setFieldDifferentiator(Field field, Differentiator differentiator) {
        if (differentiator == null) {
            throw new NullPointerException();
        }
        Differentiator differentiator2 = this.fieldDifferentiators.put(field, differentiator);
        if (differentiator2 != this.defaultFieldDifferentiator(field)) {
            throw new IllegalArgumentException("duplicate field differentiator: " + field.getName());
        }
        return differentiator;
    }

    public Differentiator replaceFieldDifferentiator(String string, Differentiator differentiator) {
        return this.replaceFieldDifferentiator(this.field(string), differentiator);
    }

    private Differentiator replaceFieldDifferentiator(Field field, Differentiator differentiator) {
        if (differentiator == null) {
            throw new NullPointerException();
        }
        Differentiator differentiator2 = this.fieldDifferentiators.put(field, differentiator);
        if (differentiator2 == this.defaultFieldDifferentiator(field)) {
            throw new IllegalArgumentException("field differentiator not present: " + field.getName());
        }
        return differentiator;
    }

    public Differentiator getFieldDifferentiator(String string) {
        return (Differentiator)this.fieldDifferentiators.get(this.field(string));
    }

    public Differentiator setKeyFieldDifferentiator(String string, Differentiator differentiator) {
        return this.setKeyFieldDifferentiator(this.field(string), differentiator);
    }

    private Differentiator setKeyFieldDifferentiator(Field field, Differentiator differentiator) {
        if (this.keyDifferentiator instanceof DefaultKeyDifferentiator) {
            return ((DefaultKeyDifferentiator)this.keyDifferentiator).setKeyFieldDifferentiator(field, differentiator);
        }
        throw new IllegalStateException("the default key differentiator is not being used");
    }

    public Differentiator replaceKeyFieldDifferentiator(String string, Differentiator differentiator) {
        return this.replaceKeyFieldDifferentiator(this.field(string), differentiator);
    }

    private Differentiator replaceKeyFieldDifferentiator(Field field, Differentiator differentiator) {
        if (this.keyDifferentiator instanceof DefaultKeyDifferentiator) {
            return ((DefaultKeyDifferentiator)this.keyDifferentiator).replaceKeyFieldDifferentiator(field, differentiator);
        }
        throw new IllegalStateException("the default key differentiator is not being used");
    }

    public Differentiator getKeyFieldDifferentiator(String string) {
        if (this.keyDifferentiator instanceof DefaultKeyDifferentiator) {
            return ((DefaultKeyDifferentiator)this.keyDifferentiator).getKeyFieldDifferentiator(this.field(string));
        }
        throw new IllegalStateException("the default key differentiator is not being used");
    }

    public Differentiator removeKeyFieldDifferentiator(String string) {
        if (this.keyDifferentiator instanceof DefaultKeyDifferentiator) {
            return ((DefaultKeyDifferentiator)this.keyDifferentiator).removeKeyFieldDifferentiator(this.field(string));
        }
        throw new IllegalStateException("the default key differentiator is not being used");
    }

    private Object fieldValue(Field field, Object object) {
        try {
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    private Field field(String string) {
        Field field = null;
        try {
            field = this.javaClass.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException(string);
        }
        field.setAccessible(true);
        return field;
    }

    public NullDifferentiator ignoreFieldNamed(String string) {
        return (NullDifferentiator)this.setFieldDifferentiator(string, NullDifferentiator.instance());
    }

    public NullDifferentiator ignoreFieldsNamed(String string) {
        return this.ignoreFieldNamed(string);
    }

    public void ignoreFieldsNamed(String string, String string2) {
        this.ignoreFieldsNamed(new String[]{string, string2});
    }

    public void ignoreFieldsNamed(String string, String string2, String string3) {
        this.ignoreFieldsNamed(new String[]{string, string2, string3});
    }

    public void ignoreFieldsNamed(String[] stringArray) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.ignoreFieldNamed(stringArray[n]);
        }
    }

    public Differentiator addKeyFieldNamed(String string) {
        return this.setKeyFieldDifferentiator(string, this.defaultFieldDifferentiator(string));
    }

    public Differentiator addKeyFieldsNamed(String string) {
        return this.addKeyFieldNamed(string);
    }

    public void addKeyFieldsNamed(String string, String string2) {
        this.addKeyFieldsNamed(new String[]{string, string2});
    }

    public void addKeyFieldsNamed(String string, String string2, String string3) {
        this.addKeyFieldsNamed(new String[]{string, string2, string3});
    }

    public void addKeyFieldsNamed(String[] stringArray) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.addKeyFieldNamed(stringArray[n]);
        }
    }

    private ReferenceDifferentiator addReferenceFieldNamed(String string, Differentiator differentiator) {
        return (ReferenceDifferentiator)this.setFieldDifferentiator(string, (Differentiator)new ReferenceDifferentiator(differentiator));
    }

    public Differentiator addReferenceFieldNamed(String string) {
        return this.addReferenceFieldNamed(string, this.defaultFieldDifferentiator(string));
    }

    public Differentiator addReferenceFieldsNamed(String string) {
        return this.addReferenceFieldNamed(string);
    }

    public void addReferenceFieldsNamed(String string, String string2) {
        this.addReferenceFieldsNamed(new String[]{string, string2});
    }

    public void addReferenceFieldsNamed(String string, String string2, String string3) {
        this.addReferenceFieldsNamed(new String[]{string, string2, string3});
    }

    public void addReferenceFieldsNamed(String[] stringArray) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.addReferenceFieldNamed(stringArray[n]);
        }
    }

    public OrderedContainerDifferentiator addListFieldNamed(String string) {
        return (OrderedContainerDifferentiator)this.setFieldDifferentiator(string, (Differentiator)this.getListDifferentiator());
    }

    public OrderedContainerDifferentiator addListFieldsNamed(String string) {
        return this.addListFieldNamed(string);
    }

    public void addListFieldsNamed(String string, String string2) {
        this.addListFieldsNamed(new String[]{string, string2});
    }

    public void addListFieldsNamed(String string, String string2, String string3) {
        this.addListFieldsNamed(new String[]{string, string2, string3});
    }

    public void addListFieldsNamed(String[] stringArray) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.addListFieldNamed(stringArray[n]);
        }
    }

    public ReferenceDifferentiator addReferenceListFieldNamed(String string) {
        return this.addReferenceFieldNamed(string, this.getListDifferentiator());
    }

    public ReferenceDifferentiator addReferenceListFieldsNamed(String string) {
        return this.addReferenceListFieldNamed(string);
    }

    public void addReferenceListFieldsNamed(String string, String string2) {
        this.addReferenceListFieldsNamed(new String[]{string, string2});
    }

    public void addReferenceListFieldsNamed(String string, String string2, String string3) {
        this.addReferenceListFieldsNamed(new String[]{string, string2, string3});
    }

    public void addReferenceListFieldsNamed(String[] stringArray) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.addReferenceListFieldNamed(stringArray[n]);
        }
    }

    public OrderedContainerDifferentiator addArrayFieldNamed(String string) {
        return (OrderedContainerDifferentiator)this.setFieldDifferentiator(string, (Differentiator)this.getArrayDifferentiator());
    }

    public OrderedContainerDifferentiator addArrayFieldsNamed(String string) {
        return this.addArrayFieldNamed(string);
    }

    public void addArrayFieldsNamed(String string, String string2) {
        this.addArrayFieldsNamed(new String[]{string, string2});
    }

    public void addArrayFieldsNamed(String string, String string2, String string3) {
        this.addArrayFieldsNamed(new String[]{string, string2, string3});
    }

    public void addArrayFieldsNamed(String[] stringArray) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.addArrayFieldNamed(stringArray[n]);
        }
    }

    public ReferenceDifferentiator addReferenceArrayFieldNamed(String string) {
        return this.addReferenceFieldNamed(string, this.getArrayDifferentiator());
    }

    public ReferenceDifferentiator addReferenceArrayFieldsNamed(String string) {
        return this.addReferenceArrayFieldNamed(string);
    }

    public void addReferenceArrayFieldsNamed(String string, String string2) {
        this.addReferenceArrayFieldsNamed(new String[]{string, string2});
    }

    public void addReferenceArrayFieldsNamed(String string, String string2, String string3) {
        this.addReferenceArrayFieldsNamed(new String[]{string, string2, string3});
    }

    public void addReferenceArrayFieldsNamed(String[] stringArray) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.addReferenceArrayFieldNamed(stringArray[n]);
        }
    }

    public ContainerDifferentiator addCollectionFieldNamed(String string) {
        return (ContainerDifferentiator)this.setFieldDifferentiator(string, (Differentiator)this.getCollectionDifferentiator());
    }

    public ContainerDifferentiator addCollectionFieldsNamed(String string) {
        return this.addCollectionFieldNamed(string);
    }

    public void addCollectionFieldsNamed(String string, String string2) {
        this.addCollectionFieldsNamed(new String[]{string, string2});
    }

    public void addCollectionFieldsNamed(String string, String string2, String string3) {
        this.addCollectionFieldsNamed(new String[]{string, string2, string3});
    }

    public void addCollectionFieldsNamed(String[] stringArray) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.addCollectionFieldNamed(stringArray[n]);
        }
    }

    public ReferenceDifferentiator addReferenceCollectionFieldNamed(String string) {
        return this.addReferenceFieldNamed(string, this.getCollectionDifferentiator());
    }

    public ReferenceDifferentiator addReferenceCollectionFieldsNamed(String string) {
        return this.addReferenceCollectionFieldNamed(string);
    }

    public void addReferenceCollectionFieldsNamed(String string, String string2) {
        this.addReferenceCollectionFieldsNamed(new String[]{string, string2});
    }

    public void addReferenceCollectionFieldsNamed(String string, String string2, String string3) {
        this.addReferenceCollectionFieldsNamed(new String[]{string, string2, string3});
    }

    public void addReferenceCollectionFieldsNamed(String[] stringArray) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.addReferenceCollectionFieldNamed(stringArray[n]);
        }
    }

    public ContainerDifferentiator addUnorderedArrayFieldNamed(String string) {
        return (ContainerDifferentiator)this.setFieldDifferentiator(string, (Differentiator)this.getUnorderedArrayDifferentiator());
    }

    public ContainerDifferentiator addUnorderedArrayFieldsNamed(String string) {
        return this.addUnorderedArrayFieldNamed(string);
    }

    public void addUnorderedArrayFieldsNamed(String string, String string2) {
        this.addUnorderedArrayFieldsNamed(new String[]{string, string2});
    }

    public void addUnorderedArrayFieldsNamed(String string, String string2, String string3) {
        this.addUnorderedArrayFieldsNamed(new String[]{string, string2, string3});
    }

    public void addUnorderedArrayFieldsNamed(String[] stringArray) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.addUnorderedArrayFieldNamed(stringArray[n]);
        }
    }

    public ReferenceDifferentiator addReferenceUnorderedArrayFieldNamed(String string) {
        return this.addReferenceFieldNamed(string, this.getUnorderedArrayDifferentiator());
    }

    public ReferenceDifferentiator addReferenceUnorderedArrayFieldsNamed(String string) {
        return this.addReferenceUnorderedArrayFieldNamed(string);
    }

    public void addReferenceUnorderedArrayFieldsNamed(String string, String string2) {
        this.addReferenceUnorderedArrayFieldsNamed(new String[]{string, string2});
    }

    public void addReferenceUnorderedArrayFieldsNamed(String string, String string2, String string3) {
        this.addReferenceUnorderedArrayFieldsNamed(new String[]{string, string2, string3});
    }

    public void addReferenceUnorderedArrayFieldsNamed(String[] stringArray) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.addReferenceUnorderedArrayFieldNamed(stringArray[n]);
        }
    }

    public ContainerDifferentiator addMapFieldNamed(String string) {
        return (ContainerDifferentiator)this.setFieldDifferentiator(string, (Differentiator)this.getMapDifferentiator());
    }

    public ContainerDifferentiator addMapFieldsNamed(String string) {
        return this.addMapFieldNamed(string);
    }

    public void addMapFieldsNamed(String string, String string2) {
        this.addMapFieldsNamed(new String[]{string, string2});
    }

    public void addMapFieldsNamed(String string, String string2, String string3) {
        this.addMapFieldsNamed(new String[]{string, string2, string3});
    }

    public void addMapFieldsNamed(String[] stringArray) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.addMapFieldNamed(stringArray[n]);
        }
    }

    public ReferenceDifferentiator addReferenceMapFieldNamed(String string) {
        return this.addReferenceFieldNamed(string, this.getMapDifferentiator());
    }

    public ReferenceDifferentiator addReferenceMapFieldsNamed(String string) {
        return this.addReferenceMapFieldNamed(string);
    }

    public void addReferenceMapFieldsNamed(String string, String string2) {
        this.addReferenceMapFieldsNamed(new String[]{string, string2});
    }

    public void addReferenceMapFieldsNamed(String string, String string2, String string3) {
        this.addReferenceMapFieldsNamed(new String[]{string, string2, string3});
    }

    public void addReferenceMapFieldsNamed(String[] stringArray) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.addReferenceMapFieldNamed(stringArray[n]);
        }
    }

    public static class SimpleMethodKeyDifferentiator
    implements KeyDifferentiator {
        protected String methodName;
        protected static final Object NULL_KEY = new Object();

        public SimpleMethodKeyDifferentiator(String string) {
            this.methodName = string;
        }

        public Diff keyDiff(Object object, Object object2) {
            return this.diffKeys(this.key(object), this.key(object2));
        }

        protected Diff diffKeys(Object object, Object object2) {
            return EqualityDifferentiator.instance().diff(object, object2);
        }

        protected Object key(Object object) {
            return object == null ? NULL_KEY : ClassTools.invokeMethod(object, this.methodName);
        }

        protected Object nullKey() {
            return NULL_KEY;
        }

        public String toString() {
            return StringTools.buildToStringFor(this, this.methodName);
        }
    }

    private class DefaultKeyDifferentiator
    implements KeyDifferentiator {
        private Map keyFieldDifferentiators = new HashMap();

        DefaultKeyDifferentiator() {
        }

        public Diff keyDiff(Object object, Object object2) {
            return ReflectiveDifferentiator.this.diff(object, object2, this.keyFieldDifferentiators, DifferentiatorAdapter.KEY);
        }

        Differentiator setKeyFieldDifferentiator(Field field, Differentiator differentiator) {
            Differentiator differentiator2 = this.replaceKeyFieldDifferentiator(field, differentiator);
            if (differentiator2 != null) {
                throw new IllegalArgumentException("duplicate key field differentiator: " + field.getName());
            }
            return differentiator;
        }

        Differentiator replaceKeyFieldDifferentiator(Field field, Differentiator differentiator) {
            if (differentiator == null) {
                throw new NullPointerException();
            }
            return this.keyFieldDifferentiators.put(field, differentiator);
        }

        Differentiator getKeyFieldDifferentiator(Field field) {
            return (Differentiator)this.keyFieldDifferentiators.get(field);
        }

        Differentiator removeKeyFieldDifferentiator(Field field) {
            return (Differentiator)this.keyFieldDifferentiators.remove(field);
        }
    }

    public static interface KeyDifferentiator {
        public Diff keyDiff(Object var1, Object var2);
    }
}

