/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.string.XMLStringEncoder;

public final class FileTools {
    public static final String USER_HOME_DIRECTORY_NAME = System.getProperty("user.home");
    public static final String USER_TEMPORARY_DIRECTORY_NAME = System.getProperty("java.io.tmpdir");
    public static String DEFAULT_TEMPORARY_DIRECTORY_NAME = "tmpdir";
    public static final String CURRENT_WORKING_DIRECTORY_NAME = System.getProperty("user.dir");
    public static final char[] INVALID_FILENAME_CHARACTERS = new char[]{':', '*', '|', '&', '/', '\\', ';', '?', '[', ']', '=', '+', '<', '>', '\"', ','};
    public static final XMLStringEncoder FILE_NAME_ENCODER = new XMLStringEncoder(INVALID_FILENAME_CHARACTERS);
    private static final String[] WINDOWS_RESERVED_FILE_NAMES = new String[]{"con", "aux", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "prn", "nul"};
    public static final int MAXIMUM_SHORTENED_FILE_NAME_LENGTH = 60;

    public static void deleteDirectory(String string) {
        FileTools.deleteDirectory(new File(string));
    }

    public static void deleteDirectory(File file) {
        FileTools.deleteDirectoryContents(file);
        if (!file.delete()) {
            throw new RuntimeException("unable to delete directory: " + file.getAbsolutePath());
        }
    }

    public static void deleteDirectoryContents(String string) {
        FileTools.deleteDirectoryContents(new File(string));
    }

    public static void deleteDirectoryContents(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                FileTools.deleteDirectory(file2);
                continue;
            }
            if (file2.delete()) continue;
            throw new RuntimeException("unable to delete file: " + file2.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToFile(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        try {
            fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
        }
        finally {
            fileChannel.close();
            fileChannel2.close();
        }
    }

    public static void copyToDirectory(File file, File file2) throws IOException {
        File file3 = new File(file2, file.getName());
        file3.createNewFile();
        FileTools.copyToFile(file, file3);
    }

    public static Iterator filesIn(String string) {
        return FileTools.filesIn(new File(string));
    }

    public static Iterator filesIn(File file) {
        return FileTools.filesIn(file.listFiles());
    }

    private static Iterator filesIn(File[] fileArray) {
        return new FilteringIterator(new ArrayIterator(fileArray)){

            protected boolean accept(Object object) {
                return ((File)object).isFile();
            }
        };
    }

    public static Iterator directoriesIn(String string) {
        return FileTools.directoriesIn(new File(string));
    }

    public static Iterator directoriesIn(File file) {
        return FileTools.directoriesIn(file.listFiles());
    }

    private static Iterator directoriesIn(File[] fileArray) {
        return new FilteringIterator(new ArrayIterator(fileArray)){

            protected boolean accept(Object object) {
                return ((File)object).isDirectory();
            }
        };
    }

    public static Iterator filesInTree(String string) {
        return FileTools.filesInTree(new File(string));
    }

    public static Iterator filesInTree(File file) {
        return FileTools.filesInTreeAsSet(file).iterator();
    }

    private static Set filesInTreeAsSet(File file) {
        HashSet hashSet = new HashSet(10000);
        FileTools.addFilesInTreeTo(file, hashSet);
        return hashSet;
    }

    private static void addFilesInTreeTo(File file, Collection collection) {
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        while (n-- > 0) {
            File file2 = fileArray[n];
            if (file2.isFile()) {
                collection.add(file2);
                continue;
            }
            if (!file2.isDirectory()) continue;
            FileTools.addFilesInTreeTo(file2, collection);
        }
    }

    public static Iterator directoriesInTree(String string) {
        return FileTools.directoriesInTree(new File(string));
    }

    public static Iterator directoriesInTree(File file) {
        File[] fileArray = file.listFiles();
        return new CompositeIterator(FileTools.directoriesIn(fileArray), FileTools.directoriesInTrees(FileTools.directoriesIn(fileArray)));
    }

    private static Iterator directoriesInTrees(Iterator iterator) {
        return new CompositeIterator(new TransformationIterator(iterator){

            protected Object transform(Object object) {
                return FileTools.directoriesInTree((File)object);
            }
        });
    }

    public static String stripExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String stripExtension(File file) {
        return FileTools.stripExtension(file.getPath());
    }

    public static String extension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n);
    }

    public static String extension(File file) {
        return FileTools.extension(file.getPath());
    }

    public static File emptyTemporaryDirectory(String string) {
        File file = new File(FileTools.userTemporaryDirectory(), string);
        if (file.exists()) {
            FileTools.deleteDirectoryContents(file);
        } else {
            file.mkdirs();
        }
        return file;
    }

    public static File emptyTemporaryDirectory() {
        return FileTools.emptyTemporaryDirectory(DEFAULT_TEMPORARY_DIRECTORY_NAME);
    }

    public static File temporaryDirectory(String string) {
        File file = new File(FileTools.userTemporaryDirectory(), string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File temporaryDirectory() {
        return FileTools.temporaryDirectory(DEFAULT_TEMPORARY_DIRECTORY_NAME);
    }

    public static File newTemporaryDirectory(String string) {
        File file;
        if (!string.endsWith(".")) {
            string = string + ".";
        }
        int n = 0;
        while (!(file = new File(FileTools.userTemporaryDirectory(), string + ++n)).mkdirs()) {
        }
        return file;
    }

    public static File newTemporaryDirectory() {
        return FileTools.newTemporaryDirectory(DEFAULT_TEMPORARY_DIRECTORY_NAME);
    }

    public static File resourceFile(String string) throws URISyntaxException {
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException(string);
        }
        return FileTools.resourceFile(string, FileTools.class);
    }

    public static File resourceFile(String string, Class clazz) throws URISyntaxException {
        URL uRL = clazz.getResource(string);
        return FileTools.buildFile(uRL);
    }

    public static File buildFile(URL uRL) throws URISyntaxException {
        return FileTools.buildFile(uRL.getFile());
    }

    public static File buildFile(String string) throws URISyntaxException {
        URI uRI = new URI(string);
        File file = new File(uRI.getPath());
        return file;
    }

    public static File canonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    public static Iterator canonicalFiles(Iterator iterator) {
        return new TransformationIterator(iterator){

            protected Object transform(Object object) {
                return FileTools.canonicalFile((File)object);
            }
        };
    }

    public static Iterator canonicalFiles(Collection collection) {
        return FileTools.canonicalFiles(collection.iterator());
    }

    public static String canonicalFileName(String string) {
        return FileTools.canonicalFile(new File(string)).getAbsolutePath();
    }

    public static Iterator canonicalFileNames(Iterator iterator) {
        return new TransformationIterator(iterator){

            protected Object transform(Object object) {
                return FileTools.canonicalFileName((String)object);
            }
        };
    }

    public static Iterator canonicalFileNames(Collection collection) {
        return FileTools.canonicalFileNames(collection.iterator());
    }

    public static boolean fileNameIsInvalid(String string) {
        return !FileTools.fileNameIsValid(string);
    }

    public static boolean fileNameIsValid(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!CollectionTools.contains(INVALID_FILENAME_CHARACTERS, c)) continue;
            return false;
        }
        return true;
    }

    public static String convertToValidFileName(String string, char c) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (CollectionTools.contains(INVALID_FILENAME_CHARACTERS, c2)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static String convertToValidFileName(String string) {
        return FileTools.convertToValidFileName(string, '.');
    }

    public static boolean fileNameIsReserved(String string) {
        if (FileTools.executingOnWindows()) {
            return CollectionTools.contains(WINDOWS_RESERVED_FILE_NAMES, (Object)string.toLowerCase());
        }
        return false;
    }

    public static boolean fileHasAnyReservedComponents(File file) {
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            if (!FileTools.fileNameIsReserved(file2.getName())) continue;
            return true;
        }
        return false;
    }

    public static String shortenFileName(URL uRL) {
        return FileTools.shortenFileName(uRL, 60);
    }

    public static String shortenFileName(URL uRL, int n) {
        File file;
        try {
            file = FileTools.buildFile(uRL);
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uRL.getFile());
        }
        return FileTools.shortenFileName(file, n);
    }

    public static String shortenFileName(File file) {
        return FileTools.shortenFileName(file, 60);
    }

    public static String shortenFileName(File file, int n) {
        String string = FileTools.canonicalFile(file).getAbsolutePath();
        if (string.length() <= n) {
            return string;
        }
        String string2 = File.separator;
        String[] stringArray = string.split("\\" + string2);
        if (stringArray.length <= 1) {
            return stringArray[0];
        }
        if (stringArray.length == 2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        int n2 = stringBuffer.length();
        stringBuffer.append(string2);
        stringBuffer.append(stringArray[stringArray.length - 1]);
        n -= 4;
        int n3 = stringBuffer.length() - 4;
        int n4 = 1;
        int n5 = stringArray.length - 2;
        boolean bl = true;
        boolean bl2 = true;
        while (bl || bl2) {
            int n6;
            String string3;
            if (bl2) {
                string3 = stringArray[n5];
                n6 = string3.length();
                if (n3 + n6 + 1 <= n) {
                    stringBuffer.insert(n2, string2);
                    stringBuffer.insert(n2 + 1, string3);
                    n3 += n6 + 1;
                    if (n4 >= --n5) {
                        bl2 = false;
                    }
                } else {
                    bl2 = false;
                }
            }
            if (!bl) continue;
            string3 = stringArray[n4];
            n6 = string3.length();
            if (n3 + n6 + 1 <= n) {
                stringBuffer.insert(n2, string2);
                stringBuffer.insert(n2 + 1, string3);
                n2 += n6 + 1;
                n3 += n6 + 1;
                if (++n4 < n5) continue;
                bl = false;
                continue;
            }
            bl = false;
        }
        if (n4 <= n5) {
            stringBuffer.insert(n2, string2);
            stringBuffer.insert(n2 + 1, "...");
        }
        return stringBuffer.toString();
    }

    public static File userHomeDirectory() {
        return new File(USER_HOME_DIRECTORY_NAME);
    }

    public static File userTemporaryDirectory() {
        return new File(USER_TEMPORARY_DIRECTORY_NAME);
    }

    public static File currentWorkingDirectory() {
        return new File(CURRENT_WORKING_DIRECTORY_NAME);
    }

    private static boolean executingOnWindows() {
        return FileTools.executingOn("Windows");
    }

    private static boolean executingOn(String string) {
        return System.getProperty("os.name").indexOf(string) != -1;
    }

    public static Iterator filter(Iterator iterator, final FileFilter fileFilter) {
        return new FilteringIterator(iterator){

            protected boolean accept(Object object) {
                return fileFilter.accept((File)object);
            }
        };
    }

    public static File convertToRelativeFile(File file, File file2) {
        int n;
        File file3;
        if (!file.isAbsolute()) {
            return file;
        }
        File file4 = FileTools.canonicalFile(file);
        if (file4.equals(file3 = FileTools.canonicalFile(file2))) {
            return new File(".");
        }
        File[] fileArray = FileTools.pathFiles(file4);
        File[] fileArray2 = FileTools.pathFiles(file3);
        if (!fileArray2[0].equals(fileArray[0])) {
            return file;
        }
        for (n = 0; n < fileArray2.length && n < fileArray.length && fileArray2[n].equals(fileArray[n]); ++n) {
        }
        int n2 = n;
        if (n2 == fileArray.length) {
            return FileTools.relativeParentFile(fileArray2.length - n2);
        }
        File file5 = new File(fileArray[n].getName());
        while (++n < fileArray.length) {
            file5 = new File(file5, fileArray[n].getName());
        }
        if (n2 == fileArray2.length) {
            return file5;
        }
        return new File(FileTools.relativeParentFile(fileArray2.length - n2), file5.getPath());
    }

    public static File convertToRelativeFile(File file) {
        return FileTools.convertToRelativeFile(file, FileTools.currentWorkingDirectory());
    }

    private static File[] pathFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            arrayList.add(file2);
        }
        Collections.reverse(arrayList);
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static File relativeParentFile(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("length must be greater than zero: " + n);
        }
        File file = new File("..");
        int n2 = n - 1;
        while (n2-- > 0) {
            file = new File(file, "..");
        }
        return file;
    }

    public static File convertToAbsoluteFile(File file, File file2) {
        if (file.isAbsolute()) {
            return file;
        }
        return FileTools.canonicalFile(new File(file2, file.getPath()));
    }

    public static File convertToAbsoluteFile(File file) {
        return FileTools.convertToAbsoluteFile(file, FileTools.currentWorkingDirectory());
    }

    private FileTools() {
        throw new UnsupportedOperationException();
    }
}

