/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.io;

import java.io.PrintWriter;
import java.io.Writer;

public class IndentingPrintWriter
extends PrintWriter {
    private String indent;
    private int indentLevel;
    private boolean needsIndent;
    public static String DEFAULT_INDENT = "\t";

    public IndentingPrintWriter(Writer writer) {
        this(writer, DEFAULT_INDENT);
    }

    public IndentingPrintWriter(Writer writer, String string) {
        super(writer);
        this.indent = string;
        this.indentLevel = 0;
        this.needsIndent = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println() {
        Object object = this.lock;
        synchronized (object) {
            super.println();
            this.needsIndent = true;
        }
    }

    private void printIndent() {
        if (this.needsIndent) {
            this.needsIndent = false;
            int n = this.indentLevel;
            while (n-- > 0) {
                this.print(this.indent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            this.printIndent();
            super.write(cArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.printIndent();
            super.write(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int n, int n2) {
        Object object = this.lock;
        synchronized (object) {
            this.printIndent();
            super.write(string, n, n2);
        }
    }

    public void indent() {
        this.incrementIndentLevel();
    }

    public void undent() {
        this.decrementIndentLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementIndentLevel() {
        Object object = this.lock;
        synchronized (object) {
            ++this.indentLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementIndentLevel() {
        Object object = this.lock;
        synchronized (object) {
            --this.indentLevel;
        }
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndentLevel(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.indentLevel = n;
        }
    }
}

