/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.node;

import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.node.PluggableValidator;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public interface Node
extends Comparable {
    public static final String DIRTY_BRANCH_PROPERTY = "dirtyBranch";
    public static final String BRANCH_PROBLEMS_LIST = "branchProblems";
    public static final String HAS_BRANCH_PROBLEMS_PROPERTY = "hasBranchProblems";
    public static final Comparator DEFAULT_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            int n = Collator.getInstance().compare(((Node)object).displayString(), ((Node)object2).displayString());
            if (n != 0) {
                return n;
            }
            n = System.identityHashCode(object) - System.identityHashCode(object2);
            if (n != 0) {
                return n;
            }
            return -1;
        }

        public String toString() {
            return "Node.DEFAULT_COMPARATOR";
        }
    };
    public static final Validator NULL_VALIDATOR = new PluggableValidator(PluggableValidator.Delegate.NULL_DELEGATE){

        public String toString() {
            return "Node.NULL_VALIDATOR";
        }
    };

    public Iterator children();

    public void setParent(Node var1);

    public Node getParent();

    public void setChildBackpointers();

    public boolean isDescendantOf(Node var1);

    public void addBranchReferencesTo(Collection var1);

    public void addAllNodesTo(Collection var1);

    public void nodeRemoved(Node var1);

    public void nodeRenamed(Node var1);

    public boolean isDirtyBranch();

    public void markBranchDirty();

    public void markEntireBranchDirty();

    public void markBranchCleanIfPossible();

    public void cascadeMarkEntireBranchClean();

    public ChangeNotifier getChangeNotifier();

    public void setChangeNotifier(ChangeNotifier var1);

    public Validator getValidator();

    public void setValidator(Validator var1);

    public void validateBranch();

    public boolean validateBranchInternal();

    public ListIterator branchProblems();

    public int branchProblemsSize();

    public boolean hasBranchProblems();

    public boolean containsBranchProblem(Problem var1);

    public void rebuildBranchProblems();

    public void addBranchProblemsTo(List var1);

    public void clearAllBranchProblems();

    public boolean clearAllBranchProblemsInternal();

    public String displayString();

    public static class SimpleReference
    implements Reference {
        private Node source;
        private Node target;

        public SimpleReference(Node node, Node node2) {
            if (node == null || node2 == null) {
                throw new NullPointerException();
            }
            this.source = node;
            this.target = node2;
        }

        public Node getSource() {
            return this.source;
        }

        public Node getTarget() {
            return this.target;
        }

        public String toString() {
            return StringTools.buildToStringFor(this, this.source + " => " + this.target);
        }
    }

    public static interface Validator {
        public void validate();

        public void pause();

        public void resume();
    }

    public static interface Reference {
        public Node getSource();

        public Node getTarget();
    }
}

