/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;

public abstract class AbstractEnablableFrameworkAction
extends AbstractFrameworkAction {
    protected ApplicationNode[] selectedNodes;
    private PropertyChangeListener enabledStateListener;
    protected static final String[] DEFAULT_ENABLED_PROPERTY_NAMES = new String[0];

    protected AbstractEnablableFrameworkAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void updateEnabledState() {
        for (int i = 0; i < this.selectedNodes.length; ++i) {
            if (this.shouldBeEnabled(this.selectedNodes[i])) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    protected abstract boolean shouldBeEnabled(ApplicationNode var1);

    public void setUp() {
        super.setUp();
        this.selectedNodes = this.selectedNodes();
        this.engageListeners();
        this.updateEnabledState();
    }

    public void tearDown() {
        this.disengageListeners();
        this.selectedNodes = null;
        super.tearDown();
    }

    protected void engageListeners() {
        for (int i = 0; i < this.selectedNodes.length; ++i) {
            this.engageListeners((AbstractApplicationNode)this.selectedNodes[i]);
        }
    }

    protected void engageListeners(AbstractApplicationNode abstractApplicationNode) {
        this.engageValueEnabled(abstractApplicationNode);
    }

    protected void disengageListeners() {
        for (int i = 0; i < this.selectedNodes.length; ++i) {
            this.disengageListeners((AbstractApplicationNode)this.selectedNodes[i]);
        }
    }

    protected void disengageListeners(AbstractApplicationNode abstractApplicationNode) {
        this.disengageValueEnabled(abstractApplicationNode);
    }

    protected void engageValueEnabled(AbstractApplicationNode abstractApplicationNode) {
        this.engageValue(abstractApplicationNode, this.enabledPropertyNames(), this.getEnabledStateListener());
    }

    protected void engageValue(AbstractApplicationNode abstractApplicationNode, String[] stringArray, PropertyChangeListener propertyChangeListener) {
        this.engage(abstractApplicationNode, stringArray, propertyChangeListener);
    }

    protected void engage(AbstractApplicationNode abstractApplicationNode, String[] stringArray, PropertyChangeListener propertyChangeListener) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.engage(abstractApplicationNode, stringArray[n], propertyChangeListener);
        }
    }

    protected void engage(AbstractApplicationNode abstractApplicationNode, String string, PropertyChangeListener propertyChangeListener) {
        abstractApplicationNode.addValuePropertyChangeListener(string, propertyChangeListener);
    }

    protected void disengageValueEnabled(AbstractApplicationNode abstractApplicationNode) {
        this.disengageValue(abstractApplicationNode, this.enabledPropertyNames(), this.getEnabledStateListener());
    }

    protected void disengageValue(AbstractApplicationNode abstractApplicationNode, String[] stringArray, PropertyChangeListener propertyChangeListener) {
        this.disengage(abstractApplicationNode, stringArray, propertyChangeListener);
    }

    protected void disengage(AbstractApplicationNode abstractApplicationNode, String[] stringArray, PropertyChangeListener propertyChangeListener) {
        int n = stringArray.length;
        while (n-- > 0) {
            this.disengage(abstractApplicationNode, stringArray[n], propertyChangeListener);
        }
    }

    protected void disengage(AbstractApplicationNode abstractApplicationNode, String string, PropertyChangeListener propertyChangeListener) {
        abstractApplicationNode.removeValuePropertyChangeListener(string, propertyChangeListener);
    }

    protected PropertyChangeListener getEnabledStateListener() {
        if (this.enabledStateListener == null) {
            this.enabledStateListener = this.buildEnabledStateListener();
        }
        return this.enabledStateListener;
    }

    protected PropertyChangeListener buildEnabledStateListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AbstractEnablableFrameworkAction.this.updateEnabledState();
            }
        };
    }

    protected String[] enabledPropertyNames() {
        return DEFAULT_ENABLED_PROPERTY_NAMES;
    }
}

