/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;

public class AddRemoveTablePanel
extends AddRemovePanel {
    private JTable table;

    public AddRemoveTablePanel(ApplicationContext applicationContext, AddRemovePanel.Adapter adapter, ListValueModel listValueModel, ColumnAdapter columnAdapter) {
        this(applicationContext, adapter, listValueModel, columnAdapter, 2);
    }

    public AddRemoveTablePanel(ApplicationContext applicationContext, AddRemovePanel.Adapter adapter, ListValueModel listValueModel, ColumnAdapter columnAdapter, int n) {
        this(applicationContext, adapter, listValueModel, columnAdapter, n, null, new NodeSelector.DefaultNodeSelector());
    }

    public AddRemoveTablePanel(ApplicationContext applicationContext, AddRemovePanel.Adapter adapter, ListValueModel listValueModel, ColumnAdapter columnAdapter, int n, NodeSelector nodeSelector) {
        this(applicationContext, adapter, listValueModel, columnAdapter, n, null, nodeSelector);
    }

    public AddRemoveTablePanel(ApplicationContext applicationContext, AddRemovePanel.Adapter adapter, ListValueModel listValueModel, ColumnAdapter columnAdapter, int n, String string, NodeSelector nodeSelector) {
        super(applicationContext, adapter, listValueModel, n, nodeSelector);
        this.initialize(listValueModel, columnAdapter);
        this.initializeLayout(string);
    }

    public AddRemoveTablePanel(ApplicationContext applicationContext, AddRemovePanel.Adapter adapter, ListValueModel listValueModel, ColumnAdapter columnAdapter, String string) {
        this(applicationContext, adapter, listValueModel, columnAdapter, 2, string, new NodeSelector.DefaultNodeSelector());
    }

    protected void initialize(ListValueModel listValueModel, ColumnAdapter columnAdapter) {
        this.table = SwingComponentFactory.buildTable(new TableModelAdapter(listValueModel, columnAdapter), this.getSelectionModel());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.addKeyListener(this.buildF3KeyListener());
    }

    protected void initializeLayout(String string) {
        this.initializeButtonPanel();
        this.initializeTablePanel(string);
    }

    protected void initializeTablePanel(String string) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.getButtonOrientation() == 1) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
        } else if (this.getButtonOrientation() == 4) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
        } else {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
        }
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.table.getAccessibleContext().setAccessibleName(string);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setMinimumSize(new Dimension(1, 1));
        jScrollPane.setPreferredSize(new Dimension(1, 1));
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.getViewport().setBackground(this.table.getBackground());
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    public JComponent getComponent() {
        return this.table;
    }

    protected void moveItemsDown() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        super.moveItemsDown();
    }

    protected void moveItemsUp() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        super.moveItemsUp();
    }

    protected void addNewItem() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        super.addNewItem();
    }

    protected void removeSelectedItems() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        super.removeSelectedItems();
    }
}

