/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableListCellRenderer;

public final class DualListSelectorPanel
extends AbstractPanel {
    ListValueModel availableLVM;
    private ListModel availableLM;
    private ObjectListSelectionModel availableLSM;
    ListValueModel selectedLVM;
    private ListModel selectedLM;
    private ObjectListSelectionModel selectedLSM;
    private Adapter adapter;
    private ListCellRenderer listCellRenderer;
    private String availableListBoxLabelKey;
    private String selectedListBoxLabelKey;
    private String selectButtonToolTipKey;
    private String deselectButtonToolTipKey;
    private Action selectAction;
    private Action deselectAction;

    DualListSelectorPanel(Builder builder) {
        super(builder.getContext());
        this.availableLVM = builder.getAvailableLVM();
        if (this.availableLVM == null) {
            throw new NullPointerException();
        }
        this.availableLM = new ListModelAdapter(this.availableLVM);
        this.availableLSM = new ObjectListSelectionModel(this.availableLM);
        this.selectedLVM = builder.getSelectedLVM();
        if (this.selectedLVM == null) {
            throw new NullPointerException();
        }
        this.selectedLM = new ListModelAdapter(this.selectedLVM);
        this.selectedLSM = new ObjectListSelectionModel(this.selectedLM);
        this.adapter = builder.getAdapter();
        if (this.adapter == null) {
            this.adapter = new DefaultAdapter();
        }
        this.listCellRenderer = builder.getListCellRenderer();
        if (this.listCellRenderer == null) {
            this.listCellRenderer = new DisplayableListCellRenderer();
        }
        this.availableListBoxLabelKey = builder.getAvailableListBoxLabelKey();
        if (this.availableListBoxLabelKey == null) {
            this.availableListBoxLabelKey = "AVAILABLE_ITEMS_LIST_BOX_LABEL";
        }
        this.selectedListBoxLabelKey = builder.getSelectedListBoxLabelKey();
        if (this.selectedListBoxLabelKey == null) {
            this.selectedListBoxLabelKey = "SELECTED_ITEMS_LIST_LABEL";
        }
        this.selectButtonToolTipKey = builder.getSelectButtonToolTipKey();
        if (this.selectButtonToolTipKey == null) {
            this.selectButtonToolTipKey = "ADD_SELECTED_ITEMS_BUTTON.toolTipText";
        }
        this.deselectButtonToolTipKey = builder.getDeselectButtonToolTipKey();
        if (this.deselectButtonToolTipKey == null) {
            this.deselectButtonToolTipKey = "REMOVE_SELECTED_ITEMS_BUTTON.toolTipText";
        }
        this.addHelpTopicId(this, builder.getHelpTopicID());
        this.selectAction = this.buildSelectAction();
        this.deselectAction = this.buildDeselectAction();
        this.initializeLayout();
    }

    private Action buildSelectAction() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DualListSelectorPanel.this.selectItems();
            }
        };
        abstractAction.setEnabled(false);
        return abstractAction;
    }

    private Action buildDeselectAction() {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DualListSelectorPanel.this.deselectItems();
            }
        };
        abstractAction.setEnabled(false);
        return abstractAction;
    }

    private void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(this.resourceRepository().getString(this.availableListBoxLabelKey));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        Component component = this.buildListBox(this.availableLM, this.availableLSM, this.selectAction);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        this.add(component, gridBagConstraints);
        jLabel.setLabelFor(component);
        JLabel jLabel2 = new JLabel(this.resourceRepository().getString(this.selectedListBoxLabelKey));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        Component component2 = this.buildListBox(this.selectedLM, this.selectedLSM, this.deselectAction);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 5, 0, 0);
        this.add(component2, gridBagConstraints);
        jLabel2.setLabelFor(component2);
        JButton jButton = new JButton();
        jButton.setAction(this.selectAction);
        jButton.setIcon(this.resourceRepository().getIcon("shuttle.right"));
        jButton.setToolTipText(this.resourceRepository().getString(this.selectButtonToolTipKey));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 5, 0, 0);
        this.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton();
        jButton2.setAction(this.deselectAction);
        jButton2.setIcon(this.resourceRepository().getIcon("shuttle.left"));
        jButton2.setToolTipText(this.resourceRepository().getString(this.deselectButtonToolTipKey));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.add((Component)jButton2, gridBagConstraints);
    }

    private Component buildListBox(ListModel listModel, ListSelectionModel listSelectionModel, Action action) {
        JList jList = SwingComponentFactory.buildList(listModel);
        jList.setSelectionModel(listSelectionModel);
        jList.setCellRenderer(this.listCellRenderer);
        jList.setSelectionMode(2);
        jList.addListSelectionListener(new LocalListSelectionListener(action));
        jList.addMouseListener(new DoubleClickActionMouseAdapter(action));
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setPreferredSize(new Dimension(200, 100));
        jScrollPane.setMinimumSize(new Dimension(200, 100));
        return jScrollPane;
    }

    void selectItems() {
        Object[] objectArray = this.availableLSM.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            this.adapter.select(objectArray[i]);
        }
        this.selectedLSM.setSelectedValues(objectArray);
    }

    void deselectItems() {
        Object[] objectArray = this.selectedLSM.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            this.adapter.deselect(objectArray[i]);
        }
        this.availableLSM.setSelectedValues(objectArray);
    }

    private class LocalListSelectionListener
    implements ListSelectionListener {
        private Action action;

        LocalListSelectionListener(Action action) {
            this.action = action;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            this.action.setEnabled(((JList)listSelectionEvent.getSource()).getSelectedIndex() != -1);
        }
    }

    private class DoubleClickActionMouseAdapter
    extends MouseAdapter {
        private Action action;

        DoubleClickActionMouseAdapter(Action action) {
            this.action = action;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                this.action.actionPerformed(null);
            }
        }
    }

    public static class Builder {
        private ListValueModel availableLVM;
        private ListValueModel selectedLVM;
        private Adapter adapter;
        private ListCellRenderer listCellRenderer;
        private ApplicationContext context;
        private String availableListBoxLabelKey;
        private String selectedListBoxLabelKey;
        private String selectButtonToolTipKey;
        private String deselectButtonToolTipKey;
        private String helpTopicID;

        public DualListSelectorPanel buildPanel() {
            return new DualListSelectorPanel(this);
        }

        public void setAvailableLVM(ListValueModel listValueModel) {
            this.availableLVM = listValueModel;
        }

        public ListValueModel getAvailableLVM() {
            return this.availableLVM;
        }

        public void setSelectedLVM(ListValueModel listValueModel) {
            this.selectedLVM = listValueModel;
        }

        public ListValueModel getSelectedLVM() {
            return this.selectedLVM;
        }

        public void setAdapter(Adapter adapter) {
            this.adapter = adapter;
        }

        public Adapter getAdapter() {
            return this.adapter;
        }

        public void setListCellRenderer(ListCellRenderer listCellRenderer) {
            this.listCellRenderer = listCellRenderer;
        }

        public ListCellRenderer getListCellRenderer() {
            return this.listCellRenderer;
        }

        public void setContext(ApplicationContext applicationContext) {
            this.context = applicationContext;
        }

        public ApplicationContext getContext() {
            return this.context;
        }

        public void setAvailableListBoxLabelKey(String string) {
            this.availableListBoxLabelKey = string;
        }

        public String getAvailableListBoxLabelKey() {
            return this.availableListBoxLabelKey;
        }

        public void setSelectedListBoxLabelKey(String string) {
            this.selectedListBoxLabelKey = string;
        }

        public String getSelectedListBoxLabelKey() {
            return this.selectedListBoxLabelKey;
        }

        public void setSelectButtonToolTipKey(String string) {
            this.selectButtonToolTipKey = string;
        }

        public String getSelectButtonToolTipKey() {
            return this.selectButtonToolTipKey;
        }

        public void setDeselectButtonToolTipKey(String string) {
            this.deselectButtonToolTipKey = string;
        }

        public String getDeselectButtonToolTipKey() {
            return this.deselectButtonToolTipKey;
        }

        public void setHelpTopicID(String string) {
            this.helpTopicID = string;
        }

        public String getHelpTopicID() {
            return this.helpTopicID;
        }
    }

    private class DefaultAdapter
    implements Adapter {
        private DefaultAdapter() {
        }

        public void select(Object object) {
            this.remove(DualListSelectorPanel.this.availableLVM, object);
            this.add(DualListSelectorPanel.this.selectedLVM, object);
        }

        public void deselect(Object object) {
            this.remove(DualListSelectorPanel.this.selectedLVM, object);
            this.add(DualListSelectorPanel.this.availableLVM, object);
        }

        private void remove(ListValueModel listValueModel, Object object) {
            int n = listValueModel.size();
            for (int i = 0; i < n; ++i) {
                if (listValueModel.getItem(i) != object) continue;
                listValueModel.removeItem(i);
                return;
            }
        }

        private void add(ListValueModel listValueModel, Object object) {
            listValueModel.addItem(listValueModel.size(), object);
        }
    }

    public static interface Adapter {
        public void select(Object var1);

        public void deselect(Object var1);
    }
}

