/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledBorder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorExtractionMethodPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ClassExtractionMethodPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ExtractionMethodListener;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.IndicatorDictionaryListener;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.IndicatorFieldListener;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RootListener;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

public abstract class ClassIndicatorPolicySubPanel
extends AbstractPanel
implements RootListener,
IndicatorFieldListener {
    private ValueModel descriptorHolder;
    private ValueModel inheritancePolicyHolder;
    private PropertyValueModel classIndicatorPolicyHolder;
    private PropertyValueModel classIndicatorFieldPolicyHolder;
    private PropertyValueModel useNameModel;
    private boolean isRoot;
    private boolean isIndicatorField;
    private PropertyValueModel policyTypeModel;
    private JRadioButton useClassExtractionMethodRadioButton;
    protected JRadioButton useClassIndicatorFieldRadioButton;
    protected JRadioButton useClassNameAsIndicatorRadioButton;
    protected JRadioButton useClassIndicatorDictionaryRadioButton;

    protected ClassIndicatorPolicySubPanel(PropertyValueModel propertyValueModel, PropertyValueModel propertyValueModel2, WorkbenchContextHolder workbenchContextHolder, Collection collection) {
        super(workbenchContextHolder);
        this.initialize(propertyValueModel, propertyValueModel2, collection);
    }

    protected void initialize(PropertyValueModel propertyValueModel, PropertyValueModel propertyValueModel2, Collection collection) {
        this.descriptorHolder = propertyValueModel;
        this.inheritancePolicyHolder = propertyValueModel2;
        this.classIndicatorPolicyHolder = this.buildClassIndicatorPolicyHolder();
        this.classIndicatorFieldPolicyHolder = this.buildClassIndicatorFieldPolicyHolder();
        this.useNameModel = this.buildUseClassNameAsIndicatorHolder();
        this.policyTypeModel = this.buildClassIndicatorPolicyTypeAdapter();
        this.initializeLayout(collection);
    }

    protected abstract void initializeLayout(Collection var1);

    public void updateRootStatus(boolean bl) {
        this.isRoot = bl;
        this.updateEnablementStatus();
    }

    public void updateIndicatorFieldStatus(boolean bl) {
        this.isIndicatorField = bl;
        this.updateEnablementStatus();
    }

    protected void addExtractionMethodListener(final ExtractionMethodListener extractionMethodListener) {
        this.getPolicyTypeModel().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = propertyChangeEvent.getNewValue() == "classExtractionMethodClassIndicatorPolicy";
                extractionMethodListener.updateExtractionMethodStatus(bl);
            }
        });
        extractionMethodListener.updateExtractionMethodStatus(this.getPolicyTypeModel().getValue() == "classExtractionMethodClassIndicatorPolicy");
    }

    protected void addIndicatorFieldListener(final IndicatorFieldListener indicatorFieldListener) {
        this.getPolicyTypeModel().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = propertyChangeEvent.getNewValue() == "fieldClassIndicatorPolicy";
                indicatorFieldListener.updateIndicatorFieldStatus(bl);
            }
        });
        indicatorFieldListener.updateIndicatorFieldStatus(this.getPolicyTypeModel().getValue() == "fieldClassIndicatorPolicy");
    }

    protected void addIndicatorDictionaryListener(final IndicatorDictionaryListener indicatorDictionaryListener) {
        this.getUseNameModel().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = propertyChangeEvent.getNewValue() == Boolean.FALSE;
                indicatorDictionaryListener.updateIndicatorDictionaryStatus(bl);
            }
        });
    }

    protected void updateEnablementStatus() {
        this.useClassIndicatorFieldRadioButton.setEnabled(this.isRoot());
        this.useClassExtractionMethodRadioButton.setEnabled(this.isRoot());
        this.useClassNameAsIndicatorRadioButton.setEnabled(this.isRoot() && this.isIndicatorType());
        this.useClassIndicatorDictionaryRadioButton.setEnabled(this.isRoot() && this.isIndicatorType());
    }

    protected PropertyValueModel buildClassIndicatorPolicyHolder() {
        return new PropertyAspectAdapter(this.inheritancePolicyHolder, "classIndicatorPolicy"){

            protected Object getValueFromSubject() {
                return ((MWDescriptorInheritancePolicy)this.subject).getClassIndicatorPolicy();
            }
        };
    }

    private PropertyValueModel buildClassIndicatorPolicyTypeAdapter() {
        return new PropertyAspectAdapter(this.inheritancePolicyHolder, "classIndicatorPolicy"){

            protected Object getValueFromSubject() {
                if (((MWDescriptorInheritancePolicy)this.subject).getClassIndicatorPolicy() == null) {
                    return null;
                }
                return ((MWDescriptorInheritancePolicy)this.subject).getClassIndicatorPolicy().getType();
            }

            protected void setValueOnSubject(Object object) {
                if ((String)object == "classExtractionMethodClassIndicatorPolicy") {
                    ((MWDescriptorInheritancePolicy)this.subject).useClassExtractionMethodIndicatorPolicy();
                } else if ((String)object == "fieldClassIndicatorPolicy") {
                    ((MWDescriptorInheritancePolicy)this.subject).useClassIndicatorFieldPolicy();
                }
            }
        };
    }

    private PropertyValueModel buildUseClassNameAsIndicatorHolder() {
        return new PropertyAspectAdapter(this.getClassIndicatorFieldPolicyHolder(), "classNameIsIndicator"){

            protected Object getValueFromSubject() {
                return ((MWClassIndicatorFieldPolicy)this.subject).classNameIsIndicator();
            }

            protected void setValueOnSubject(Object object) {
                ((MWClassIndicatorFieldPolicy)this.subject).setClassNameIsIndicator(((Boolean)object).booleanValue());
            }
        };
    }

    protected RadioButtonModelAdapter buildClassNameAsIndicatorRadioButtonModel(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, Boolean.TRUE);
    }

    protected RadioButtonModelAdapter buildClassIndicatorDictionaryRadioButtonModel(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, Boolean.FALSE);
    }

    protected RadioButtonModelAdapter buildClassIndicatorPolicyRadioButtonModel(String string) {
        return new RadioButtonModelAdapter(this.policyTypeModel, string);
    }

    protected JPanel buildUseClassExtractionMethodPanel(Collection collection) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        AccessibleTitledPanel accessibleTitledPanel = new AccessibleTitledPanel(new GridBagLayout());
        this.useClassExtractionMethodRadioButton = this.buildRadioButton("USE_CLASS_EXTRACTION_METHOD", this.buildClassIndicatorPolicyRadioButtonModel("classExtractionMethodClassIndicatorPolicy"));
        accessibleTitledPanel.setEnabled(this.isRoot());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        accessibleTitledPanel.add((Component)this.useClassExtractionMethodRadioButton, gridBagConstraints);
        ClassExtractionMethodPanel classExtractionMethodPanel = new ClassExtractionMethodPanel(this.getApplicationContext(), this.buildClassExtractionMethodIndirectionPolicyHolder());
        collection.add(classExtractionMethodPanel);
        this.addExtractionMethodListener(classExtractionMethodPanel);
        classExtractionMethodPanel.setBorder(new AccessibleTitledBorder(this.useClassExtractionMethodRadioButton.getText()));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, SwingTools.checkBoxIconWidth(), 0, 0);
        accessibleTitledPanel.add((Component)classExtractionMethodPanel, gridBagConstraints);
        this.addHelpTopicId(accessibleTitledPanel, this.helpTopicId() + ".useClassExtraction");
        return accessibleTitledPanel;
    }

    private PropertyValueModel buildClassExtractionMethodIndirectionPolicyHolder() {
        return new FilteringPropertyValueModel(this.classIndicatorPolicyHolder){

            protected boolean accept(Object object) {
                return object instanceof MWClassIndicatorExtractionMethodPolicy;
            }
        };
    }

    private PropertyValueModel buildClassIndicatorFieldPolicyHolder() {
        return new FilteringPropertyValueModel(this.classIndicatorPolicyHolder){

            protected boolean accept(Object object) {
                return object instanceof MWClassIndicatorFieldPolicy;
            }
        };
    }

    protected String helpTopicId() {
        return "descriptor.inheritance.classIndicator";
    }

    protected PropertyValueModel getUseNameModel() {
        return this.useNameModel;
    }

    protected PropertyValueModel getPolicyTypeModel() {
        return this.policyTypeModel;
    }

    protected PropertyValueModel getClassIndicatorPolicyHolder() {
        return this.classIndicatorPolicyHolder;
    }

    protected PropertyValueModel getClassIndicatorFieldPolicyHolder() {
        return this.classIndicatorFieldPolicyHolder;
    }

    protected ValueModel getDescriptorHolder() {
        return this.descriptorHolder;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isIndicatorType() {
        return this.isIndicatorField;
    }
}

