/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ClassCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ClassModifiersPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class ClassPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel mwClassHolder;

    ClassPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.mwClassHolder = this.buildMWClassHolder();
    }

    private PropertyValueModel buildMWClassHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWDescriptor)this.subject).getMWClass();
            }
        };
    }

    protected Component buildPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JComponent jComponent = this.buildLabeledComponent("CLASS_NAME_LABEL", this.buildClassNameTextField());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jComponent, gridBagConstraints);
        this.addHelpTopicId(jComponent, this.helpTopicId() + ".name");
        JLabel jLabel = this.buildLabel("SUPER_CLASS_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.addAlignLeft(jLabel);
        ClassChooserPanel classChooserPanel = ClassChooserTools.buildPanel(this.buildSuperClassHolder(), this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableReferenceFilter(), jLabel, this.getWorkbenchContextHolder());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)classChooserPanel, gridBagConstraints);
        this.addPaneForAlignment(classChooserPanel);
        this.addHelpTopicId(classChooserPanel, this.helpTopicId() + ".superclass");
        JPanel jPanel2 = this.buildPropertiesPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    protected JPanel buildPropertiesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ClassModifiersPanel classModifiersPanel = new ClassModifiersPanel((ValueModel)this.mwClassHolder, this.getApplicationContext());
        this.addHelpTopicId(classModifiersPanel, this.helpTopicId() + ".modifiers");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)classModifiersPanel, gridBagConstraints);
        AddRemoveListPanel addRemoveListPanel = this.buildInterfacesListPanel();
        this.addHelpTopicId(addRemoveListPanel, this.helpTopicId() + ".interfaces");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)addRemoveListPanel, gridBagConstraints);
        return jPanel;
    }

    ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            public MWClassRepository getClassRepository() {
                return ClassPropertiesPage.this.getMWClass().getRepository();
            }
        };
    }

    WorkbenchContext workbenchContext() {
        return this.getWorkbenchContext();
    }

    private JTextField buildClassNameTextField() {
        JTextField jTextField = SwingComponentFactory.buildTextField(this.buildClassNameTextFieldDocument());
        jTextField.setEditable(false);
        return jTextField;
    }

    private Document buildClassNameTextFieldDocument() {
        return new DocumentAdapter(this.buildClassNameHolder(), new RegexpDocument(3));
    }

    private PropertyValueModel buildClassNameHolder() {
        return new PropertyAspectAdapter(this.mwClassHolder, "name"){

            protected Object getValueFromSubject() {
                return ((MWClass)this.subject).getName();
            }
        };
    }

    private PropertyValueModel buildSuperClassHolder() {
        return new PropertyAspectAdapter(this.mwClassHolder, "superclass"){

            protected Object getValueFromSubject() {
                return ((MWClass)this.subject).getSuperclass();
            }

            protected void setValueOnSubject(Object object) {
                ((MWClass)this.subject).setSuperclass((MWClass)object);
            }
        };
    }

    private AddRemoveListPanel buildInterfacesListPanel() {
        TitledBorder titledBorder = new TitledBorder(this.resourceRepository().getString("INTERFACES_IMPLEMENTED_LIST"));
        AddRemoveListPanel addRemoveListPanel = new AddRemoveListPanel(this.getApplicationContext(), this.buildAddRemoveListPanelAdapter(), this.buildSortedInterfacesListModel(), 2);
        addRemoveListPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        addRemoveListPanel.setCellRenderer(this.buildInterfacesListCellRenderer());
        addRemoveListPanel.setName(this.resourceRepository().getString("INTERFACES_LIST_NAME"));
        return addRemoveListPanel;
    }

    private ListCellRenderer buildInterfacesListCellRenderer() {
        return new AdaptableListCellRenderer(new ClassCellRendererAdapter(this.resourceRepository()));
    }

    private AddRemovePanel.Adapter buildAddRemoveListPanelAdapter() {
        return new AddRemovePanel.Adapter(){

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                MWClass mWClass = ClassChooserTools.promptForType(ClassPropertiesPage.this.getMWClass().getRepository(), ClassChooserTools.buildDeclarableReferenceFilter(), ClassPropertiesPage.this.workbenchContext());
                if (mWClass == null) {
                    return;
                }
                ClassPropertiesPage.this.getMWClass().addInterface(mWClass);
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                ClassPropertiesPage.this.getMWClass().removeInterfaces(CollectionTools.collection((Object[])objectListSelectionModel.getSelectedValues()));
            }
        };
    }

    private ListValueModel buildSortedInterfacesListModel() {
        return new SortedListValueModelAdapter(this.buildItemListValueModelAdapter());
    }

    private ItemPropertyListValueModelAdapter buildItemListValueModelAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildInterfacesCollectionValueModel(), "name");
    }

    private CollectionValueModel buildInterfacesCollectionValueModel() {
        return new CollectionAspectAdapter(this.mwClassHolder, "interfaces"){

            protected Iterator getValueFromSubject() {
                return ((MWClass)this.subject).interfaces();
            }

            protected int sizeFromSubject() {
                return ((MWClass)this.subject).interfacesSize();
            }
        };
    }

    MWClass getMWClass() {
        return (MWClass)this.mwClassHolder.getValue();
    }

    protected String helpTopicId() {
        return "descriptor.classInfo.class";
    }
}

