/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MethodModifiersPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MethodParametersPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;

final class MethodPropertiesPanel
extends AbstractPanel {
    private PropertyValueModel methodHolder;
    private PropertyValueModel returnTypeHolder;

    MethodPropertiesPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.methodHolder = propertyValueModel;
        this.returnTypeHolder = this.buildReturnTypeHolder();
        this.initializeLayout();
    }

    private PropertyValueModel buildReturnTypeHolder() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.methodHolder, "returnType"){

            protected Object getValueFromSubject() {
                if (((MWMethod)this.subject).isConstructor()) {
                    return null;
                }
                return ((MWMethod)this.subject).getReturnType();
            }

            protected void setValueOnSubject(Object object) {
                ((MWMethod)this.subject).setReturnType((MWClass)object);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "name");
    }

    protected String helpTopicId() {
        return "descriptor.classInfo.methods.properties";
    }

    private void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        MethodModifiersPanel methodModifiersPanel = new MethodModifiersPanel((ValueModel)this.methodHolder, this.getApplicationContext());
        this.addHelpTopicId(methodModifiersPanel, this.helpTopicId() + ".modifiers");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)methodModifiersPanel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(this.buildTitledBorder("RETURN_TYPE_PANEL_TITLE"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = this.buildLabel("RETURN_TYPE_LABEL");
        jLabel.setEnabled(false);
        this.methodHolder.addPropertyChangeListener("value", this.buildMethodListener(jLabel));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        ClassChooserPanel classChooserPanel = ClassChooserTools.buildPanel(this.returnTypeHolder, this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableFilter(), jLabel, this.getWorkbenchContextHolder());
        this.methodHolder.addPropertyChangeListener("value", this.buildMethodListener(classChooserPanel));
        classChooserPanel.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        jPanel.add((Component)classChooserPanel, gridBagConstraints);
        JLabel jLabel2 = this.buildLabel("DIMENSIONALITY_LABEL");
        jLabel2.setEnabled(false);
        this.methodHolder.addPropertyChangeListener("value", this.buildMethodListener(jLabel2));
        this.returnTypeHolder.addPropertyChangeListener("value", this.buildReturnTypeListener(jLabel2));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        JSpinner jSpinner = this.buildDimensionalitySpinner();
        jLabel2.setLabelFor(jSpinner);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jSpinner, gridBagConstraints);
        this.addHelpTopicId(jPanel, this.helpTopicId() + ".typeInfo");
        MethodParametersPanel methodParametersPanel = new MethodParametersPanel(this.methodHolder, this.getWorkbenchContextHolder());
        methodParametersPanel.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("PARAMETERS_TABLE_LABEL"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)methodParametersPanel, gridBagConstraints);
        this.addHelpTopicId(methodParametersPanel, this.helpTopicId() + ".parameters");
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            public MWClassRepository getClassRepository() {
                return MethodPropertiesPanel.this.getMethod().getRepository();
            }
        };
    }

    private JSpinner buildDimensionalitySpinner() {
        JSpinner jSpinner = new JSpinner(this.buildDimensionalitySpinnerModel());
        jSpinner.setPreferredSize(new Dimension(50, jSpinner.getPreferredSize().height));
        jSpinner.setEnabled(false);
        this.methodHolder.addPropertyChangeListener("value", this.buildMethodListener(jSpinner));
        this.returnTypeHolder.addPropertyChangeListener("value", this.buildReturnTypeListener(jSpinner));
        return jSpinner;
    }

    private SpinnerModel buildDimensionalitySpinnerModel() {
        return new NumberSpinnerModelAdapter(this.buildDimensionalityHolder(), new Integer(0), null, new Integer(1), new Integer(0));
    }

    private PropertyValueModel buildDimensionalityHolder() {
        return new PropertyAspectAdapter(this.methodHolder, "returnTypeDimensionality"){

            protected Object getValueFromSubject() {
                if (((MWMethod)this.subject).isConstructor()) {
                    return new Integer(0);
                }
                return new Integer(((MWMethod)this.subject).getReturnTypeDimensionality());
            }

            protected void setValueOnSubject(Object object) {
                ((MWMethod)this.subject).setReturnTypeDimensionality(((Integer)object).intValue());
            }
        };
    }

    private PropertyChangeListener buildMethodListener(final Component component) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                component.setEnabled(MethodPropertiesPanel.this.getMethod() != null && !MethodPropertiesPanel.this.getMethod().isConstructor());
            }
        };
    }

    private PropertyChangeListener buildReturnTypeListener(final Component component) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                component.setEnabled(propertyChangeEvent.getNewValue() == null ? false : !((MWClass)propertyChangeEvent.getNewValue()).isVoid());
            }
        };
    }

    private MWMethod getMethod() {
        return (MWMethod)this.methodHolder.getValue();
    }
}

