/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.NewClassNameDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UiDescriptorBundle;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

final class RenameDescriptorAction
extends AbstractFrameworkAction {
    RenameDescriptorAction(WorkbenchContext workbenchContext) {
        super(workbenchContext.buildExpandedResourceRepositoryContext(UiDescriptorBundle.class));
    }

    protected void initialize() {
        super.initialize();
        this.setIcon(EMPTY_ICON);
        this.initializeTextAndMnemonic("RENAME_DESCRIPTOR_ACTION");
        this.initializeToolTipText("RENAME_DESCRIPTOR_ACTION.toolTipText");
    }

    protected void execute(ApplicationNode applicationNode) {
        MWDescriptor mWDescriptor = (MWDescriptor)applicationNode.getValue();
        ApplicationNode applicationNode2 = applicationNode.getProjectRoot();
        this.navigatorSelectionModel().pushExpansionState();
        this.promptToRenameDescriptor(applicationNode);
        this.navigatorSelectionModel().popAndRestoreExpansionState();
        this.navigatorSelectionModel().setSelectedNode(applicationNode2.descendantNodeForValue((Node)mWDescriptor));
    }

    private void promptToRenameDescriptor(ApplicationNode applicationNode) {
        MWDescriptor mWDescriptor = (MWDescriptor)applicationNode.getValue();
        MWProject mWProject = mWDescriptor.getProject();
        NewClassNameDialog newClassNameDialog = this.buildNewClassNameDialog(mWProject, applicationNode, mWDescriptor.getName());
        newClassNameDialog.setTitle(this.resourceRepository().getString("RENAME_CLASS_DIALOG_TITLE"));
        newClassNameDialog.setAllowExistingType(false);
        newClassNameDialog.setVisible(true);
        if (newClassNameDialog.wasCanceled()) {
            return;
        }
        String string = newClassNameDialog.className();
        mWDescriptor.getMWClass().setName(string);
        mWDescriptor.setName(string);
    }

    private NewClassNameDialog buildNewClassNameDialog(MWProject mWProject, ApplicationNode applicationNode, String string) {
        return new NewClassNameDialog(this.buildPackageNames(mWProject), this.buildPackageName(applicationNode), ClassTools.shortNameForClassNamed((String)string), mWProject, this.getWorkbenchContext());
    }

    private Collection buildPackageNames(MWProject mWProject) {
        FilteringIterator filteringIterator = new FilteringIterator(mWProject.packageNames()){

            protected boolean accept(Object object) {
                return ((String)object).length() > 0;
            }
        };
        return CollectionTools.collection((Iterator)filteringIterator);
    }

    private String buildPackageName(ApplicationNode applicationNode) {
        return ((MappingsApplicationNode)applicationNode).candidatePackageName();
    }
}

