/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWObjectTypeConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TypeDeclarationCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

final class ObjectTypeConverterPanel
extends AbstractSubjectPanel {
    ObjectTypeConverterPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super((ValueModel)propertyValueModel, workbenchContextHolder);
    }

    MWObjectTypeConverter getObjectTypeConverter() {
        return (MWObjectTypeConverter)this.subject();
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JComponent jComponent = this.buildLabeledComponent("DATA_TYPE_LABEL", this.buildDataTypeChooser());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
        JComponent jComponent2 = this.buildLabeledComponent("ATTRIBUTE_TYPE_LABEL", this.buildAttributeTypeChooser());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)jComponent2, gridBagConstraints);
        JLabel jLabel = this.buildConversionValuesLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        this.addAlignLeft(jLabel);
        AbstractPanel abstractPanel = this.buildConversionValuesPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)abstractPanel, gridBagConstraints);
        this.addPaneForAlignment(abstractPanel);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private ListChooser buildDataTypeChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildDataTypeComboBoxModel(), this.getWorkbenchContextHolder(), this.buildDataTypeChooserDialogBuilder());
        defaultListChooser.setRenderer(this.buildMWClassListCellRenderer());
        return defaultListChooser;
    }

    private DefaultListChooserDialog.Builder buildDataTypeChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("DATA_TYPE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("DATA_TYPE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMWClassStringConverter());
        return builder;
    }

    private ComboBoxModel buildDataTypeComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildTypesCollectionModel(), this.buildDataTypeHolder());
    }

    private PropertyValueModel buildDataTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "dataType"){

            protected Object getValueFromSubject() {
                return ((MWObjectTypeConverter)this.subject).getDataType();
            }

            protected void setValueOnSubject(Object object) {
                ((MWObjectTypeConverter)this.subject).setDataType((MWTypeDeclaration)object);
            }
        };
    }

    private CollectionValueModel buildTypesCollectionModel() {
        return new CollectionAspectAdapter(this.getSubjectHolder()){

            protected Iterator getValueFromSubject() {
                return ((MWConverter)this.subject).buildBasicTypes().iterator();
            }
        };
    }

    private StringConverter buildMWClassStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWTypeDeclaration)object).displayStringWithPackage();
            }
        };
    }

    private ListCellRenderer buildMWClassListCellRenderer() {
        return new AdaptableListCellRenderer(new TypeDeclarationCellRendererAdapter(this.resourceRepository()));
    }

    private ListChooser buildAttributeTypeChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildAttributeTypeComboBoxModel(), this.getWorkbenchContextHolder(), this.buildAttributeTypeChooserDialogBuilder());
        defaultListChooser.setRenderer(this.buildMWClassListCellRenderer());
        return defaultListChooser;
    }

    private DefaultListChooserDialog.Builder buildAttributeTypeChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("ATTRIBUTE_TYPE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("ATTRIBUTE_TYPE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildMWClassStringConverter());
        return builder;
    }

    private ComboBoxModel buildAttributeTypeComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildTypesCollectionModel(), this.buildAttributeTypeHolder());
    }

    private PropertyValueModel buildAttributeTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "attributeType"){

            protected Object getValueFromSubject() {
                return ((MWObjectTypeConverter)this.subject).getAttributeType();
            }

            protected void setValueOnSubject(Object object) {
                ((MWObjectTypeConverter)this.subject).setAttributeType((MWTypeDeclaration)object);
            }
        };
    }

    private JLabel buildConversionValuesLabel() {
        JLabel jLabel = this.buildLabel("CONVERSION_VALUES_TABLE_LABEL");
        return jLabel;
    }

    private AbstractPanel buildConversionValuesPanel() {
        return new ConversionValuesPanel(this.getSubjectHolder(), this.getWorkbenchContextHolder());
    }

    protected String helpTopicId() {
        return "mapping.converter.objectType";
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            this.getComponent(i).setEnabled(bl);
        }
    }

    private static class ValuePairsColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 3;
        public static final int DATA_VALUE_COLUMN = 0;
        public static final int ATTRIBUTE_VALUE_COLUMN = 1;
        public static final int DEFAULT_ATTRIBUTE_VALUE_COLUMN = 2;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"DATA_VALUE_HEADER", "ATTRIBUTE_VALUE_HEADER", "DEFAULT_ATTRIBUTE_VALUE_HEADER"};

        protected ValuePairsColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[n]);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int n) {
            return n == 2;
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWObjectTypeConverter.ValuePair valuePair = (MWObjectTypeConverter.ValuePair)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildDataValueAdapter(valuePair), this.buildAttributeValueAdapter(valuePair), this.buildDefaultAttributeValueAdapter(valuePair)};
            return propertyValueModelArray;
        }

        private PropertyValueModel buildDataValueAdapter(MWObjectTypeConverter.ValuePair valuePair) {
            return new PropertyAspectAdapter("dataValue", (Model)valuePair){

                protected Object getValueFromSubject() {
                    return ((MWObjectTypeConverter.ValuePair)this.subject).getDataValueAsString();
                }
            };
        }

        private PropertyValueModel buildAttributeValueAdapter(MWObjectTypeConverter.ValuePair valuePair) {
            return new PropertyAspectAdapter("attributeValue", (Model)valuePair){

                protected Object getValueFromSubject() {
                    return ((MWObjectTypeConverter.ValuePair)this.subject).getAttributeValueAsString();
                }
            };
        }

        private PropertyValueModel buildDefaultAttributeValueAdapter(MWObjectTypeConverter.ValuePair valuePair) {
            return new PropertyAspectAdapter("defaultAttributeValue", (Model)valuePair){

                protected Object getValueFromSubject() {
                    return ((MWObjectTypeConverter.ValuePair)this.subject).isDefaultAttributeValue();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWObjectTypeConverter.ValuePair)this.subject).setDefaultAttributeValue(((Boolean)object).booleanValue());
                }
            };
        }
    }

    private static class ConversionValueDialog
    extends AbstractDialog {
        private MWObjectTypeConverter converter;
        private MWObjectTypeConverter.ValuePair valuePair;
        private int mode;
        private static final int ADD_MODE = 0;
        private static final int EDIT_MODE = 1;
        private RegexpDocument dataValueDocument;
        private RegexpDocument attributeValueDocument;
        private Component dataValueTextField;

        static void promptToAddConversionValuePair(MWObjectTypeConverter mWObjectTypeConverter, WorkbenchContext workbenchContext) {
            new ConversionValueDialog(mWObjectTypeConverter, null, 0, workbenchContext).show();
        }

        static void promptToEditConversionValuePair(MWObjectTypeConverter.ValuePair valuePair, WorkbenchContext workbenchContext) {
            new ConversionValueDialog(valuePair.getObjectTypeConverter(), valuePair, 1, workbenchContext).show();
        }

        private ConversionValueDialog(MWObjectTypeConverter mWObjectTypeConverter, MWObjectTypeConverter.ValuePair valuePair, int n, WorkbenchContext workbenchContext) {
            super(workbenchContext);
            this.initialize(mWObjectTypeConverter, valuePair, n);
        }

        private void initialize(MWObjectTypeConverter mWObjectTypeConverter, MWObjectTypeConverter.ValuePair valuePair, int n) {
            this.converter = mWObjectTypeConverter;
            this.valuePair = valuePair;
            this.mode = n;
            this.dataValueDocument = this.buildDataValueDocument();
            this.attributeValueDocument = this.buildAttributeValueDocument();
        }

        protected void initialize() {
            super.initialize();
            this.getOKAction().setEnabled(false);
        }

        private String addOrEditString() {
            if (this.mode == 0) {
                return "ADD";
            }
            return "EDIT";
        }

        protected Component buildMainPanel() {
            this.setTitle(this.resourceRepository().getString("CONVERSION_VALUE_DIALOG_" + this.addOrEditString() + ".title"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets = UIManager.getInsets("TextField.margin");
            if (insets == null) {
                insets = new Insets(1, 2, 1, 2);
            }
            JPanel jPanel = new JPanel(new GridBagLayout());
            JLabel jLabel = new JLabel(this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.DATA_TYPE_LABEL"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)jLabel, gridBagConstraints);
            JTextField jTextField = new JTextField(this.converter.getDataType().displayStringWithPackage(), 20);
            jTextField.setEditable(false);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)jTextField, gridBagConstraints);
            JLabel jLabel2 = new JLabel(this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.DATA_VALUE_LABEL"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)jLabel2, gridBagConstraints);
            this.dataValueTextField = new JTextField(this.dataValueDocument, this.valuePairDataValueString(), 20);
            jLabel2.setLabelFor(this.dataValueTextField);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add(this.dataValueTextField, gridBagConstraints);
            JLabel jLabel3 = new JLabel(this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ATTRIBUTE_TYPE_LABEL"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(15, 5, 5, 5);
            jPanel.add((Component)jLabel3, gridBagConstraints);
            JTextField jTextField2 = new JTextField(this.converter.getAttributeType().displayStringWithPackage(), 20);
            jTextField2.setEditable(false);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(15, 5, 5, 5);
            jPanel.add((Component)jTextField2, gridBagConstraints);
            JLabel jLabel4 = new JLabel(this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ATTRIBUTE_VALUE_LABEL"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)jLabel4, gridBagConstraints);
            JTextField jTextField3 = new JTextField(this.attributeValueDocument, this.valuePairAttributeValueString(), 20);
            jLabel4.setLabelFor(jTextField3);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 19;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)jTextField3, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)new Spacer(), gridBagConstraints);
            return jPanel;
        }

        protected Component initialFocusComponent() {
            return this.dataValueTextField;
        }

        protected String helpTopicId() {
            return "mapping.converter.objectType.conversionValueDialog";
        }

        private RegexpDocument buildDataValueDocument() {
            this.dataValueDocument = new RegexpDocument(14);
            this.dataValueDocument.addDocumentListener(new ConversionValueDocumentHandler());
            return this.dataValueDocument;
        }

        private String valuePairDataValueString() {
            return this.valuePair == null ? "" : this.valuePair.getDataValueAsString();
        }

        private RegexpDocument buildAttributeValueDocument() {
            this.attributeValueDocument = new RegexpDocument(14);
            this.attributeValueDocument.addDocumentListener(new ConversionValueDocumentHandler());
            return this.attributeValueDocument;
        }

        private String valuePairAttributeValueString() {
            return this.valuePair == null ? "" : this.valuePair.getAttributeValueAsString();
        }

        protected boolean preConfirm() {
            return this.wasAbleToCompleteValuePair();
        }

        void updateOKButton() {
            boolean bl = !this.dataValueDocumentText().equals("") && !this.attributeValueDocumentText().equals("");
            this.getOKAction().setEnabled(bl);
        }

        private String dataValueDocumentText() {
            try {
                return this.dataValueDocument.getText(0, this.dataValueDocument.getLength());
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
        }

        private String attributeValueDocumentText() {
            try {
                return this.attributeValueDocument.getText(0, this.attributeValueDocument.getLength());
            }
            catch (BadLocationException badLocationException) {
                return "";
            }
        }

        public boolean wasAbleToCompleteValuePair() {
            block6: {
                String string = this.dataValueDocumentText();
                String string2 = this.attributeValueDocumentText();
                try {
                    if (this.mode == 0) {
                        this.converter.addValuePair(string, string2);
                    } else {
                        this.converter.editValuePair(this.valuePair, string, string2);
                    }
                }
                catch (ConversionException conversionException) {
                    this.showInvalidConversionDialog(conversionException);
                    return false;
                }
                catch (MWObjectTypeConverter.ConversionValueException conversionValueException) {
                    if (conversionValueException.isRepeatedDataValue()) {
                        this.showRepeatedDataValueDialog(string);
                        return false;
                    }
                    if (!conversionValueException.isRepeatedAttributeValue()) break block6;
                    this.showRepeatedAttributeValueDialog(string2);
                    return false;
                }
            }
            return true;
        }

        private void showInvalidConversionDialog(ConversionException conversionException) {
            JOptionPane.showMessageDialog(this.currentWindow(), this.getInvalidInputMessage(conversionException.getClassToConvertTo()), this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_FORMAT_DIALOG.title"), 2);
        }

        protected String getInvalidInputMessage(Class clazz) {
            String string = clazz.getName();
            if (clazz == Boolean.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_BOOLEAN_FORMAT", new Object[]{string});
            }
            if (clazz == Character.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_CHARACTER_FORMAT", new Object[]{string});
            }
            if (clazz == Short.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_NUMBER_FORMAT", new Object[]{string, new Short(Short.MIN_VALUE), new Short(Short.MAX_VALUE)});
            }
            if (clazz == Byte.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_NUMBER_FORMAT", new Object[]{string, new Byte(-128), new Byte(127)});
            }
            if (clazz == Float.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_FLOAT_NUMBER_FORMAT", new Object[]{string, new Float(Float.MIN_VALUE), new Float(Float.MAX_VALUE)});
            }
            if (clazz == Double.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_FLOAT_NUMBER_FORMAT", new Object[]{string, new Double(Double.MIN_VALUE), new Double(Double.MAX_VALUE)});
            }
            if (clazz == Integer.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_NUMBER_FORMAT", new Object[]{string, new Integer(Integer.MIN_VALUE), new Integer(Integer.MAX_VALUE)});
            }
            if (clazz == Long.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_NUMBER_FORMAT", new Object[]{string, new Long(Long.MIN_VALUE), new Long(Long.MAX_VALUE)});
            }
            if (clazz == String.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_STRING_FORMAT", new Object[]{string});
            }
            if (clazz == Number.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_NUMBER_CLASS_FORMAT", new Object[]{string});
            }
            if (clazz == BigDecimal.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_BIGDECIMAL_FORMAT", new Object[]{string});
            }
            if (clazz == BigInteger.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_BIGINTEGER_FORMAT", new Object[]{string});
            }
            if (clazz == Date.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_SQLDATE_FORMAT", new Object[]{string});
            }
            if (clazz == Time.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_SQLTIME_FORMAT", new Object[]{string});
            }
            if (clazz == Timestamp.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_SQLTIMESTAMP_FORMAT", new Object[]{string});
            }
            if (clazz == java.util.Date.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_UTILDATE_FORMAT", new Object[]{string});
            }
            if (clazz == Calendar.class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_UTILCALENDAR_FORMAT", new Object[]{string});
            }
            if (clazz == byte[].class || clazz == Byte[].class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_BYTEARRAY_FORMAT", new Object[]{string});
            }
            if (clazz == char[].class || clazz == Character[].class) {
                return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_CHARARRAY_FORMAT", new Object[]{string});
            }
            return this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.ILLEGAL_GENERIC_FORMAT");
        }

        private void showRepeatedDataValueDialog(String string) {
            JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.REPEATED_DATA_VALUE_DIALOG.message", string), this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.REPEATED_DATA_VALUE_DIALOG.title"), 2);
        }

        private void showRepeatedAttributeValueDialog(String string) {
            JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.REPEATED_OBJECT_VALUE_DIALOG.message", string), this.resourceRepository().getString("CONVERSION_VALUE_DIALOG.REPEATED_OBJECT_VALUE_DIALOG.title"), 2);
        }

        private class ConversionValueDocumentHandler
        implements DocumentListener {
            private ConversionValueDocumentHandler() {
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ConversionValueDialog.this.updateOKButton();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ConversionValueDialog.this.updateOKButton();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ConversionValueDialog.this.updateOKButton();
            }
        }
    }

    private class ConversionValuesPanel
    extends AbstractSubjectPanel {
        ObjectListSelectionModel valuePairsTableSelectionModel;
        private Action removeAction;
        private Action editAction;

        private ConversionValuesPanel(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
            super(valueModel, workbenchContextHolder);
        }

        protected void initializeLayout() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JButton jButton = this.buildAddConversionValueButton();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jButton, gridBagConstraints);
            this.addAlignRight(jButton);
            JButton jButton2 = this.buildEditConversionValueButton();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)jButton2, gridBagConstraints);
            this.addAlignRight(jButton2);
            JButton jButton3 = this.buildRemoveConversionValueButton();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 19;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)jButton3, gridBagConstraints);
            this.addAlignRight(jButton3);
            JTable jTable = this.buildValuePairsTable();
            JScrollPane jScrollPane = new JScrollPane(jTable);
            jScrollPane.setPreferredSize(new Dimension(10, 10));
            jScrollPane.getViewport().setBackground(jTable.getBackground());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            this.add((Component)jScrollPane, gridBagConstraints);
        }

        private JButton buildAddConversionValueButton() {
            Action action = this.buildAddConversionValueAction();
            this.addPropertyChangeListener("enabled", this.buildAddButtonEnabler(action));
            return new JButton(action);
        }

        private Action buildAddConversionValueAction() {
            return new AbstractAction(this.resourceRepository().getString("ADD_VALUE_PAIRS_BUTTON")){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConversionValueDialog.promptToAddConversionValuePair(ObjectTypeConverterPanel.this.getObjectTypeConverter(), ObjectTypeConverterPanel.this.getWorkbenchContext());
                }
            };
        }

        private PropertyChangeListener buildAddButtonEnabler(final Action action) {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    action.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                }
            };
        }

        private JButton buildEditConversionValueButton() {
            this.editAction = this.buildEditConversionValueAction();
            this.editAction.setEnabled(false);
            return new JButton(this.editAction);
        }

        private Action buildEditConversionValueAction() {
            return new AbstractAction(this.resourceRepository().getString("EDIT_VALUE_PAIRS_BUTTON")){

                public void actionPerformed(ActionEvent actionEvent) {
                    MWObjectTypeConverter.ValuePair valuePair = (MWObjectTypeConverter.ValuePair)ConversionValuesPanel.this.valuePairsTableSelectionModel.getMinSelectedValue();
                    ConversionValueDialog.promptToEditConversionValuePair(valuePair, ObjectTypeConverterPanel.this.getWorkbenchContext());
                }
            };
        }

        private JButton buildRemoveConversionValueButton() {
            this.removeAction = this.buildRemoveConversionValueAction();
            this.removeAction.setEnabled(false);
            return new JButton(this.removeAction);
        }

        private Action buildRemoveConversionValueAction() {
            return new AbstractAction(this.resourceRepository().getString("REMOVE_VALUE_PAIRS_BUTTON")){

                public void actionPerformed(ActionEvent actionEvent) {
                    Iterator iterator = CollectionTools.iterator((Object[])ConversionValuesPanel.this.valuePairsTableSelectionModel.getSelectedValues());
                    while (iterator.hasNext()) {
                        MWObjectTypeConverter.ValuePair valuePair = (MWObjectTypeConverter.ValuePair)iterator.next();
                        ObjectTypeConverterPanel.this.getObjectTypeConverter().removeValuePair(valuePair);
                    }
                }
            };
        }

        private JTable buildValuePairsTable() {
            CollectionValueModel collectionValueModel = this.buildValuePairsHolder();
            JTable jTable = SwingComponentFactory.buildTable(this.buildValuePairsTableModel(collectionValueModel), this.buildValuePairsSelectionModel(collectionValueModel));
            this.addPropertyChangeListener("enabled", this.buildTableEnabler(jTable));
            return jTable;
        }

        private TableModel buildValuePairsTableModel(CollectionValueModel collectionValueModel) {
            return new TableModelAdapter(collectionValueModel, this.buildValuePairsColumnModelAdapter());
        }

        private CollectionValueModel buildValuePairsHolder() {
            return new CollectionAspectAdapter(this.getSubjectHolder(), "valuePairs"){

                protected Iterator getValueFromSubject() {
                    return ((MWObjectTypeConverter)this.subject).valuePairs();
                }

                protected int sizeFromSubject() {
                    return ((MWObjectTypeConverter)this.subject).valuePairsSize();
                }
            };
        }

        private ColumnAdapter buildValuePairsColumnModelAdapter() {
            return new ValuePairsColumnAdapter(this.resourceRepository());
        }

        private ListSelectionModel buildValuePairsSelectionModel(CollectionValueModel collectionValueModel) {
            this.valuePairsTableSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(collectionValueModel));
            this.valuePairsTableSelectionModel.addListSelectionListener(this.buildValuePairsListSelectionListener(this.valuePairsTableSelectionModel));
            return this.valuePairsTableSelectionModel;
        }

        private ListSelectionListener buildValuePairsListSelectionListener(final ListSelectionModel listSelectionModel) {
            return new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        ConversionValuesPanel.this.updateValuePairsActions(listSelectionModel);
                    }
                }
            };
        }

        void updateValuePairsActions(ListSelectionModel listSelectionModel) {
            this.removeAction.setEnabled(!listSelectionModel.isSelectionEmpty());
            this.editAction.setEnabled(!listSelectionModel.isSelectionEmpty() && listSelectionModel.getMinSelectionIndex() == listSelectionModel.getMaxSelectionIndex());
        }

        private PropertyChangeListener buildTableEnabler(final JTable jTable) {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jTable.setEnabled((Boolean)propertyChangeEvent.getNewValue());
                }
            };
        }
    }
}

