/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledBorder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

public final class TransformerEditingPanel
extends AbstractPanel {
    private TransformerSpec transformerSpec;

    public TransformerEditingPanel(TransformerSpec transformerSpec, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.transformerSpec = transformerSpec;
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JRadioButton jRadioButton = this.buildMethodButton();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jRadioButton, gridBagConstraints);
        JPanel jPanel = this.buildMethodChooserPanel();
        jPanel.setBorder(new AccessibleTitledBorder(jRadioButton.getText()));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, SwingTools.checkBoxIconWidth(), 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        JRadioButton jRadioButton2 = this.buildClassButton();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)jRadioButton2, gridBagConstraints);
        JPanel jPanel2 = this.buildClassChooserPanel();
        jPanel2.setBorder(new AccessibleTitledBorder(jRadioButton2.getText()));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, SwingTools.checkBoxIconWidth(), 0, 0);
        this.add((Component)jPanel2, gridBagConstraints);
    }

    private JRadioButton buildMethodButton() {
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setModel(this.buildMethodButtonModel());
        jRadioButton.setText(this.resourceRepository().getString("TRANSFORMER_PANEL_METHOD_BUTTON"));
        jRadioButton.setMnemonic(this.resourceRepository().getMnemonic("TRANSFORMER_PANEL_METHOD_BUTTON"));
        return jRadioButton;
    }

    private ButtonModel buildMethodButtonModel() {
        return new RadioButtonModelAdapter(this.transformerSpec.transformerTypeHolder(), "transformationMethod");
    }

    private JPanel buildMethodChooserPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        JLabel jLabel = this.buildMethodChooserLabel();
        jPanel.add((Component)jLabel, "Before");
        this.addAlignLeft(jLabel);
        ListChooser listChooser = this.buildMethodChooser();
        jLabel.setLabelFor(listChooser);
        jPanel.add((Component)listChooser, "Center");
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, "After");
        this.addAlignRight(spacer);
        return jPanel;
    }

    private JLabel buildMethodChooserLabel() {
        JLabel jLabel = this.buildLabel("TRANSFORMER_PANEL_METHOD_CHOOSER");
        this.transformerSpec.transformerTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(jLabel, "transformationMethod"));
        jLabel.setEnabled(this.transformerSpec.transformerTypeHolder().getValue() == "transformationMethod");
        return jLabel;
    }

    private ListChooser buildMethodChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildMethodChooserModel(), this.getWorkbenchContextHolder(), this.buildMethodChooserDialogBuilder());
        defaultListChooser.setRenderer(this.buildMethodRenderer());
        this.transformerSpec.transformerTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(defaultListChooser, "transformationMethod"));
        defaultListChooser.setEnabled(this.transformerSpec.transformerTypeHolder().getValue() == "transformationMethod");
        return defaultListChooser;
    }

    private DefaultListChooserDialog.Builder buildMethodChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setStringConverter(this.buildMWMethodStringConverter());
        return builder;
    }

    private StringConverter buildMWMethodStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWMethod)object).shortSignatureWithReturnType();
            }
        };
    }

    private ComboBoxModel buildMethodChooserModel() {
        return new ComboBoxModelAdapter(this.buildMethodChoicesValue(), this.transformerSpec.transformationMethodHolder());
    }

    private ListValueModel buildMethodChoicesValue() {
        return new SortedListValueModelAdapter(new ReadOnlyCollectionValueModel(CollectionTools.collection((Iterator)this.transformerSpec.candidateTransformationMethods())));
    }

    private ListCellRenderer buildMethodRenderer() {
        return new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository()){

            protected Icon buildNonNullValueIcon(Object object) {
                return null;
            }
        });
    }

    private JRadioButton buildClassButton() {
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setModel(this.buildClassButtonModel());
        jRadioButton.setText(this.resourceRepository().getString("TRANSFORMER_PANEL_CLASS_BUTTON"));
        jRadioButton.setMnemonic(this.resourceRepository().getMnemonic("TRANSFORMER_PANEL_CLASS_BUTTON"));
        return jRadioButton;
    }

    private ButtonModel buildClassButtonModel() {
        return new RadioButtonModelAdapter(this.transformerSpec.transformerTypeHolder(), "transformerClass");
    }

    private JPanel buildClassChooserPanel() {
        AccessibleTitledPanel accessibleTitledPanel = new AccessibleTitledPanel(new BorderLayout(5, 0));
        JLabel jLabel = this.buildClassChooserLabel();
        accessibleTitledPanel.add((Component)jLabel, "Before");
        this.addAlignLeft(jLabel);
        ClassChooserPanel classChooserPanel = this.buildClassChooserPanel2(jLabel);
        accessibleTitledPanel.add((Component)classChooserPanel, "Center");
        this.addPaneForAlignment(classChooserPanel);
        return accessibleTitledPanel;
    }

    private JLabel buildClassChooserLabel() {
        JLabel jLabel = new JLabel(this.resourceRepository().getString("TRANSFORMER_PANEL_CLASS_CHOOSER"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("TRANSFORMER_PANEL_CLASS_CHOOSER"));
        this.transformerSpec.transformerTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(jLabel, "transformerClass"));
        jLabel.setEnabled(this.transformerSpec.transformerTypeHolder().getValue() == "transformerClass");
        return jLabel;
    }

    private ClassChooserPanel buildClassChooserPanel2(JLabel jLabel) {
        ClassChooserPanel classChooserPanel = ClassChooserTools.buildPanel(this.transformerSpec.transformerClassHolder(), this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableNonVoidFilter(), jLabel, this.getWorkbenchContextHolder());
        this.transformerSpec.transformerTypeHolder().addPropertyChangeListener("value", this.buildComponentEnablingListener(classChooserPanel, "transformerClass"));
        classChooserPanel.setEnabled(this.transformerSpec.transformerTypeHolder().getValue() == "transformerClass");
        return classChooserPanel;
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            public MWClassRepository getClassRepository() {
                return TransformerEditingPanel.this.transformerSpec.classRepository();
            }
        };
    }

    private PropertyChangeListener buildComponentEnablingListener(final Component component, final String string) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                component.setEnabled(propertyChangeEvent.getNewValue() == string);
            }
        };
    }

    public static interface TransformerSpec {
        public static final String TRANSFORMATION_METHOD = "transformationMethod";
        public static final String TRANSFORMER_CLASS = "transformerClass";
        public static final String NULL_TRANSFORMER = "nullTransformer";

        public PropertyValueModel transformerTypeHolder();

        public String transformerType();

        public PropertyValueModel transformationMethodHolder();

        public MWMethod transformationMethod();

        public Iterator candidateTransformationMethods();

        public boolean transformationMethodIsValid();

        public PropertyValueModel transformerClassHolder();

        public MWClass transformerClass();

        public MWClassRepository classRepository();
    }
}

