/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta;

import java.awt.Dialog;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.UiMetaBundle;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class ExternalClassLoadFailuresDialog
extends StatusDialog {
    public ExternalClassLoadFailuresDialog(WorkbenchContext workbenchContext, ExternalClassLoadFailureContainer externalClassLoadFailureContainer) {
        super(workbenchContext.buildExpandedResourceRepositoryContext(UiMetaBundle.class), ExternalClassLoadFailuresDialog.buildStatus(externalClassLoadFailureContainer), "ERROR_IMPORTING_CLASSES.TITLE", "CLASSES_COMPILED_AND_ON_CLASSPATH_ERROR_MESSAGE", "dialog.classesNotFound");
    }

    public ExternalClassLoadFailuresDialog(WorkbenchContext workbenchContext, Dialog dialog, ExternalClassLoadFailureContainer externalClassLoadFailureContainer) {
        super(workbenchContext.buildExpandedResourceRepositoryContext(UiMetaBundle.class), dialog, ExternalClassLoadFailuresDialog.buildStatus(externalClassLoadFailureContainer), "ERROR_IMPORTING_CLASSES.TITLE", "CLASSES_COMPILED_AND_ON_CLASSPATH_ERROR_MESSAGE", "dialog.classesNotFound");
    }

    private static Collection buildStatus(ExternalClassLoadFailureContainer externalClassLoadFailureContainer) {
        SortedSet sortedSet = CollectionTools.sortedSet((Iterator)externalClassLoadFailureContainer.failureClassNames());
        Vector<StatusDialog.Status> vector = new Vector<StatusDialog.Status>(sortedSet.size());
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            Vector<Error> vector2 = new Vector<Error>();
            String string = (String)iterator.next();
            Throwable throwable = externalClassLoadFailureContainer.failureForClassNamed(string);
            vector2.add(new Error(throwable));
            while (throwable.getCause() != null) {
                if ((throwable = throwable.getCause()) instanceof NullPointerException || throwable.getLocalizedMessage() == null) continue;
                vector2.add(new Error(throwable));
            }
            StatusDialog.Status status = StatusDialog.createStatus((Object)string, vector2);
            vector.add(status);
        }
        return vector;
    }

    protected CellRendererAdapter buildNodeRenderer(Object object) {
        if (object instanceof String) {
            return new ClassNameCellRendererAdapter();
        }
        if (object instanceof Error) {
            return new ErrorCellRendererAdapter();
        }
        return super.buildNodeRenderer(object);
    }

    private class ErrorCellRendererAdapter
    extends AbstractCellRendererAdapter {
        private ErrorCellRendererAdapter() {
        }

        public Icon buildIcon(Object object) {
            return ExternalClassLoadFailuresDialog.this.resourceRepository().getIcon("error");
        }

        public String buildText(Object object) {
            return ((Error)object).getErrorMessage(ExternalClassLoadFailuresDialog.this.resourceRepository());
        }
    }

    private static class Error {
        private final Throwable error;
        private String errorMessage;

        Error(Throwable throwable) {
            this.error = throwable;
        }

        private String buildErrorMessage(StringRepository stringRepository) {
            if (this.error instanceof ExternalClassNotFoundException) {
                return stringRepository.getString("ERROR_IMPORTING_CLASSES_ERROR_MESSAGE_CLASS_NOT_FOUND");
            }
            if (this.error instanceof InterfaceDescriptorCreationException) {
                return stringRepository.getString("ERROR_IMPORTING_CLASSES_ERROR_MESSAGE_INTERFACE");
            }
            if (this.error instanceof IOException) {
                return stringRepository.getString("ERROR_IMPORTING_CLASSES_ERROR_MESSAGE_IO", this.error.getLocalizedMessage());
            }
            if (this.error.getLocalizedMessage() != null) {
                return this.error.getLocalizedMessage();
            }
            return this.error.toString();
        }

        public String getErrorMessage(StringRepository stringRepository) {
            if (this.errorMessage == null) {
                this.errorMessage = this.buildErrorMessage(stringRepository);
            }
            return this.errorMessage;
        }
    }

    protected class ClassNameCellRendererAdapter
    extends AbstractCellRendererAdapter {
        protected ClassNameCellRendererAdapter() {
        }

        public Icon buildIcon(Object object) {
            return ExternalClassLoadFailuresDialog.this.resourceRepository().getIcon("class.public");
        }

        public String buildText(Object object) {
            String string = (String)object;
            if (string.indexOf(".") == -1) {
                return string + " " + ExternalClassLoadFailuresDialog.this.resourceRepository().getString("DEFAULT_PACKAGE");
            }
            return ClassTools.shortNameForClassNamed((String)string) + " (" + ClassTools.packageNameForClassNamed((String)string) + ")";
        }
    }
}

