/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.DefaultWorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class QueryParameterDialog
extends AbstractValidatingDialog {
    private JTextField parameterNameField;
    private PropertyValueModel parameterNameHolder;
    private PropertyValueModel parameterTypeHolder;
    private MWQuery query;

    public QueryParameterDialog(MWQuery mWQuery, MWClass mWClass, String string, AbstractDialog abstractDialog, WorkbenchContext workbenchContext, String string2) {
        super(workbenchContext, string2, abstractDialog);
        this.query = mWQuery;
        this.parameterTypeHolder = new SimplePropertyValueModel(mWClass);
        this.parameterNameHolder = new SimplePropertyValueModel(string);
    }

    public QueryParameterDialog(MWQuery mWQuery, MWClass mWClass, String string, WorkbenchContext workbenchContext, String string2) {
        super(workbenchContext, string2);
        this.query = mWQuery;
        this.parameterTypeHolder = new SimplePropertyValueModel(mWClass);
        this.parameterNameHolder = new SimplePropertyValueModel(string);
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            public MWClassRepository getClassRepository() {
                return QueryParameterDialog.this.query.getRepository();
            }
        };
    }

    protected Component buildMainPanel() {
        return new MainPanel((WorkbenchContextHolder)new DefaultWorkbenchContextHolder(this.getWorkbenchContext()));
    }

    private Document buildParameterNameDocumentAdapter() {
        DocumentAdapter documentAdapter = new DocumentAdapter(this.parameterNameHolder);
        documentAdapter.addDocumentListener(this.buildParameterNameDocumentListener());
        return documentAdapter;
    }

    private DocumentListener buildParameterNameDocumentListener() {
        return new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                if (QueryParameterDialog.this.isVisible()) {
                    QueryParameterDialog.this.updateDialogState();
                }
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                if (QueryParameterDialog.this.isVisible()) {
                    QueryParameterDialog.this.updateDialogState();
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (QueryParameterDialog.this.isVisible()) {
                    QueryParameterDialog.this.updateDialogState();
                }
            }
        };
    }

    public String getParameterName() {
        return (String)this.parameterNameHolder.getValue();
    }

    public MWClass getParameterType() {
        return (MWClass)this.parameterTypeHolder.getValue();
    }

    private String getPotentialParameterName() {
        return this.parameterNameField.getText();
    }

    protected String helpTopicId() {
        return "descriptor.queryManager.general.parameters.addParameter";
    }

    protected Component initialFocusComponent() {
        return this.parameterNameField;
    }

    private void updateDialogState() {
        String string = this.getPotentialParameterName();
        String string2 = null;
        if (StringTools.stringIsEmpty((String)string)) {
            string2 = this.resourceRepository().getString("QUERY_PARAMETER_DIALOG_NO_PARAMETER_NAME_SPECIFIED");
        } else if (CollectionTools.contains((Iterator)this.query.parameterNames(), (Object)string)) {
            string2 = this.resourceRepository().getString("QUERY_PARAMETER_DIALOG_CLASS_ALREADY_EXISTS", string);
        }
        this.setErrorMessage(string2);
        this.getOKAction().setEnabled(string2 == null);
    }

    private class MainPanel
    extends AbstractPanel {
        MainPanel(WorkbenchContextHolder workbenchContextHolder) {
            super(workbenchContextHolder);
            this.initializeLayout();
        }

        private void initializeLayout() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = SwingComponentFactory.buildLabel("QUERY_PARAMETER_DIALOG.PARAMETER_TYPE_LABEL", this.resourceRepository());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)jLabel, gridBagConstraints);
            ClassChooserPanel classChooserPanel = ClassChooserTools.buildPanel(QueryParameterDialog.this.parameterTypeHolder, QueryParameterDialog.this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableNonVoidFilter(), jLabel, new DefaultWorkbenchContextHolder(this.getWorkbenchContext()));
            this.helpManager().addTopicID(classChooserPanel, QueryParameterDialog.this.helpTopicId() + ".type");
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            this.add((Component)classChooserPanel, gridBagConstraints);
            this.addPaneForAlignment(classChooserPanel);
            JLabel jLabel2 = SwingComponentFactory.buildLabel("QUERY_PARAMETER_DIALOG.PARAMETER_NAME_LABEL", this.resourceRepository());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            this.add((Component)jLabel2, gridBagConstraints);
            QueryParameterDialog.this.parameterNameField = new JTextField(QueryParameterDialog.this.buildParameterNameDocumentAdapter(), null, 1);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            this.add((Component)QueryParameterDialog.this.parameterNameField, gridBagConstraints);
            jLabel2.setLabelFor(QueryParameterDialog.this.parameterNameField);
            Spacer spacer = new Spacer();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            this.add((Component)spacer, gridBagConstraints);
            this.addAlignRight(spacer);
        }
    }
}

