/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ListIterator;
import javax.swing.tree.DefaultTreeModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBasicExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCompoundExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWExpression;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.BasicExpressionTreeNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ExpressionTreeNode;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;

final class CompoundExpressionTreeNode
extends ExpressionTreeNode
implements ListChangeListener,
PropertyChangeListener {
    CompoundExpressionTreeNode(MWCompoundExpression mWCompoundExpression) {
        this(mWCompoundExpression, null);
    }

    CompoundExpressionTreeNode(MWCompoundExpression mWCompoundExpression, DefaultTreeModel defaultTreeModel) {
        super((MWExpression)mWCompoundExpression, true, defaultTreeModel);
    }

    MWCompoundExpression getCompoundExpression() {
        return (MWCompoundExpression)this.getUserObject();
    }

    private ExpressionTreeNode addNodeForExpression(MWExpression mWExpression) {
        ExpressionTreeNode expressionTreeNode = MWBasicExpression.class.isAssignableFrom(mWExpression.getClass()) ? new BasicExpressionTreeNode((MWBasicExpression)mWExpression, this.getModel()) : new CompoundExpressionTreeNode((MWCompoundExpression)mWExpression, this.getModel());
        this.getModel().insertNodeInto(expressionTreeNode, this, this.getChildCount());
        return expressionTreeNode;
    }

    public void initializeChildren() {
        ListIterator listIterator = this.getCompoundExpression().expressions();
        while (listIterator.hasNext()) {
            MWExpression mWExpression = (MWExpression)listIterator.next();
            ExpressionTreeNode expressionTreeNode = this.addNodeForExpression(mWExpression);
            expressionTreeNode.initializeChildren();
        }
    }

    protected void engageListeners() {
        this.getCompoundExpression().addListChangeListener((ListChangeListener)this);
        this.getCompoundExpression().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void itemsReplaced(ListChangeEvent listChangeEvent) {
    }

    public void itemsAdded(ListChangeEvent listChangeEvent) {
        ListIterator listIterator = listChangeEvent.items();
        while (listIterator.hasNext()) {
            this.addNodeForExpression((MWExpression)listIterator.next());
        }
    }

    public void itemsRemoved(ListChangeEvent listChangeEvent) {
        ExpressionTreeNode expressionTreeNode = (ExpressionTreeNode)this.getChildAt(listChangeEvent.getIndex());
        expressionTreeNode.disengageListeners();
        this.getModel().removeNodeFromParent(expressionTreeNode);
    }

    public void listChanged(ListChangeEvent listChangeEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "operatorType") {
            this.getModel().nodeChanged(this);
        }
    }

    protected void disengageListeners() {
        this.getCompoundExpression().removeListChangeListener((ListChangeListener)this);
        this.getCompoundExpression().removePropertyChangeListener((PropertyChangeListener)this);
        while (this.getChildCount() > 0) {
            ExpressionTreeNode expressionTreeNode = (ExpressionTreeNode)this.getFirstChild();
            expressionTreeNode.disengageListeners();
            this.getModel().removeNodeFromParent(expressionTreeNode);
        }
        this.setUserObject(null);
    }
}

