/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.event.MouseEvent;
import java.util.ListIterator;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveTablePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.DoubleClickMouseListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderableQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AbstractAttributeItemsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.OrderingAttributeDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.ComboBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.BidiTransformer;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

class OrderingAttributesPanel
extends AbstractAttributeItemsPanel {
    private Filter traversableFilter;
    private Filter chooseableFilter;

    public OrderingAttributesPanel(PropertyValueModel propertyValueModel, Filter filter, Filter filter2, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
        this.traversableFilter = filter;
        this.chooseableFilter = filter2;
    }

    protected PropertyValueModel buildQueryHolder(PropertyValueModel propertyValueModel) {
        return new FilteringPropertyValueModel(propertyValueModel){

            protected boolean accept(Object object) {
                return object instanceof MWOrderableQuery;
            }
        };
    }

    protected String helpTopicId() {
        return "query.orderingAttributes";
    }

    String listTitleKey() {
        return "ORDERING_ATTRIBUTES_LIST";
    }

    protected AddRemovePanel buildAddRemovePanel() {
        final AddRemoveTablePanel addRemoveTablePanel = new AddRemoveTablePanel(this.getApplicationContext(), (AddRemovePanel.Adapter)this.buildAttributesPanelAdapter(), this.buildAttributesHolder(), (ColumnAdapter)new OrderingAttributesColumnAdapter(this.resourceRepository()), 3);
        addRemoveTablePanel.setBorder(this.buildTitledBorder(this.listTitleKey()));
        SwingComponentFactory.addDoubleClickMouseListener(addRemoveTablePanel.getComponent(), new DoubleClickMouseListener(){

            public void mouseDoubleClicked(MouseEvent mouseEvent) {
                OrderingAttributesPanel.this.editSelectedAttribute((MWAttributeItem)addRemoveTablePanel.getSelectionModel().getSelectedValue());
            }
        });
        this.addHelpTopicId(addRemoveTablePanel, this.helpTopicId());
        this.updateTableColumns((JTable)addRemoveTablePanel.getComponent());
        return addRemoveTablePanel;
    }

    protected boolean panelEnabled(MWQueryFormat mWQueryFormat) {
        return mWQueryFormat.orderingAttributesAllowed();
    }

    private void updateTableColumns(JTable jTable) {
        int n = 0;
        TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
        ComboBoxTableCellRenderer comboBoxTableCellRenderer = this.buildOrderingComboBoxRenderer();
        tableColumn.setCellRenderer(comboBoxTableCellRenderer);
        tableColumn.setCellEditor(new TableCellEditorAdapter(this.buildOrderingComboBoxRenderer()));
        n = Math.max(n, comboBoxTableCellRenderer.getPreferredHeight());
        tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new SimpleTableCellRenderer(){

            protected String buildText(Object object) {
                if (object != null) {
                    return ((MWQueryableArgument)object).displayString();
                }
                return "";
            }
        });
        jTable.setRowHeight(n);
    }

    private ComboBoxModel buildOrderingComboBoxModel() {
        return new DefaultComboBoxModel<Object>(new Object[]{this.resourceRepository().getString("ASCENDING_CHOICE"), this.resourceRepository().getString("DESCENDING_CHOICE")});
    }

    private ComboBoxTableCellRenderer buildOrderingComboBoxRenderer() {
        return new ComboBoxTableCellRenderer(this.buildOrderingComboBoxModel());
    }

    AddRemovePanel.UpDownOptionAdapter buildAttributesPanelAdapter() {
        return new AddRemovePanel.UpDownOptionAdapter(){

            public String optionalButtonKey() {
                return "ORDERING_ATTRIBUTES_LIST_EDIT_BUTTON";
            }

            public void optionOnSelection(ObjectListSelectionModel objectListSelectionModel) {
                OrderingAttributesPanel.this.editSelectedAttribute((MWAttributeItem)objectListSelectionModel.getSelectedValue());
            }

            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel objectListSelectionModel) {
                return objectListSelectionModel.getSelectedValuesSize() == 1;
            }

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                OrderingAttributesPanel.this.addOrderingItem();
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                Object[] objectArray = objectListSelectionModel.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWOrderableQuery)OrderingAttributesPanel.this.getQuery()).removeOrderingItem((Ordering)objectArray[i]);
                }
            }

            public void moveItemsDown(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWOrderableQuery)OrderingAttributesPanel.this.getQuery()).moveOrderingItemDown((Ordering)objectArray[i]);
                }
            }

            public void moveItemsUp(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWOrderableQuery)OrderingAttributesPanel.this.getQuery()).moveOrderingItemUp((Ordering)objectArray[i]);
                }
            }
        };
    }

    protected ListValueModel buildAttributesHolder() {
        return new ListAspectAdapter(this.getQueryHolder(), "orderingItems"){

            protected ListIterator getValueFromSubject() {
                return ((MWOrderableQuery)this.subject).orderingItems();
            }

            protected int sizeFromSubject() {
                return ((MWOrderableQuery)this.subject).orderingItemsSize();
            }
        };
    }

    private void addOrderingItem() {
        this.editSelectedAttribute(null);
    }

    AttributeItemDialog buildAttributeItemDialog(MWAttributeItem mWAttributeItem) {
        return new OrderingAttributeDialog((MWOrderableQuery)this.getQuery(), (Ordering)mWAttributeItem, this.traversableFilter, this.chooseableFilter, this.getWorkbenchContext());
    }

    protected Filter getTraversableFilter() {
        return this.traversableFilter;
    }

    protected Filter getChooseableFilter() {
        return this.chooseableFilter;
    }

    private static class OrderingAttributesColumnAdapter
    implements ColumnAdapter {
        ResourceRepository resourceRepository;
        public static final int ATTRIBUTE_COLUMN = 0;
        public static final int ORDER_COLUMN = 1;
        public static final int COLUMN_COUNT = 2;
        private final String[] COLUMN_NAME_KEYS = new String[]{"ATTRIBUTE_COLUMN_HEADER", "ORDER_COLUMN_HEADER"};
        private static final String[] EMPTY_STRING_ARRAY = new String[0];

        private OrderingAttributesColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        private PropertyValueModel buildAttributeAdapter(MWAttributeItem mWAttributeItem) {
            return new PropertyAspectAdapter(EMPTY_STRING_ARRAY, (Model)mWAttributeItem){

                protected Object getValueFromSubject() {
                    return ((MWAttributeItem)this.subject).getQueryableArgument();
                }
            };
        }

        private PropertyValueModel buildOrderAdapter(Ordering ordering) {
            return new TransformationPropertyValueModel(new PropertyAspectAdapter("ascending", (Model)ordering){

                protected Object getValueFromSubject() {
                    return ((Ordering)this.subject).isAscending();
                }

                protected void setValueOnSubject(Object object) {
                    ((Ordering)this.subject).setAscending(((Boolean)object).booleanValue());
                }
            }, new BidiTransformer(){

                public Object reverseTransform(Object object) {
                    if (object != null && ((String)object).equals(OrderingAttributesColumnAdapter.this.resourceRepository.getString("ASCENDING_BUTTON"))) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }

                public Object transform(Object object) {
                    if (((Boolean)object).equals(Boolean.TRUE)) {
                        return OrderingAttributesColumnAdapter.this.resourceRepository.getString("ASCENDING_BUTTON");
                    }
                    return OrderingAttributesColumnAdapter.this.resourceRepository.getString("DESCENDING_BUTTON");
                }
            });
        }

        public PropertyValueModel[] cellModels(Object object) {
            Ordering ordering = (Ordering)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildAttributeAdapter((MWAttributeItem)ordering), this.buildOrderAdapter(ordering)};
            return propertyValueModelArray;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(this.COLUMN_NAME_KEYS[n]);
        }

        public boolean isColumnEditable(int n) {
            return n == 1;
        }
    }
}

