/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgument;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ArgumentPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableEditDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

final class QueryableArgumentPanel
extends ArgumentPanel {
    private JTextField queryKeyTextField;
    private JButton editQueryKeyButton;

    QueryableArgumentPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder, Collection collection) {
        super(propertyValueModel, workbenchContextHolder);
        this.initialize(collection);
    }

    protected MWQueryableArgument getQueryableArgument() {
        return (MWQueryableArgument)this.getArgument();
    }

    private void initialize(Collection collection) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.queryKeyTextField = this.buildQueryableTextField();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.queryKeyTextField, gridBagConstraints);
        this.editQueryKeyButton = new JButton(this.resourceRepository().getString("QUERY_KEY_EDIT_BUTTON_ON_SECOND_ARGUMENT_PANEL"));
        this.editQueryKeyButton.setMnemonic(this.resourceRepository().getMnemonic("QUERY_KEY_EDIT_BUTTON_ON_SECOND_ARGUMENT_PANEL"));
        this.editQueryKeyButton.addActionListener(this.buildEditQueryKeyAction());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.editQueryKeyButton, gridBagConstraints);
        collection.add(this.editQueryKeyButton);
    }

    private JTextField buildQueryableTextField() {
        JTextField jTextField = new JTextField();
        jTextField.setDocument(new DocumentAdapter(this.buildQueryableHolder()));
        jTextField.setEditable(false);
        return jTextField;
    }

    private PropertyValueModel buildQueryableHolder() {
        return new PropertyAspectAdapter(this.getArgumentHolder(), "queryableArgumentElement"){

            protected Object getValueFromSubject() {
                return ((MWQueryableArgument)this.subject).displayString();
            }
        };
    }

    protected PropertyValueModel buildQueryArgumentHolder(PropertyValueModel propertyValueModel) {
        return new FilteringPropertyValueModel(propertyValueModel){

            protected boolean accept(Object object) {
                return object instanceof MWQueryableArgument;
            }
        };
    }

    private ActionListener buildEditQueryKeyAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QueryableArgumentPanel.this.editQueryKey();
            }
        };
    }

    private void editQueryKey() {
        QueryableEditDialog queryableEditDialog = new QueryableEditDialog(this.getQueryableArgument(), this.getWorkbenchContext());
        queryableEditDialog.show();
    }
}

