/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQueryManager;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public final class RelationalCustomSqlPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel queryManagerHolder;

    public RelationalCustomSqlPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.queryManagerHolder = this.buildQueryManagerHolder();
    }

    private PropertyValueModel buildQueryManagerHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).getQueryManager();
            }
        };
    }

    protected String helpTopicId() {
        return "descriptor.queryManager.customSQL";
    }

    protected Component buildPage() {
        this.setName("Queries");
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTabbedPane jTabbedPane = new JTabbedPane();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jTabbedPane, gridBagConstraints);
        JTextArea jTextArea = this.buildInsertSqlTextArea();
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), jScrollPane.getBorder()));
        this.addHelpTopicId(jScrollPane, this.helpTopicId() + ".insert");
        jTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_SQL_INSERT_TAB"), jScrollPane);
        JTextArea jTextArea2 = this.buildUpdateSqlTextArea();
        JScrollPane jScrollPane2 = new JScrollPane(jTextArea2);
        jScrollPane2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), jScrollPane2.getBorder()));
        this.addHelpTopicId(jScrollPane2, this.helpTopicId() + ".update");
        jTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_SQL_UPDATE_TAB"), jScrollPane2);
        JTextArea jTextArea3 = this.buildDeleteSqlTextArea();
        JScrollPane jScrollPane3 = new JScrollPane(jTextArea3);
        jScrollPane3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), jScrollPane3.getBorder()));
        this.addHelpTopicId(jScrollPane3, this.helpTopicId() + ".delete");
        jTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_SQL_DELETE_TAB"), jScrollPane3);
        JTextArea jTextArea4 = this.buildReadObjectSqlTextArea();
        JScrollPane jScrollPane4 = new JScrollPane(jTextArea4);
        jScrollPane4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), jScrollPane4.getBorder()));
        this.addHelpTopicId(jScrollPane4, this.helpTopicId() + ".readObject");
        jTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_SQL_READ_OBJECT_TAB"), jScrollPane4);
        JTextArea jTextArea5 = this.buildReadAllSqlTextArea();
        JScrollPane jScrollPane5 = new JScrollPane(jTextArea5);
        jScrollPane5.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), jScrollPane5.getBorder()));
        this.addHelpTopicId(jScrollPane5, this.helpTopicId() + ".readAll");
        jTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_SQL_READ_ALL_TAB"), jScrollPane5);
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    private JTextArea buildTextArea(PropertyValueModel propertyValueModel) {
        JTextArea jTextArea = new JTextArea(new DocumentAdapter(propertyValueModel));
        jTextArea.setFont(new Font("dialog", 0, 12));
        return jTextArea;
    }

    private JTextArea buildInsertSqlTextArea() {
        return this.buildTextArea(this.buildInsertSqlHolder());
    }

    private PropertyValueModel buildInsertSqlHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "insertSQLString"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getInsertSQLString();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalQueryManager)this.subject).setInsertSQLString((String)object);
            }
        };
    }

    private JTextArea buildUpdateSqlTextArea() {
        return this.buildTextArea(this.buildUpdateSqlHolder());
    }

    private PropertyValueModel buildUpdateSqlHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "updateSQLString"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getUpdateSQLString();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalQueryManager)this.subject).setUpdateSQLString((String)object);
            }
        };
    }

    private JTextArea buildDeleteSqlTextArea() {
        return this.buildTextArea(this.buildDeleteSqlHolder());
    }

    private PropertyValueModel buildDeleteSqlHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "deleteSQLString"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getDeleteSQLString();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalQueryManager)this.subject).setDeleteSQLString((String)object);
            }
        };
    }

    private JTextArea buildReadObjectSqlTextArea() {
        return this.buildTextArea(this.buildReadObjectSqlHolder());
    }

    private PropertyValueModel buildReadObjectSqlHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "readObjectSQLString"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getReadObjectSQLString();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalQueryManager)this.subject).setReadObjectSQLString((String)object);
            }
        };
    }

    private JTextArea buildReadAllSqlTextArea() {
        return this.buildTextArea(this.buildReadAllSqlHolder());
    }

    private PropertyValueModel buildReadAllSqlHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "readAllSQLString"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getReadAllSQLString();
            }

            protected void setValueOnSubject(Object object) {
                ((MWRelationalQueryManager)this.subject).setReadAllSQLString((String)object);
            }
        };
    }
}

