/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.framework.context.DefaultWorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.WaitDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchemaRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.EditableSchemaPropertiesPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaDialogUtilities;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

class ImportSchemaDialog
extends AbstractValidatingDialog {
    private EditableSchemaPropertiesPanel schemaPanel;
    MWXmlSchemaRepository schemaRepository;
    MWXmlSchema importedSchema;

    ImportSchemaDialog(WorkbenchContext workbenchContext, MWXmlSchemaRepository mWXmlSchemaRepository) {
        super(workbenchContext);
        this.schemaRepository = mWXmlSchemaRepository;
    }

    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("IMPORT_SCHEMA_DIALOG.TITLE"));
        this.setSize(550, 325);
        this.getOKAction().setEnabled(false);
    }

    protected Component buildMainPanel() {
        this.schemaPanel = this.buildSchemaPanel();
        return this.schemaPanel;
    }

    private EditableSchemaPropertiesPanel buildSchemaPanel() {
        EditableSchemaPropertiesPanel editableSchemaPropertiesPanel = new EditableSchemaPropertiesPanel(this.buildSchemaRepositoryHolder(), (WorkbenchContextHolder)new DefaultWorkbenchContextHolder(this.getWorkbenchContext()));
        editableSchemaPropertiesPanel.addPropertyChangeListener("SCHEMA_PROPERTY", this.buildSchemaPropertyChangeListener());
        return editableSchemaPropertiesPanel;
    }

    private PropertyValueModel buildSchemaRepositoryHolder() {
        return new AbstractReadOnlyPropertyValueModel(){

            public Object getValue() {
                return ImportSchemaDialog.this.schemaRepository;
            }
        };
    }

    private PropertyChangeListener buildSchemaPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImportSchemaDialog.this.updateForErrors();
            }
        };
    }

    protected String helpTopicId() {
        return "dialog.addSchema";
    }

    public MWXmlSchema promptToImportSchema() {
        this.show();
        return this.importedSchema;
    }

    protected void prepareToShow() {
        this.setLocationRelativeTo(this.getParent());
    }

    void updateForErrors() {
        boolean bl;
        boolean bl2 = bl = this.checkSchemaNameOk() && this.checkLoadMechanismOk();
        if (bl) {
            this.setErrorMessage(null);
        }
        this.getOKAction().setEnabled(bl);
    }

    private boolean checkSchemaNameOk() {
        String string = this.schemaPanel.getSchemaName();
        if (StringTools.stringIsEmpty((String)string)) {
            this.setErrorMessage(this.resourceRepository().getString("SCHEMA_NAME_NOT_SPECIFIED_ERROR_MESSAGE"));
            return false;
        }
        if (this.schemaRepository.getSchema(string) != null || this.schemaRepository.containsSchemaIgnoreCase(string)) {
            this.setErrorMessage(this.resourceRepository().getString("SCHEMA_NAME_NOT_UNIQUE_ERROR_MESSAGE"));
            return false;
        }
        return true;
    }

    private boolean checkLoadMechanismOk() {
        return this.checkFileMechanismOk() && this.checkUrlMechanismOk() && this.checkClasspathResourceMechanismOk();
    }

    private boolean checkFileMechanismOk() {
        String string;
        if (this.schemaPanel.isFileMechanism() && ((string = this.schemaPanel.getFileName()) == null || string.equals(""))) {
            this.setErrorMessage(this.resourceRepository().getString("FILE_NOT_SPECIFIED_ERROR_MESSAGE"));
            return false;
        }
        return true;
    }

    private boolean checkUrlMechanismOk() {
        String string;
        if (this.schemaPanel.isUrlMechanism() && ((string = this.schemaPanel.getUrl()) == null || string.equals(""))) {
            this.setErrorMessage(this.resourceRepository().getString("URL_NOT_SPECIFIED_ERROR_MESSAGE"));
            return false;
        }
        return true;
    }

    private boolean checkClasspathResourceMechanismOk() {
        String string;
        if (this.schemaPanel.isClasspathResourceMechanism() && ((string = this.schemaPanel.getClasspathResourceName()) == null || string.equals(""))) {
            this.setErrorMessage(this.resourceRepository().getString("CLASSPATH_RESOURCE_NOT_SPECIFIED_ERROR_MESSAGE"));
            return false;
        }
        return true;
    }

    protected boolean preConfirm() {
        this.startImportationThread();
        return false;
    }

    private void startImportationThread() {
        Thread thread = new Thread((Runnable)new ImportationRunnable(this.buildSchemaCreator()), "XML Schema  Importation");
        thread.setPriority(3);
        thread.start();
    }

    private SchemaCreator buildSchemaCreator() {
        if (this.schemaPanel.isFileMechanism()) {
            return new FileSchemaCreator(this.schemaPanel.getSchemaName(), this.schemaPanel.getFileName());
        }
        if (this.schemaPanel.isUrlMechanism()) {
            return new URLSchemaCreator(this.schemaPanel.getSchemaName(), this.schemaPanel.getUrl());
        }
        if (this.schemaPanel.isClasspathResourceMechanism()) {
            return new ClasspathSchemaCreator(this.schemaPanel.getSchemaName(), this.schemaPanel.getClasspathResourceName());
        }
        throw new IllegalArgumentException();
    }

    void showUrlLoadFailure(String string, ResourceException resourceException) {
        if (this.schemaPanel.isFileMechanism()) {
            SchemaDialogUtilities.showUrlLoadFailure(this, string, resourceException, "FILE_RESOURCE", this.schemaPanel.getFileName());
        } else if (this.schemaPanel.isUrlMechanism()) {
            SchemaDialogUtilities.showUrlLoadFailure(this, string, resourceException, "URL_RESOURCE", this.schemaPanel.getUrl());
        } else if (this.schemaPanel.isClasspathResourceMechanism()) {
            SchemaDialogUtilities.showUrlLoadFailure(this, string, resourceException, "CLASSPATH_RESOURCE", this.schemaPanel.getClasspathResourceName());
        }
        this.getOKAction().setEnabled(false);
    }

    void showSchemaLoadFailure(String string) {
        SchemaDialogUtilities.showSchemaLoadFailure((Component)this, string, null);
        this.getOKAction().setEnabled(false);
    }

    void showSchemaLoadFailure(String string, RuntimeException runtimeException) {
        SchemaDialogUtilities.showSchemaLoadFailure((Component)this, string, runtimeException);
        this.getOKAction().setEnabled(false);
    }

    protected void okConfirmed() {
        super.okConfirmed();
    }

    private class URLSchemaCreator
    extends AbstractSchemaCreator {
        URLSchemaCreator(String string, String string2) {
            super(string, string2);
        }

        public MWXmlSchema createSchema() throws RuntimeException, ResourceException {
            return ImportSchemaDialog.this.schemaRepository.createSchemaFromUrl(this.schemaName, this.fileName);
        }
    }

    private class FileSchemaCreator
    extends AbstractSchemaCreator {
        FileSchemaCreator(String string, String string2) {
            super(string, string2);
        }

        public MWXmlSchema createSchema() throws RuntimeException, ResourceException {
            return ImportSchemaDialog.this.schemaRepository.createSchemaFromFile(this.schemaName, this.fileName);
        }
    }

    private class ClasspathSchemaCreator
    extends AbstractSchemaCreator {
        ClasspathSchemaCreator(String string, String string2) {
            super(string, string2);
        }

        public MWXmlSchema createSchema() throws RuntimeException, ResourceException {
            return ImportSchemaDialog.this.schemaRepository.createSchemaFromClasspath(this.schemaName, this.fileName);
        }
    }

    private abstract class AbstractSchemaCreator
    implements SchemaCreator {
        protected String fileName;
        protected String schemaName;

        AbstractSchemaCreator(String string, String string2) {
            this.fileName = string2;
            this.schemaName = string;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }

    private static interface SchemaCreator {
        public MWXmlSchema createSchema() throws RuntimeException, ResourceException;

        public String getSchemaName();

        public String getFileName();
    }

    private class ImportationRunnable
    implements Runnable {
        WaitDialog waitDialog;
        SchemaCreator schemaCreator;

        ImportationRunnable(SchemaCreator schemaCreator) {
            this.initialize(schemaCreator);
        }

        private void initialize(SchemaCreator schemaCreator) {
            this.schemaCreator = schemaCreator;
            this.waitDialog = new WaitDialog((Dialog)ImportSchemaDialog.this.getWorkbenchContext().getCurrentWindow(), ImportSchemaDialog.this.resourceRepository().getIcon("file.xml.large"), ImportSchemaDialog.this.resourceRepository().getString("IMPORT_SCHEMA_DIALOG.WAIT_DIALOG.TITLE"), ImportSchemaDialog.this.resourceRepository().getString("IMPORT_SCHEMA_DIALOG.WAIT_DIALOG.DESCRIPTION", schemaCreator.getSchemaName()));
        }

        private void showWaitCursor() {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ImportSchemaDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    ImportSchemaDialog.this.getWorkbenchContext().getCurrentWindow().setCursor(Cursor.getPredefinedCursor(3));
                }
            });
        }

        private void hideWaitCursor() {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ImportSchemaDialog.this.setCursor(Cursor.getDefaultCursor());
                    ImportSchemaDialog.this.getWorkbenchContext().getCurrentWindow().setCursor(Cursor.getDefaultCursor());
                }
            });
        }

        private void completeTermination(MWXmlSchema mWXmlSchema) {
            ImportSchemaDialog.this.importedSchema = mWXmlSchema;
            this.disposeImportSchemaDialog();
        }

        private void disposeImportSchemaDialog() {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ImportSchemaDialog.this.okConfirmed();
                }
            });
        }

        public void run() {
            try {
                MWXmlSchema mWXmlSchema = this.importSchema();
                this.completeTermination(mWXmlSchema);
            }
            catch (ResourceException resourceException) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ImportSchemaDialog.this.showUrlLoadFailure(ImportationRunnable.this.schemaCreator.getSchemaName(), resourceException);
                    }
                });
            }
            catch (RuntimeException runtimeException) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ImportSchemaDialog.this.showSchemaLoadFailure(ImportationRunnable.this.schemaCreator.getSchemaName(), runtimeException);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MWXmlSchema importSchema() throws RuntimeException, ResourceException {
            this.showWaitCursor();
            AbstractDialog.launchLater(this.waitDialog);
            try {
                MWXmlSchema mWXmlSchema = this.schemaCreator.createSchema();
                return mWXmlSchema;
            }
            finally {
                this.hideWaitCursor();
                this.waitDialog.dispose();
            }
        }
    }
}

