/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentDetail;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentNodeStructure;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentQNamedDetail;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementListIterator;

abstract class NamedSchemaComponentNodeStructure
extends SchemaComponentNodeStructure {
    private String qName;
    private PropertyChangeListener qNameListener;

    NamedSchemaComponentNodeStructure(MWNamedSchemaComponent mWNamedSchemaComponent) {
        super((MWSchemaComponent)mWNamedSchemaComponent);
        this.initialize(mWNamedSchemaComponent);
    }

    private void initialize(MWNamedSchemaComponent mWNamedSchemaComponent) {
        this.qName = mWNamedSchemaComponent.qName();
        this.qNameListener = this.buildQNameListener();
        mWNamedSchemaComponent.getTargetNamespace().addPropertyChangeListener("namespacePrefix", this.qNameListener);
    }

    private PropertyChangeListener buildQNameListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                NamedSchemaComponentNodeStructure.this.qNameChanged();
            }
        };
    }

    void disengageComponent() {
        ((MWNamedSchemaComponent)this.getComponent()).getTargetNamespace().removePropertyChangeListener("namespacePrefix", this.qNameListener);
        super.disengageComponent();
    }

    private void qNameChanged() {
        String string = this.qName;
        this.qName = ((MWNamedSchemaComponent)this.getComponent()).qName();
        this.firePropertyChanged("displayString", string, this.qName);
    }

    protected ListIterator nameDetails() {
        return new SingleElementListIterator((Object)this.buildNameDetail());
    }

    SchemaComponentDetail buildNameDetail() {
        return new SchemaComponentQNamedDetail(this.getComponent()){

            protected String getName() {
                return "name";
            }

            protected MWNamedSchemaComponent getQNamedComponent() {
                return (MWNamedSchemaComponent)this.component;
            }
        };
    }

    abstract Integer topLevelOrderIndex();

    public String displayString() {
        MWNamedSchemaComponent mWNamedSchemaComponent = (MWNamedSchemaComponent)this.getComponent();
        String string = mWNamedSchemaComponent.isReference() ? "ref" : "name";
        return mWNamedSchemaComponent.componentTypeName() + ": " + string + "=\"" + mWNamedSchemaComponent.qName() + "\"";
    }
}

