/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.TopLevelSchemaComponentNode;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractTreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListCurator;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;

class SchemaNode
extends AbstractTreeNodeValueModel
implements Displayable {
    private ValueModel schemaHolder;
    private ValueModel schemaNameHolder;
    private PropertyChangeListener schemaNameListener;
    private ListValueModel childrenModel;

    SchemaNode(ValueModel valueModel) {
        this.initialize(valueModel);
    }

    private void initialize(ValueModel valueModel) {
        this.schemaHolder = valueModel;
        this.schemaNameHolder = this.buildSchemaNameHolder();
        this.schemaNameListener = this.buildSchemaNamePropertyChangeListener();
        this.childrenModel = this.buildChildrenModel();
    }

    private ValueModel buildSchemaNameHolder() {
        return new PropertyAspectAdapter(this.schemaHolder, "name"){

            protected Object getValueFromSubject() {
                return ((MWXmlSchema)this.subject).getName();
            }
        };
    }

    private PropertyChangeListener buildSchemaNamePropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SchemaNode.this.firePropertyChanged("displayString", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
                SchemaNode.this.fireStateChanged();
            }
        };
    }

    protected ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildComponentNodesAdapter());
    }

    protected ListValueModel buildComponentNodesAdapter() {
        return new TransformationListValueModelAdapter(this.buildStructuralComponentsAdapter()){

            protected Object transformItem(Object object) {
                return SchemaNode.this.buildComponentNode((MWNamedSchemaComponent)object);
            }
        };
    }

    protected SchemaComponentNode buildComponentNode(MWNamedSchemaComponent mWNamedSchemaComponent) {
        return new TopLevelSchemaComponentNode((AbstractTreeNodeValueModel)this, mWNamedSchemaComponent);
    }

    protected ListValueModel buildStructuralComponentsAdapter() {
        return new ListCurator(this.schemaHolder){

            public Iterator getValueForRecord() {
                return ((MWXmlSchema)this.subject).structuralComponents();
            }
        };
    }

    public Object getValue() {
        return this.schemaHolder.getValue();
    }

    public TreeNodeValueModel getParent() {
        return null;
    }

    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    protected void engageValue() {
        this.schemaNameHolder.addPropertyChangeListener("value", this.schemaNameListener);
    }

    protected void disengageValue() {
        this.schemaNameHolder.removePropertyChangeListener("value", this.schemaNameListener);
    }

    public int compareTo(Object object) {
        return DEFAULT_COMPARATOR.compare(this, object);
    }

    public String displayString() {
        String string = this.schema() == null ? "" : this.schema().getName();
        return "schema: " + string;
    }

    public Icon icon() {
        return null;
    }

    private MWXmlSchema schema() {
        return (MWXmlSchema)this.schemaHolder.getValue();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        SchemaNode schemaNode = (SchemaNode)object;
        return this.schemaHolder.equals(schemaNode.schemaHolder);
    }

    public int hashCode() {
        return this.schemaHolder.hashCode();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.schemaHolder);
    }
}

