/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaContextChooserDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaContextComponentDisplayer;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaRepositoryValue;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public final class SchemaContextChooser
extends AbstractPanel {
    private SchemaRepositoryValue schemaRepositoryValue;
    private PropertyValueModel schemaContextComponentHolder;
    private SchemaContextDisplayStringValueModel schemaContextDisplayStringHolder;

    private SchemaContextChooser(WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
    }

    public SchemaContextChooser(WorkbenchContextHolder workbenchContextHolder, SchemaRepositoryValue schemaRepositoryValue, PropertyValueModel propertyValueModel, JLabel jLabel) {
        this(workbenchContextHolder);
        this.initialize(schemaRepositoryValue, propertyValueModel, jLabel);
    }

    private void initialize(SchemaRepositoryValue schemaRepositoryValue, PropertyValueModel propertyValueModel, JLabel jLabel) {
        this.schemaRepositoryValue = schemaRepositoryValue;
        this.schemaContextComponentHolder = propertyValueModel;
        this.schemaContextDisplayStringHolder = this.buildSchemaContextDisplayStringHolder();
        this.initializeLayout(jLabel);
    }

    private SchemaContextDisplayStringValueModel buildSchemaContextDisplayStringHolder() {
        return new SchemaContextDisplayStringValueModel(this.schemaContextComponentHolder);
    }

    private void initializeLayout(JLabel jLabel) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTextField jTextField = this.buildTextField();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jTextField, gridBagConstraints);
        jTextField.putClientProperty("labeledBy", jLabel);
        JButton jButton = this.buildButton();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.addAlignRight(jButton);
        jLabel.setLabelFor(jButton);
        SwingComponentFactory.updateButtonAccessibleName(jLabel, jButton);
        this.add((Component)jButton, gridBagConstraints);
    }

    private JTextField buildTextField() {
        JTextField jTextField = new JTextField(this.buildSchemaContextDisplayStringDocument(), null, 1);
        jTextField.setEditable(false);
        jTextField.setEnabled(true);
        return jTextField;
    }

    private DocumentAdapter buildSchemaContextDisplayStringDocument() {
        return new DocumentAdapter(this.schemaContextDisplayStringHolder);
    }

    private JButton buildButton() {
        JButton jButton = new JButton(this.resourceRepository().getString("SCHEMA_CONTEXT_CHOOSER_BROWSE_BUTTON"));
        jButton.addActionListener(this.buildBrowseAction());
        return jButton;
    }

    private ActionListener buildBrowseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SchemaContextChooser.this.promptToSelectSchemaContext();
            }
        };
    }

    private void promptToSelectSchemaContext() {
        SchemaContextChooserDialog schemaContextChooserDialog = new SchemaContextChooserDialog(this.getWorkbenchContext(), this.schemaRepositoryValue, this.schemaContextComponentHolder);
        schemaContextChooserDialog.show();
    }

    private class SchemaContextDisplayStringValueModel
    extends PropertyValueModelWrapper {
        private String displayString;
        private PropertyChangeListener speakerListener;
        private Set activeSpeakers;

        private SchemaContextDisplayStringValueModel(PropertyValueModel propertyValueModel) {
            super(propertyValueModel);
        }

        protected void initialize() {
            super.initialize();
            this.speakerListener = this.buildSpeakerListener();
            this.activeSpeakers = new HashSet();
        }

        private PropertyChangeListener buildSpeakerListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    SchemaContextDisplayStringValueModel.this.displayStringChanged();
                }
            };
        }

        private MWSchemaContextComponent schemaContextComponent() {
            return (MWSchemaContextComponent)this.valueHolder.getValue();
        }

        private void displayStringChanged() {
            Object object = this.getValue();
            this.synchronizeDisplayString();
            Object object2 = this.getValue();
            this.firePropertyChanged("value", object, object2);
        }

        private void synchronizeDisplayString() {
            this.displayString = SchemaContextComponentDisplayer.displayString(SchemaContextChooser.this.resourceRepository(), this.schemaContextComponent());
        }

        private void engageNewSchemaContext() {
            if (this.schemaContextComponent() != null) {
                this.engageSpeaker((MWModel)this.schemaContextComponent().getSchema());
                Iterator iterator = this.schemaContextComponent().namedComponentChain();
                while (iterator.hasNext()) {
                    this.engageSpeaker((MWModel)((MWNamedSchemaComponent)iterator.next()).getTargetNamespace());
                }
            }
        }

        private void engageSpeaker(MWModel mWModel) {
            this.activeSpeakers.add(mWModel);
            mWModel.addPropertyChangeListener(this.speakerListener);
        }

        private void disengageOldSchemaContext() {
            Iterator iterator = this.activeSpeakers.iterator();
            while (iterator.hasNext()) {
                ((MWModel)iterator.next()).removePropertyChangeListener(this.speakerListener);
            }
            this.activeSpeakers.clear();
        }

        public Object getValue() {
            return this.displayString;
        }

        public void setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        protected void engageValueHolder() {
            super.engageValueHolder();
            this.engageNewSchemaContext();
            this.synchronizeDisplayString();
        }

        protected void disengageValueHolder() {
            this.disengageOldSchemaContext();
            super.disengageValueHolder();
            this.synchronizeDisplayString();
        }

        protected void valueChanged(PropertyChangeEvent propertyChangeEvent) {
            this.disengageOldSchemaContext();
            this.engageNewSchemaContext();
            this.displayStringChanged();
        }
    }
}

