/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class PlatformComponentFactory {
    private PlatformComponentFactory() {
    }

    static ListValueModel buildDatabasePlatformCollectionHolder() {
        ArrayList arrayList = new ArrayList(DatabasePlatformRepository.getDefault().platformsSize());
        CollectionTools.addAll(arrayList, (Iterator)DatabasePlatformRepository.getDefault().platforms());
        CollectionTools.sort(arrayList, (Comparator)new PlatformComparator());
        for (int i = 0; i < arrayList.size(); ++i) {
            DatabasePlatform databasePlatform = (DatabasePlatform)arrayList.get(i);
            String string = databasePlatform.getName().toLowerCase();
            if (string.indexOf("oracle") != -1) continue;
            arrayList.add(i, null);
            break;
        }
        return new SimpleListValueModel(arrayList);
    }

    public static JComboBox buildPlatformChooser(PropertyValueModel propertyValueModel) {
        return new PlatformChooser(propertyValueModel);
    }

    public static JList buildPlatformList(PropertyValueModel propertyValueModel) {
        return new PlatformList(propertyValueModel);
    }

    private static class PlatformModelAdapter
    extends ComboBoxModelAdapter {
        PlatformModelAdapter(ListValueModel listValueModel, PropertyValueModel propertyValueModel) {
            super(listValueModel, propertyValueModel);
        }

        public int indexOf(Object object) {
            Iterator iterator = (Iterator)this.listHolder.getValue();
            int n = 0;
            boolean bl = false;
            while (iterator.hasNext()) {
                if (object == iterator.next()) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                n = -1;
            }
            return n;
        }

        public void setSelectedItem(Object object) {
            if (object == null) {
                int n;
                int n2 = this.indexOf(object);
                object = n2 > (n = this.indexOf(this.getSelectedItem())) ? this.getElementAt(++n2) : this.getElementAt(--n2);
            }
            super.setSelectedItem(object);
        }
    }

    private static class PlatformList
    extends SwingComponentFactory.AccessibleList {
        public PlatformList(PropertyValueModel propertyValueModel) {
            this.setModel(new PlatformModelAdapter(PlatformComponentFactory.buildDatabasePlatformCollectionHolder(), propertyValueModel));
            this.setCellRenderer(new PlatformCellRenderer());
            this.addListSelectionListener(this.buildListSelectionListener(propertyValueModel));
        }

        private ListSelectionListener buildListSelectionListener(final PropertyValueModel propertyValueModel) {
            return new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        propertyValueModel.setValue(PlatformList.this.getSelectedValue());
                    }
                }
            };
        }
    }

    private static class PlatformComparator
    implements Comparator {
        private PlatformComparator() {
        }

        public int compare(Object object, Object object2) {
            boolean bl;
            DatabasePlatform databasePlatform = (DatabasePlatform)object;
            DatabasePlatform databasePlatform2 = (DatabasePlatform)object2;
            String string = databasePlatform.getName().toLowerCase();
            String string2 = databasePlatform2.getName().toLowerCase();
            boolean bl2 = string.indexOf("oracle") != -1;
            boolean bl3 = bl = string2.indexOf("oracle") != -1;
            if (bl2 && !bl) {
                return -1;
            }
            if (!bl2 && bl) {
                return 1;
            }
            if (bl2) {
                return this.oracleVersionNumber(string2) - this.oracleVersionNumber(string);
            }
            return databasePlatform.compareTo((Object)databasePlatform2);
        }

        private int oracleVersionNumber(String string) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (!Character.isDigit(c)) continue;
                stringBuffer.append(c);
            }
            return stringBuffer.length() == 0 ? 0 : Integer.parseInt(stringBuffer.toString());
        }
    }

    private static class PlatformCellRenderer
    extends SimpleListCellRenderer {
        private PlatformCellRenderer() {
        }

        private String buildSeparator(JList jList) {
            int n = jList.getSize().width - jList.getInsets().left - jList.getInsets().right;
            int n2 = n / SwingUtilities.computeStringWidth(jList.getFontMetrics(jList.getFont()), "\u2212") - 2;
            StringBuffer stringBuffer = new StringBuffer(" ");
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append("\u2212");
            }
            return stringBuffer.toString();
        }

        protected String buildText(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return object == null ? this.buildSeparator(jList) : ((DatabasePlatform)object).getName();
        }
    }

    private static class PlatformChooser
    extends JComboBox {
        public PlatformChooser(PropertyValueModel propertyValueModel) {
            this.setModel(new PlatformModelAdapter(PlatformComponentFactory.buildDatabasePlatformCollectionHolder(), propertyValueModel));
            this.setRenderer(new PlatformCellRenderer());
        }
    }
}

