/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.internal.sessions.factories.model.event.SessionEventManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.LogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.platform.ServerPlatformConfig;
import org.eclipse.persistence.internal.sessions.factories.model.rcm.RemoteCommandManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DefaultSessionLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.JavaLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NoLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.Nominative;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.RemoteCommandManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerLogAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionEventManagerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TransportManagerAdapter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;

public abstract class SessionAdapter
extends SCAdapter
implements Nominative {
    private volatile ServerPlatformAdapter serverPlatform;
    public static final String SERVER_PLATFORM_CONFIG_PROPERTY = "serverPlatform";
    public static final String PROFILER_PROPERTY = "profiler";
    public static final String EXCEPTION_HANDLER_CLASS_PROPERTY = "exceptionHandlerClass";
    public static final String SESSION_CUSTOMIZER_CLASS_PROPERTY = "sessionCustomizerClass";
    private volatile LogAdapter log;
    public static final String LOG_CONFIG_PROPERTY = "log";
    public static final String LOG_PROFILER_TOPLINK = "toplink";
    public static final String LOG_PROFILER_DMS = "dms";
    private volatile RemoteCommandManagerAdapter remoteCommandManager;
    public static final String REMOTE_COMMAND_MANAGER_CONFIG_PROPERTY = "remoteCommandManager";
    private volatile SessionEventManagerAdapter sessionEventManager;
    public static final String SESSION_EVENT_LISTENERS_CONFIGS_LIST = "sessionEventListeners";
    private volatile boolean managedByBroker;
    public static final String MANAGED_BY_BROKER = "managedByBroker";
    private boolean cacheSynchronizationManagerAllowed;
    private TriStateBoolean clusteringService;

    SessionAdapter(SCAdapter sCAdapter, SessionConfig sessionConfig) {
        super(sCAdapter, sessionConfig);
    }

    protected SessionAdapter(SCAdapter sCAdapter, String string) {
        super(sCAdapter);
        this.setName(string);
    }

    private SessionEventManagerAdapter buildSessionEventManager() {
        SessionEventManagerAdapter sessionEventManagerAdapter = new SessionEventManagerAdapter(this);
        this.session().setSessionEventManagerConfig((SessionEventManagerConfig)sessionEventManagerAdapter.getModel());
        return sessionEventManagerAdapter;
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        if (this.getLog() != null) {
            list.add(this.getLog());
        }
        if (this.getRemoteCommandManager() != null) {
            list.add(this.getRemoteCommandManager());
        }
        if (this.getServerPlatform() != null) {
            list.add(this.getServerPlatform());
        }
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.verifyDeprecatedFeatures(list);
    }

    protected void initialize(Object object) {
        super.initialize(object);
        this.sessionEventManager = this.buildSessionEventManager();
        this.clusteringService = TriStateBoolean.UNDEFINED;
        this.setDefaultLogging();
        this.managedByBroker = false;
    }

    protected void initializeFromModel(Object object) {
        super.initializeFromModel(object);
        LogAdapter logAdapter = (LogAdapter)this.adapt(this.session().getLogConfig());
        if (logAdapter == null) {
            this.setNoLogging();
        } else {
            this.log = logAdapter;
        }
        this.remoteCommandManager = (RemoteCommandManagerAdapter)this.adapt(this.session().getRemoteCommandManagerConfig());
        this.sessionEventManager = (SessionEventManagerAdapter)this.adapt(this.session().getSessionEventManagerConfig());
        if (this.sessionEventManager == null) {
            this.sessionEventManager = this.buildSessionEventManager();
        }
        if (this.session().getServerPlatformConfig() == null) {
            this.initializeServerPlatform(new ServerPlatform(ClassTools.shortNameForClassNamed((String)NullServerPlatformAdapter.instance().getServerClassName())));
        } else {
            this.serverPlatform = (ServerPlatformAdapter)this.adapt(this.session().getServerPlatformConfig());
        }
        this.clusteringService = this.remoteCommandManager != null ? TriStateBoolean.TRUE : TriStateBoolean.UNDEFINED;
        this.managedByBroker = false;
    }

    protected void postInitializationFromModel() {
        super.postInitializationFromModel();
        if (!this.configVersionIsPre10g() || this.serverPlatform.isCustom()) {
            // empty if block
        }
    }

    private void verifyDeprecatedFeatures(List list) {
        if (this.configVersionIsPre10g() && this.serverPlatform.isCustom()) {
            list.add(this.buildProblem("0813", this.getParent().displayString()));
        }
    }

    protected void initializeServerPlatform(ServerPlatform serverPlatform) {
        this.setServerPlatform(serverPlatform.buildAdapter(this));
    }

    public boolean isCacheSynchronizationManagerAllowed() {
        return this.cacheSynchronizationManagerAllowed;
    }

    public String getName() {
        return this.session().getName();
    }

    public void setName(String string) {
        String string2 = this.session().getName();
        this.session().setName(string);
        this.firePropertyChanged("name", string2, string);
    }

    public String displayString() {
        return this.getName();
    }

    public boolean hasJTA() {
        SessionAdapter sessionAdapter = this.isManaged() ? ((DatabaseSessionAdapter)this).getBroker() : this;
        return sessionAdapter.getServerPlatform() == null ? false : sessionAdapter.getServerPlatform().getEnableJTA();
    }

    public boolean hasCacheSynchronizationManager() {
        return this.clusteringService == TriStateBoolean.FALSE;
    }

    public boolean hasNoClusteringService() {
        return this.clusteringService == TriStateBoolean.UNDEFINED;
    }

    public boolean hasRemoteCommandManager() {
        return this.clusteringService == TriStateBoolean.TRUE;
    }

    public boolean platformIsRdbms() {
        return false;
    }

    public boolean platformIsEis() {
        return false;
    }

    public boolean platformIsXml() {
        return false;
    }

    public boolean isManaged() {
        return this.managedByBroker;
    }

    public boolean isBroker() {
        return false;
    }

    public String getDataSourceName() {
        return "";
    }

    public RemoteCommandManagerAdapter getRemoteCommandManager() {
        return this.remoteCommandManager;
    }

    public RemoteCommandManagerAdapter setClusteringToRemoteCommandManager() {
        if (this.hasRemoteCommandManager()) {
            return this.remoteCommandManager;
        }
        this.clusteringService = TriStateBoolean.TRUE;
        this.setRemoteCommandManager(this.buildRemoteCommandManager());
        return this.remoteCommandManager;
    }

    public void setClusteringToNothing() {
        this.clusteringService = TriStateBoolean.UNDEFINED;
        this.setRemoteCommandManager(null);
    }

    private void setRemoteCommandManager(RemoteCommandManagerAdapter remoteCommandManagerAdapter) {
        RemoteCommandManagerAdapter remoteCommandManagerAdapter2 = this.remoteCommandManager;
        this.remoteCommandManager = remoteCommandManagerAdapter;
        if (remoteCommandManagerAdapter == null) {
            this.session().setRemoteCommandManagerConfig(null);
        } else {
            this.session().setRemoteCommandManagerConfig((RemoteCommandManagerConfig)remoteCommandManagerAdapter.getModel());
        }
        this.firePropertyChanged(REMOTE_COMMAND_MANAGER_CONFIG_PROPERTY, (Object)remoteCommandManagerAdapter2, (Object)remoteCommandManagerAdapter);
    }

    private RemoteCommandManagerAdapter buildRemoteCommandManager() {
        return new RemoteCommandManagerAdapter(this);
    }

    public TransportManagerAdapter getTransportManager() {
        return this.remoteCommandManager.getTransportManager();
    }

    public ServerPlatformAdapter setServerPlatform(ServerPlatform serverPlatform) {
        this.setServerPlatform(serverPlatform.buildAdapter(this));
        this.externalTransactionControllerClassChanged();
        return this.serverPlatform;
    }

    public LogAdapter getLog() {
        return this.log;
    }

    private LogAdapter setNoLogging() {
        this.setLog(new NoLogAdapter(this));
        return this.log;
    }

    public JavaLogAdapter setJavaLogging() {
        this.setLog(new JavaLogAdapter(this));
        return (JavaLogAdapter)this.log;
    }

    public ServerLogAdapter setServerLogging() {
        this.setLog(new ServerLogAdapter(this));
        return (ServerLogAdapter)this.log;
    }

    public DefaultSessionLogAdapter setDefaultLogging() {
        return this.setTopLinkLogging("standard output", "info");
    }

    public DefaultSessionLogAdapter setTopLinkLogging(String string, String string2) {
        this.setLog(new DefaultSessionLogAdapter(this, string, string2));
        return (DefaultSessionLogAdapter)this.log;
    }

    public ServerPlatformAdapter getServerPlatform() {
        return this.isManaged() ? ((DatabaseSessionAdapter)this).getBroker().getServerPlatform() : this.serverPlatform;
    }

    private void setServerPlatform(ServerPlatformAdapter serverPlatformAdapter) {
        ServerPlatformAdapter serverPlatformAdapter2 = this.serverPlatform;
        this.serverPlatform = serverPlatformAdapter;
        this.session().setServerPlatformConfig((ServerPlatformConfig)serverPlatformAdapter.getModel());
        if (serverPlatformAdapter2 != null && serverPlatformAdapter2.isCustom()) {
            this.externalTransactionControllerClassChanged();
        }
        this.firePropertyChanged(SERVER_PLATFORM_CONFIG_PROPERTY, (Object)serverPlatformAdapter2, (Object)serverPlatformAdapter);
    }

    private void setLog(LogAdapter logAdapter) {
        LogAdapter logAdapter2 = this.log;
        this.log = logAdapter;
        this.session().setLogConfig((LogConfig)logAdapter.getModel());
        this.firePropertyChanged(LOG_CONFIG_PROPERTY, (Object)logAdapter2, (Object)logAdapter);
    }

    protected void setManaged(boolean bl) {
        boolean bl2 = this.managedByBroker;
        this.managedByBroker = bl;
        this.firePropertyChanged(MANAGED_BY_BROKER, bl2, bl);
    }

    private final SessionConfig session() {
        return (SessionConfig)this.getModel();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getName());
    }

    public ListIterator sessionEventListenerConfigs() {
        return this.sessionEventManager.sessionEventListenerConfigs();
    }

    private List getSessionEventListenerConfigs() {
        return this.sessionEventManager.getSessionEventListenerConfigs();
    }

    public void addPropertyConfigNamed(String string) {
        int n = this.sessionEventManager.addSessionEventListenerConfigNamed(string);
        this.fireItemAdded(SESSION_EVENT_LISTENERS_CONFIGS_LIST, n, string);
    }

    public String removePropertyConfigNamed(String string) {
        String string2 = null;
        int n = this.getSessionEventListenerConfigs().indexOf(string);
        if (n != -1 && (string2 = this.sessionEventManager.removeSessionEventListenerConfigNamed(string)) != null) {
            this.fireItemRemoved(SESSION_EVENT_LISTENERS_CONFIGS_LIST, n, string2);
        }
        return string2;
    }

    private void removeAllPropertyConfigNamed() {
        List list = this.sessionEventManager.removeAllSessionEventListenerConfigNamed();
        if (list.size() > 0) {
            this.fireItemsRemoved(SESSION_EVENT_LISTENERS_CONFIGS_LIST, 0, list);
        }
    }

    public String getProfiler() {
        return this.session().getProfiler();
    }

    public void setProfiler(String string) {
        String string2 = this.session().getProfiler();
        this.session().setProfiler(string);
        this.firePropertyChanged(PROFILER_PROPERTY, string2, string);
    }

    abstract void externalTransactionControllerClassChanged();

    public String getExceptionHandlerClass() {
        return this.session().getExceptionHandlerClass();
    }

    public void setExceptionHandlerClass(String string) {
        String string2 = this.session().getExceptionHandlerClass();
        this.session().setExceptionHandlerClass(string);
        this.firePropertyChanged(EXCEPTION_HANDLER_CLASS_PROPERTY, string2, string);
    }

    public String getSessionCustomizerClass() {
        return this.session().getSessionCustomizerClass();
    }

    public void setSessionCustomizerClass(String string) {
        String string2 = this.session().getSessionCustomizerClass();
        this.session().setSessionCustomizerClass(string);
        this.firePropertyChanged(SESSION_CUSTOMIZER_CLASS_PROPERTY, string2, string);
    }

    protected void initializeDefaults() {
        super.initializeDefaults();
        this.setDefaultLogging();
        if (this.getProfiler() != null) {
            this.setProfiler(null);
        }
        if (this.getExceptionHandlerClass() != null) {
            this.setExceptionHandlerClass(null);
        }
        if (this.getSessionCustomizerClass() != null) {
            this.setSessionCustomizerClass(null);
        }
        if (!this.hasNoClusteringService()) {
            this.setClusteringToNothing();
        }
        this.removeAllPropertyConfigNamed();
    }
}

