/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.pool;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

public class NamedConnectionPoolCreationDialog
extends AbstractValidatingDialog {
    private JTextField nameTextField;
    private final Collection poolNames;
    private final PropertyValueModel stringHolder;

    public NamedConnectionPoolCreationDialog(WorkbenchContext workbenchContext, PropertyValueModel propertyValueModel, Iterator iterator) {
        super(workbenchContext);
        this.stringHolder = propertyValueModel;
        this.poolNames = CollectionTools.collection((Iterator)iterator);
    }

    protected void initialize() {
        super.initialize();
        this.getOKAction().setEnabled(false);
    }

    private Document buildNameDocumentAdapter() {
        return new DocumentAdapter(this.stringHolder, new RegexpDocument(13));
    }

    protected Component buildMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("NAMED_CONNECTION_POOL_CREATION_DIALOG_TITLE"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.resourceRepository().getString("POOL_NAME_LABEL"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("POOL_NAME_LABEL"));
        jLabel.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("POOL_NAME_LABEL"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.nameTextField = new JTextField(this.buildNameDocumentAdapter(), null, 20);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.nameTextField, gridBagConstraints);
        jLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                NamedConnectionPoolCreationDialog.this.updateOKAction();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NamedConnectionPoolCreationDialog.this.updateOKAction();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.helpManager().addTopicID(jPanel, this.helpTopicId() + ".name");
        return jPanel;
    }

    private void updateOKAction() {
        String string = this.nameTextField.getText().trim();
        boolean bl = string.length() > 0 && !this.poolNames.contains(string);
        this.getOKAction().setEnabled(bl);
        if (bl) {
            this.clearErrorMessage();
        } else {
            this.setErrorMessageKey("NAMED_CONNECTION_POOL_CREATION_DIALOG_INVALID_NAME");
        }
    }

    private String buildUniquePoolName() {
        String string = this.preferences().get("new name.pool", this.resourceRepository().getString("POOL_CREATION_DIALOG_NEW_POOL_NAME"));
        return NameTools.uniqueNameFor((String)string, (Collection)this.poolNames);
    }

    protected String helpTopicId() {
        return "dialog.namedConnectionPoolCreation";
    }

    protected void prepareToShow() {
        super.prepareToShow();
        this.nameTextField.setText(this.buildUniquePoolName());
        this.nameTextField.selectAll();
    }

    protected Component initialFocusComponent() {
        return this.nameTextField;
    }
}

