/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.ClasspathPanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCClassRepository;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.adapters.PreferencePropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.DefaultChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

final class SCPreferencesPage
extends AbstractPanel {
    private CustomizedClassRepository repository;

    SCPreferencesPage(PreferencesContext preferencesContext) {
        super((LayoutManager)new BorderLayout(), preferencesContext);
        this.intializeLayout();
        this.addHelpTopicId(this, "preferences.sessions.general");
    }

    private PropertyValueModel buildClasspathHolder() {
        BufferedPropertyValueModel bufferedPropertyValueModel = new BufferedPropertyValueModel(this.buildClasspathHolderImp(), this.getPreferencesContext().getBufferTrigger());
        bufferedPropertyValueModel.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            }
        });
        return bufferedPropertyValueModel;
    }

    private PropertyValueModel buildClasspathHolderImp() {
        return new PreferencePropertyValueModel(this.preferences(), "default classpath"){

            protected Object getValueFromSubject() {
                String string = (String)super.getValueFromSubject();
                if ("".equals(string)) {
                    return null;
                }
                return string;
            }
        };
    }

    private void intializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.getVerticalScrollBar().setBlockIncrement(20);
        jScrollPane.setBorder(null);
        jScrollPane.setViewportBorder(null);
        this.add((Component)jScrollPane, "Center");
        this.repository = new CustomizedClassRepository();
        PropertyValueModel propertyValueModel = this.buildClasspathHolder();
        this.repository.update(propertyValueModel);
        ClasspathPanel classpathPanel = new ClasspathPanel(this.getApplicationContext(), (ListValueModel)new ClasspathListModel(this.repository, propertyValueModel), true, "PREFERENCES_DEFAULT_CLASSPATH_GROUP_BOX");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)classpathPanel, gridBagConstraints);
    }

    private class CustomizedClassRepository
    extends SCClassRepository {
        private CustomizedClassRepository() {
            super(new String[0]);
        }

        public Node.Validator getValidator() {
            return NULL_VALIDATOR;
        }

        public ChangeNotifier getChangeNotifier() {
            return DefaultChangeNotifier.instance();
        }

        public void update(PropertyValueModel propertyValueModel) {
            String string = (String)propertyValueModel.getValue();
            if (string == null) {
                return;
            }
            Object[] objectArray = string.split(System.getProperty("path.separator"));
            if (objectArray.length == 0) {
                return;
            }
            List list = CollectionTools.list((Object[])objectArray);
            CollectionTools.removeAll((Collection)list, (Iterator)this.classpathEntries());
            if (!list.isEmpty()) {
                this.addClasspathEntries(this.classpathEntriesSize(), list);
            }
        }
    }

    private class ClasspathListModel
    extends ListAspectAdapter {
        private final PropertyValueModel preferenceHolder;

        private ClasspathListModel(SCClassRepository sCClassRepository, PropertyValueModel propertyValueModel) {
            super("classpathEntries", (Model)sCClassRepository);
            this.preferenceHolder = propertyValueModel;
        }

        public void addItem(int n, Object object) {
            SCClassRepository sCClassRepository = (SCClassRepository)this.subject;
            sCClassRepository.addClasspathEntry(n, (String)object);
            this.preferenceHolder.setValue(sCClassRepository.entries());
        }

        public Object getItem(int n) {
            SCClassRepository sCClassRepository = (SCClassRepository)this.subject;
            return sCClassRepository.getClasspathEntry(n);
        }

        protected ListIterator getValueFromSubject() {
            SCClassRepository sCClassRepository = (SCClassRepository)this.subject;
            return sCClassRepository.classpathEntries();
        }

        public Object removeItem(int n) {
            SCClassRepository sCClassRepository = (SCClassRepository)this.subject;
            String string = sCClassRepository.removeClasspathEntry(n);
            this.preferenceHolder.setValue(sCClassRepository.entries());
            return string;
        }

        public Object replaceItem(int n, Object object) {
            SCClassRepository sCClassRepository = (SCClassRepository)this.subject;
            String string = sCClassRepository.replaceClasspathEntry(n, (String)object);
            this.preferenceHolder.setValue(sCClassRepository.entries());
            return string;
        }
    }
}

