/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.DisplayableAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;

public class PropertyValueModelDisplayableAdapter
extends AbstractModel
implements Displayable {
    protected PropertyValueModel valueHolder;
    protected PropertyChangeListener valueChangeListener;
    private DisplayableAdapter adapter;

    public PropertyValueModelDisplayableAdapter(PropertyValueModel propertyValueModel) {
        this(propertyValueModel, DisplayableAdapter.DEFAULT_INSTANCE);
    }

    public PropertyValueModelDisplayableAdapter(PropertyValueModel propertyValueModel, DisplayableAdapter displayableAdapter) {
        this.valueHolder = propertyValueModel;
        this.adapter = displayableAdapter;
    }

    protected void initialize() {
        super.initialize();
        this.valueChangeListener = this.buildValueChangeListener();
    }

    protected PropertyChangeListener buildValueChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PropertyValueModelDisplayableAdapter.this.valueChanged(propertyChangeEvent);
            }

            public String toString() {
                return "value change listener";
            }
        };
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.hasNoRelevantListeners()) {
            this.valueHolder.addPropertyChangeListener("value", this.valueChangeListener);
        }
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.propertyIsRelevant(string) && this.hasNoRelevantListeners()) {
            this.valueHolder.addPropertyChangeListener("value", this.valueChangeListener);
        }
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.hasNoRelevantListeners()) {
            this.valueHolder.removePropertyChangeListener("value", this.valueChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(string, propertyChangeListener);
        if (this.propertyIsRelevant(string) && this.hasNoRelevantListeners()) {
            this.valueHolder.removePropertyChangeListener("value", this.valueChangeListener);
        }
    }

    protected boolean propertyIsRelevant(String string) {
        return string == "displayString" || string == "icon";
    }

    protected boolean hasNoRelevantListeners() {
        return this.hasNoPropertyChangeListeners("displayString") && this.hasNoPropertyChangeListeners("icon");
    }

    public int compareTo(Object object) {
        return DEFAULT_COMPARATOR.compare(this, object);
    }

    public String displayString() {
        return this.displayString(this.valueHolder.getValue());
    }

    public Icon icon() {
        return this.icon(this.valueHolder.getValue());
    }

    protected void valueChanged(PropertyChangeEvent propertyChangeEvent) {
        this.firePropertyChanged("displayString", this.displayString(propertyChangeEvent.getOldValue()), this.displayString(propertyChangeEvent.getNewValue()));
        this.firePropertyChanged("icon", this.icon(propertyChangeEvent.getOldValue()), this.icon(propertyChangeEvent.getNewValue()));
    }

    protected String displayString(Object object) {
        return this.adapter.displayString(object);
    }

    public Icon icon(Object object) {
        return this.adapter.icon(object);
    }
}

