/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.uitools.app.AspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;

public abstract class CollectionAspectAdapter
extends AspectAdapter
implements CollectionValueModel {
    protected String collectionName;
    protected CollectionChangeListener collectionChangeListener;

    protected CollectionAspectAdapter(String string, Model model) {
        super(model);
        this.collectionName = string;
    }

    protected CollectionAspectAdapter(ValueModel valueModel, String string) {
        super(valueModel);
        this.collectionName = string;
    }

    protected CollectionAspectAdapter(ValueModel valueModel) {
        this(valueModel, null);
    }

    protected void initialize() {
        super.initialize();
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
                CollectionAspectAdapter.this.itemsAdded(collectionChangeEvent);
            }

            public void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
                CollectionAspectAdapter.this.itemsRemoved(collectionChangeEvent);
            }

            public void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
                CollectionAspectAdapter.this.collectionChanged(collectionChangeEvent);
            }

            public String toString() {
                return "collection change listener: " + CollectionAspectAdapter.this.collectionName;
            }
        };
    }

    public Object getValue() {
        if (this.subject == null) {
            return NullIterator.instance();
        }
        return this.getValueFromSubject();
    }

    protected Iterator getValueFromSubject() {
        throw new UnsupportedOperationException();
    }

    public void addItem(Object object) {
        throw new UnsupportedOperationException();
    }

    public void addItems(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addItem(iterator.next());
        }
    }

    public void removeItem(Object object) {
        throw new UnsupportedOperationException();
    }

    public void removeItems(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeItem(iterator.next());
        }
    }

    public int size() {
        return this.subject == null ? 0 : this.sizeFromSubject();
    }

    protected int sizeFromSubject() {
        return CollectionTools.size((Iterator)((Iterator)this.getValue()));
    }

    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("value");
    }

    protected void fireAspectChange(Object object, Object object2) {
        this.fireCollectionChanged("value");
    }

    protected void engageNonNullSubject() {
        if (this.collectionName != null) {
            ((Model)this.subject).addCollectionChangeListener(this.collectionName, this.collectionChangeListener);
        }
    }

    protected void disengageNonNullSubject() {
        if (this.collectionName != null) {
            ((Model)this.subject).removeCollectionChangeListener(this.collectionName, this.collectionChangeListener);
        }
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.collectionName);
    }

    protected void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
        this.fireItemsAdded(collectionChangeEvent.cloneWithSource((Object)this, "value"));
    }

    protected void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
        this.fireItemsRemoved(collectionChangeEvent.cloneWithSource((Object)this, "value"));
    }

    protected void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
        this.fireCollectionChanged("value");
    }
}

