/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;

public abstract class ListValueModelWrapper
extends AbstractModel
implements ListValueModel {
    protected ListValueModel listHolder;
    protected ListChangeListener listChangeListener;

    protected ListValueModelWrapper(ListValueModel listValueModel) {
        if (listValueModel == null) {
            throw new NullPointerException();
        }
        this.listHolder = listValueModel;
    }

    protected void initialize() {
        super.initialize();
        this.listChangeListener = this.buildListChangeListener();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent listChangeEvent) {
                ListValueModelWrapper.this.itemsAdded(listChangeEvent);
            }

            public void itemsRemoved(ListChangeEvent listChangeEvent) {
                ListValueModelWrapper.this.itemsRemoved(listChangeEvent);
            }

            public void itemsReplaced(ListChangeEvent listChangeEvent) {
                ListValueModelWrapper.this.itemsReplaced(listChangeEvent);
            }

            public void listChanged(ListChangeEvent listChangeEvent) {
                ListValueModelWrapper.this.listChanged(listChangeEvent);
            }

            public String toString() {
                return "list change listener";
            }
        };
    }

    public synchronized void addListChangeListener(ListChangeListener listChangeListener) {
        if (this.hasNoListChangeListeners("value")) {
            this.engageModel();
        }
        super.addListChangeListener(listChangeListener);
    }

    public synchronized void addListChangeListener(String string, ListChangeListener listChangeListener) {
        if (string == "value" && this.hasNoListChangeListeners("value")) {
            this.engageModel();
        }
        super.addListChangeListener(string, listChangeListener);
    }

    public synchronized void removeListChangeListener(ListChangeListener listChangeListener) {
        super.removeListChangeListener(listChangeListener);
        if (this.hasNoListChangeListeners("value")) {
            this.disengageModel();
        }
    }

    public synchronized void removeListChangeListener(String string, ListChangeListener listChangeListener) {
        super.removeListChangeListener(string, listChangeListener);
        if (string == "value" && this.hasNoListChangeListeners("value")) {
            this.disengageModel();
        }
    }

    protected void engageModel() {
        this.listHolder.addListChangeListener("value", this.listChangeListener);
    }

    protected void disengageModel() {
        this.listHolder.removeListChangeListener("value", this.listChangeListener);
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.listHolder);
    }

    protected abstract void itemsAdded(ListChangeEvent var1);

    protected abstract void itemsRemoved(ListChangeEvent var1);

    protected abstract void itemsReplaced(ListChangeEvent var1);

    protected abstract void listChanged(ListChangeEvent var1);
}

