/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModelWrapper;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.iterators.ReadOnlyListIterator;

public class TransformationListValueModelAdapter
extends ListValueModelWrapper {
    protected final Transformer transformer;
    protected List transformedList;

    public TransformationListValueModelAdapter(ListValueModel listValueModel, Transformer transformer) {
        super(listValueModel);
        this.transformer = transformer;
    }

    public TransformationListValueModelAdapter(ListValueModel listValueModel) {
        this(listValueModel, Transformer.NULL_INSTANCE);
    }

    public TransformationListValueModelAdapter(CollectionValueModel collectionValueModel, Transformer transformer) {
        this(new CollectionListValueModelAdapter(collectionValueModel), transformer);
    }

    public TransformationListValueModelAdapter(CollectionValueModel collectionValueModel) {
        this(collectionValueModel, Transformer.NULL_INSTANCE);
    }

    protected void initialize() {
        super.initialize();
        this.transformedList = new ArrayList();
    }

    public Object getValue() {
        return new ReadOnlyListIterator(this.transformedList);
    }

    public void addItem(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public void addItems(int n, List list) {
        throw new UnsupportedOperationException();
    }

    public Object removeItem(int n) {
        throw new UnsupportedOperationException();
    }

    public List removeItems(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    public Object replaceItem(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public List replaceItems(int n, List list) {
        throw new UnsupportedOperationException();
    }

    public Object getItem(int n) {
        return this.transformedList.get(n);
    }

    public int size() {
        return this.transformedList.size();
    }

    protected void engageModel() {
        super.engageModel();
        this.transformedList.addAll(this.transformItems(this.listHolder));
    }

    protected void disengageModel() {
        super.disengageModel();
        this.transformedList.clear();
    }

    protected List transformItems(ListChangeEvent listChangeEvent) {
        return this.transformItems(listChangeEvent.items(), listChangeEvent.size());
    }

    protected List transformItems(ListValueModel listValueModel) {
        return this.transformItems((ListIterator)listValueModel.getValue(), listValueModel.size());
    }

    protected List transformReplacedItems(ListChangeEvent listChangeEvent) {
        return this.transformItems(listChangeEvent.replacedItems(), listChangeEvent.size());
    }

    protected List transformItems(ListIterator listIterator, int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        while (listIterator.hasNext()) {
            arrayList.add(this.transformItem(listIterator.next()));
        }
        return arrayList;
    }

    protected Object transformItem(Object object) {
        return this.transformer.transform(object);
    }

    protected void itemsAdded(ListChangeEvent listChangeEvent) {
        this.addItemsToList(listChangeEvent.getIndex(), this.transformItems(listChangeEvent), this.transformedList, "value");
    }

    protected void itemsRemoved(ListChangeEvent listChangeEvent) {
        this.removeItemsFromList(listChangeEvent.getIndex(), listChangeEvent.size(), this.transformedList, "value");
    }

    protected void itemsReplaced(ListChangeEvent listChangeEvent) {
        this.setItemsInList(listChangeEvent.getIndex(), this.transformItems(listChangeEvent), this.transformedList, "value");
    }

    protected void listChanged(ListChangeEvent listChangeEvent) {
        this.transformedList.clear();
        this.transformedList.addAll(this.transformItems(this.listHolder));
        this.fireListChanged("value");
    }
}

