/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.uitools.app.AspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.TreeChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;

public abstract class TreeAspectAdapter
extends AspectAdapter
implements TreeValueModel {
    protected String treeName;
    protected TreeChangeListener treeChangeListener;

    protected TreeAspectAdapter(String string, Model model) {
        super(model);
        this.treeName = string;
    }

    protected TreeAspectAdapter(ValueModel valueModel, String string) {
        super(valueModel);
        this.treeName = string;
    }

    protected void initialize() {
        super.initialize();
        this.treeChangeListener = this.buildTreeChangeListener();
    }

    protected TreeChangeListener buildTreeChangeListener() {
        return new TreeChangeListener(){

            public void nodeAdded(TreeChangeEvent treeChangeEvent) {
                TreeAspectAdapter.this.nodeAdded(treeChangeEvent);
            }

            public void nodeRemoved(TreeChangeEvent treeChangeEvent) {
                TreeAspectAdapter.this.nodeRemoved(treeChangeEvent);
            }

            public void treeChanged(TreeChangeEvent treeChangeEvent) {
                TreeAspectAdapter.this.treeChanged(treeChangeEvent);
            }

            public String toString() {
                return "tree change listener: " + TreeAspectAdapter.this.treeName;
            }
        };
    }

    public Object getValue() {
        if (this.subject == null) {
            return NullIterator.instance();
        }
        return this.getValueFromSubject();
    }

    protected Iterator getValueFromSubject() {
        throw new UnsupportedOperationException();
    }

    public void addNode(Object[] objectArray, Object object) {
        throw new UnsupportedOperationException();
    }

    public void removeNode(Object[] objectArray) {
        throw new UnsupportedOperationException();
    }

    protected boolean hasListeners() {
        return this.hasAnyTreeChangeListeners("value");
    }

    protected void fireAspectChange(Object object, Object object2) {
        this.fireTreeStructureChanged("value");
    }

    protected void engageNonNullSubject() {
        ((Model)this.subject).addTreeChangeListener(this.treeName, this.treeChangeListener);
    }

    protected void disengageNonNullSubject() {
        ((Model)this.subject).removeTreeChangeListener(this.treeName, this.treeChangeListener);
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.treeName);
    }

    protected void nodeAdded(TreeChangeEvent treeChangeEvent) {
        this.fireNodeAdded("value", treeChangeEvent.getPath());
    }

    protected void nodeRemoved(TreeChangeEvent treeChangeEvent) {
        this.fireNodeRemoved("value", treeChangeEvent.getPath());
    }

    protected void treeChanged(TreeChangeEvent treeChangeEvent) {
        this.fireTreeStructureChanged("value", treeChangeEvent.getPath());
    }
}

