/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.UpdateObjectQuery;

public class CMPPolicy
implements Serializable {
    protected Boolean forceUpdate = null;
    protected Boolean updateAllFields = null;
    protected PessimisticLockingPolicy pessimisticLockingPolicy;
    protected Class mappedClass;
    protected ClassDescriptor descriptor;
    protected int modificationDeferralLevel = 2;
    public static final int NONE = 0;
    public static final int UPDATE_MODIFICATIONS = 1;
    public static final int ALL_MODIFICATIONS = 2;
    protected int nonDeferredCreateTime = 0;
    public static final int UNDEFINED = 0;
    public static final int AFTER_EJBCREATE = 1;
    public static final int AFTER_EJBPOSTCREATE = 2;

    public int getNonDeferredCreateTime() {
        return this.nonDeferredCreateTime;
    }

    public PessimisticLockingPolicy getPessimisticLockingPolicy() {
        return this.pessimisticLockingPolicy;
    }

    public void setDeferModificationsUntilCommit(int n) {
        this.modificationDeferralLevel = n;
    }

    public void setMappedClass(Class clazz) {
        this.mappedClass = clazz;
    }

    public Class getMappedClass() {
        return this.mappedClass;
    }

    public void setNonDeferredCreateTime(int n) {
        this.nonDeferredCreateTime = n;
    }

    public void setPessimisticLockingPolicy(PessimisticLockingPolicy pessimisticLockingPolicy) {
        this.pessimisticLockingPolicy = pessimisticLockingPolicy;
    }

    public boolean hasPessimisticLockingPolicy() {
        return this.pessimisticLockingPolicy != null;
    }

    public int getDeferModificationsUntilCommit() {
        return this.modificationDeferralLevel;
    }

    public boolean getForceUpdate() {
        return Boolean.TRUE.equals(this.forceUpdate);
    }

    public void setForceUpdate(boolean bl) {
        this.forceUpdate = bl;
    }

    public boolean getUpdateAllFields() {
        return Boolean.TRUE.equals(this.updateAllFields);
    }

    public void setUpdateAllFields(boolean bl) {
        this.updateAllFields = bl;
    }

    public Boolean internalGetForceUpdate() {
        return this.forceUpdate;
    }

    public Boolean internalGetUpdateAllFields() {
        return this.updateAllFields;
    }

    public void internalSetForceUpdate(Boolean bl) {
        this.forceUpdate = bl;
    }

    public void internalSetUpdateAllFields(Boolean bl) {
        this.updateAllFields = bl;
    }

    public void initialize(ClassDescriptor classDescriptor, AbstractSession abstractSession) throws DescriptorException {
        if (this.getUpdateAllFields() && !classDescriptor.getQueryManager().hasUpdateQuery()) {
            classDescriptor.getQueryManager().setUpdateQuery(new UpdateObjectQuery());
        }
        if (this.getForceUpdate() && !this.getUpdateAllFields()) {
            throw DescriptorException.updateAllFieldsNotSet(classDescriptor);
        }
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public boolean isCMP3Policy() {
        return false;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public Object createPrimaryKeyInstance(Vector vector) {
        KeyElementAccessor[] keyElementAccessorArray = this.getKeyClassFields(this.getPKClass());
        if (keyElementAccessorArray.length == 1 && keyElementAccessorArray[0] instanceof KeyIsElementAccessor) {
            return vector.get(0);
        }
        Object object = this.getPKClassInstance();
        for (int i = 0; i < keyElementAccessorArray.length; ++i) {
            KeyElementAccessor keyElementAccessor = keyElementAccessorArray[i];
            Object e = vector.get(i);
            keyElementAccessor.setValue(object, e);
        }
        return object;
    }

    public Object createPrimaryKeyInstance(Object object, AbstractSession abstractSession) {
        KeyElementAccessor[] keyElementAccessorArray = this.getKeyClassFields(this.getPKClass());
        ObjectBuilder objectBuilder = this.getDescriptor().getObjectBuilder();
        if (keyElementAccessorArray.length == 1 && keyElementAccessorArray[0] instanceof KeyIsElementAccessor) {
            DatabaseMapping databaseMapping = objectBuilder.getMappingForAttributeName(keyElementAccessorArray[0].getAttributeName());
            return databaseMapping.getRealAttributeValueFromObject(object, abstractSession);
        }
        Object object2 = this.getPKClassInstance();
        for (int i = 0; i < keyElementAccessorArray.length; ++i) {
            KeyElementAccessor keyElementAccessor = keyElementAccessorArray[i];
            DatabaseMapping databaseMapping = objectBuilder.getMappingForAttributeName(keyElementAccessor.getAttributeName());
            while (databaseMapping.isAggregateObjectMapping()) {
                if ((databaseMapping = databaseMapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(keyElementAccessorArray[i].getAttributeName())) != null) continue;
                databaseMapping = objectBuilder.getMappingForField(keyElementAccessor.getDatabaseField());
            }
            Object object3 = databaseMapping.getRealAttributeValueFromObject(object, abstractSession);
            keyElementAccessor.setValue(object2, object3);
        }
        return object2;
    }

    public Object getPKClassInstance() {
        throw new RuntimeException("Should not get here.");
    }

    public Class getPKClass() {
        throw new RuntimeException("Should not get here.");
    }

    public Vector createPkVectorFromKey(Object object, AbstractSession abstractSession) {
        throw new RuntimeException("Should not get here.");
    }

    public Object createBeanUsingKey(Object object, AbstractSession abstractSession) {
        throw new RuntimeException("Should not get here.");
    }

    protected KeyElementAccessor[] getKeyClassFields(Class clazz) {
        throw new RuntimeException("Should not get here.");
    }

    protected class KeyIsElementAccessor
    implements KeyElementAccessor,
    Serializable {
        protected String attributeName;
        protected DatabaseField databaseField;

        public KeyIsElementAccessor(String string, DatabaseField databaseField) {
            this.attributeName = string;
            this.databaseField = databaseField;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public Object getValue(Object object) {
            return object;
        }

        public void setValue(Object object, Object object2) {
        }
    }

    protected static interface KeyElementAccessor {
        public String getAttributeName();

        public DatabaseField getDatabaseField();

        public Object getValue(Object var1);

        public void setValue(Object var1, Object var2);
    }
}

