/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.QueryHintsHandler;
import org.eclipse.persistence.internal.jpa.parsing.JPQLParseTree;
import org.eclipse.persistence.internal.jpa.parsing.jpql.JPQLParser;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.JPQLCallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBQueryImpl
implements JpaQuery {
    protected DatabaseQuery databaseQuery = null;
    protected EntityManagerImpl entityManager = null;
    protected String queryName = null;
    protected Map parameters = new HashMap();
    protected int firstResultIndex = -1;
    protected int maxResults = -1;
    protected LockModeType lockMode = null;
    protected boolean isShared;

    protected EJBQueryImpl(EntityManagerImpl entityManagerImpl) {
        this.entityManager = entityManagerImpl;
        this.isShared = true;
    }

    public EJBQueryImpl(DatabaseQuery databaseQuery, EntityManagerImpl entityManagerImpl) {
        this(entityManagerImpl);
        this.databaseQuery = databaseQuery;
    }

    public EJBQueryImpl(String string, EntityManagerImpl entityManagerImpl) {
        this(string, entityManagerImpl, false);
    }

    public EJBQueryImpl(String string, EntityManagerImpl entityManagerImpl, boolean bl) {
        this(entityManagerImpl);
        if (bl) {
            this.queryName = string;
        } else if (this.databaseQuery == null) {
            this.databaseQuery = EJBQueryImpl.buildEJBQLDatabaseQuery(string, this.entityManager.getServerSession());
        }
    }

    protected void setAsSQLModifyQuery() {
        if (this.getDatabaseQuery().isDataReadQuery()) {
            DataModifyQuery dataModifyQuery = new DataModifyQuery();
            dataModifyQuery.setIsUserDefined(this.databaseQuery.isUserDefined());
            dataModifyQuery.copyFromQuery(this.databaseQuery);
            dataModifyQuery.setDatasourceCall((Call)this.databaseQuery.getDatasourceCall().clone());
            this.databaseQuery = dataModifyQuery;
        }
    }

    protected void setAsSQLReadQuery() {
        if (this.getDatabaseQuery().isDataModifyQuery()) {
            DataReadQuery dataReadQuery = new DataReadQuery();
            dataReadQuery.setResultType(4);
            dataReadQuery.setIsUserDefined(this.databaseQuery.isUserDefined());
            dataReadQuery.copyFromQuery(this.databaseQuery);
            this.databaseQuery = dataReadQuery;
        }
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String string, Session session) {
        return EJBQueryImpl.buildEJBQLDatabaseQuery(null, string, session, null, null, null);
    }

    public static DatabaseQuery buildEJBQLDatabaseQuery(String string, String string2, Session session, Enum enum_, Map<String, Object> map, ClassLoader classLoader) {
        boolean bl = string == null && map == null;
        DatabaseQuery databaseQuery = null;
        if (bl) {
            databaseQuery = (DatabaseQuery)session.getProject().getJPQLParseCache().get(string2);
        }
        if (databaseQuery == null || !databaseQuery.isPrepared()) {
            ReadAllQuery readAllQuery;
            JPQLParseTree jPQLParseTree = JPQLParser.buildParseTree(string, string2);
            jPQLParseTree.setClassLoader(classLoader);
            databaseQuery = jPQLParseTree.createDatabaseQuery();
            databaseQuery.setJPQLString(string2);
            jPQLParseTree.populateQuery(databaseQuery, (AbstractSession)session);
            if (databaseQuery.isReadAllQuery() && (readAllQuery = (ReadAllQuery)databaseQuery).hasJoining() && readAllQuery.getDistinctState() == 2) {
                readAllQuery.setShouldFilterDuplicates(false);
            }
            jPQLParseTree.addParametersToQuery(databaseQuery);
            ((JPQLCallQueryMechanism)databaseQuery.getQueryMechanism()).getJPQLCall().setIsParsed(true);
            if (databaseQuery.isReadQuery()) {
                databaseQuery.cascadeByMapping();
            }
            if (enum_ != null && !enum_.name().equals("NONE")) {
                if (databaseQuery.isObjectLevelReadQuery()) {
                    if (((ObjectLevelReadQuery)databaseQuery).setLockModeType(enum_.name(), (AbstractSession)session)) {
                        throw new PersistenceException(ExceptionLocalization.buildMessage("ejb30-wrong-lock_called_without_version_locking-index", null));
                    }
                } else {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_lock_query", null));
                }
            }
            databaseQuery = EJBQueryImpl.applyHints(map, databaseQuery, classLoader);
            if (bl) {
                databaseQuery.prepareCall(session, new DatabaseRecord());
                session.getProject().getJPQLParseCache().put(string2, databaseQuery);
            }
        }
        return databaseQuery;
    }

    public static DatabaseQuery buildSQLDatabaseQuery(Class clazz, String string, ClassLoader classLoader) {
        return EJBQueryImpl.buildSQLDatabaseQuery(clazz, string, null, classLoader);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(Class clazz, String string, Map<String, Object> map, ClassLoader classLoader) {
        ReadAllQuery readAllQuery = new ReadAllQuery(clazz);
        readAllQuery.setSQLString(string);
        readAllQuery.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(map, readAllQuery, classLoader);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String string, String string2, ClassLoader classLoader) {
        return EJBQueryImpl.buildSQLDatabaseQuery(string, string2, null, classLoader);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String string, String string2, Map<String, Object> map, ClassLoader classLoader) {
        ResultSetMappingQuery resultSetMappingQuery = new ResultSetMappingQuery();
        resultSetMappingQuery.setSQLResultSetMappingName(string);
        resultSetMappingQuery.setSQLString(string2);
        resultSetMappingQuery.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(map, resultSetMappingQuery, classLoader);
    }

    public static DatabaseQuery buildStoredProcedureQuery(Class clazz, StoredProcedureCall storedProcedureCall, List<String> list, Map<String, Object> map, ClassLoader classLoader) {
        DatabaseQuery databaseQuery = new ReadAllQuery(clazz);
        databaseQuery.setCall(storedProcedureCall);
        databaseQuery.setIsUserDefined(true);
        databaseQuery = EJBQueryImpl.applyHints(map, databaseQuery, classLoader);
        EJBQueryImpl.applyArguments(list, databaseQuery);
        return databaseQuery;
    }

    public static DatabaseQuery buildStoredProcedureQuery(StoredProcedureCall storedProcedureCall, List<String> list, Map<String, Object> map, ClassLoader classLoader) {
        DataReadQuery dataReadQuery = new DataReadQuery();
        dataReadQuery.setResultType(4);
        dataReadQuery.setCall(storedProcedureCall);
        dataReadQuery.setIsUserDefined(true);
        DatabaseQuery databaseQuery = EJBQueryImpl.applyHints(map, dataReadQuery, classLoader);
        EJBQueryImpl.applyArguments(list, databaseQuery);
        return databaseQuery;
    }

    public static DatabaseQuery buildStoredProcedureQuery(String string, StoredProcedureCall storedProcedureCall, List<String> list, Map<String, Object> map, ClassLoader classLoader) {
        ResultSetMappingQuery resultSetMappingQuery = new ResultSetMappingQuery();
        resultSetMappingQuery.setSQLResultSetMappingName(string);
        resultSetMappingQuery.setCall(storedProcedureCall);
        resultSetMappingQuery.setIsUserDefined(true);
        DatabaseQuery databaseQuery = EJBQueryImpl.applyHints(map, resultSetMappingQuery, classLoader);
        EJBQueryImpl.applyArguments(list, databaseQuery);
        return databaseQuery;
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String string, ClassLoader classLoader) {
        return EJBQueryImpl.buildSQLDatabaseQuery(string, new HashMap<String, Object>(), classLoader);
    }

    public static DatabaseQuery buildSQLDatabaseQuery(String string, Map<String, Object> map, ClassLoader classLoader) {
        DataReadQuery dataReadQuery = new DataReadQuery();
        dataReadQuery.setResultType(4);
        dataReadQuery.setSQLString(string);
        dataReadQuery.setIsUserDefined(true);
        return EJBQueryImpl.applyHints(map, dataReadQuery, classLoader);
    }

    protected Object executeReadQuery() {
        List list = this.processParameters();
        boolean bl = false;
        if (this.isFlushModeAUTO()) {
            this.performPreQueryFlush();
            if (this.getDatabaseQuery().isObjectLevelReadQuery() && ((ObjectLevelReadQuery)this.getDatabaseQuery()).shouldConformResultsInUnitOfWork()) {
                this.cloneSharedQuery();
                ((ObjectLevelReadQuery)this.getDatabaseQuery()).setCacheUsage(-1);
                bl = true;
            }
        }
        if (this.lockMode != null) {
            this.entityManager.checkForTransaction(true);
            this.cloneSharedQuery();
            if (((ObjectLevelReadQuery)this.getDatabaseQuery()).setLockModeType(this.lockMode.name(), (AbstractSession)this.getActiveSession())) {
                throw new PersistenceException(ExceptionLocalization.buildMessage("ejb30-wrong-lock_called_without_version_locking-index", null));
            }
        }
        Session session = this.getActiveSession();
        try {
            if (this.getDatabaseQuery().isUserDefined() && this.entityManager.checkForTransaction(false) != null && session.isUnitOfWork() && !((UnitOfWorkImpl)session).wasTransactionBegunPrematurely()) {
                ((UnitOfWorkImpl)session).beginEarlyTransaction();
            }
            Object object = session.executeQuery(this.getDatabaseQuery(), list);
            return object;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
        finally {
            this.lockMode = null;
            if (bl) {
                ((ObjectLevelReadQuery)this.getDatabaseQuery()).conformResultsInUnitOfWork();
            }
        }
    }

    public int executeUpdate() {
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLModifyQuery();
            if (!(this.getDatabaseQuery() instanceof ModifyQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_execute_update"));
            }
            this.entityManager.checkForTransaction(true);
            List list = this.processParameters();
            if (this.isFlushModeAUTO()) {
                this.performPreQueryFlush();
            }
            Integer n = (Integer)this.getActiveSession().executeQuery(this.databaseQuery, list);
            return n;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    @Override
    public DatabaseQuery getDatabaseQuery() {
        if (this.queryName != null && this.databaseQuery == null) {
            this.databaseQuery = this.entityManager.getServerSession().getQuery(this.queryName);
            if (this.databaseQuery != null) {
                if (!this.databaseQuery.isPrepared()) {
                    this.databaseQuery.prepareCall(this.entityManager.getServerSession(), new DatabaseRecord());
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unable_to_find_named_query", new Object[]{this.queryName}));
            }
        }
        return this.databaseQuery;
    }

    @Override
    public JpaEntityManager getEntityManager() {
        return this.entityManager;
    }

    public LockModeType getLockMode() {
        try {
            this.entityManager.verifyOpen();
            if (!this.getDatabaseQuery().isReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_lock_query", null));
            }
            return this.lockMode;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    @Override
    public Cursor getResultCursor() {
        this.entityManager.verifyOpen();
        this.setAsSQLReadQuery();
        this.propagateResultProperties();
        if (this.getDatabaseQuery() instanceof ReadAllQuery) {
            if (!((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().isCursorPolicy()) {
                Class clazz = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass();
                throw QueryException.invalidContainerClass(clazz, Cursor.class);
            }
        } else {
            if (this.getDatabaseQuery() instanceof ReadObjectQuery) {
                throw QueryException.incorrectQueryObjectFound(this.getDatabaseQuery(), ReadAllQuery.class);
            }
            if (!(this.getDatabaseQuery() instanceof ReadQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_result_collection"));
            }
        }
        try {
            Object object = this.executeReadQuery();
            return (Cursor)object;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    @Override
    public Collection getResultCollection() {
        Object object;
        this.entityManager.verifyOpen();
        this.setAsSQLReadQuery();
        this.propagateResultProperties();
        if (this.getDatabaseQuery() instanceof ReadAllQuery) {
            object = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass();
            if (!Helper.classImplementsInterface((Class)object, ClassConstants.Collection_Class)) {
                throw QueryException.invalidContainerClass((Class)object, ClassConstants.Collection_Class);
            }
        } else {
            if (this.getDatabaseQuery() instanceof ReadObjectQuery) {
                throw QueryException.incorrectQueryObjectFound(this.getDatabaseQuery(), ReadAllQuery.class);
            }
            if (!(this.getDatabaseQuery() instanceof ReadQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_result_collection"));
            }
        }
        try {
            object = this.executeReadQuery();
            return (Collection)object;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public List getResultList() {
        try {
            Object object;
            this.entityManager.verifyOpen();
            this.setAsSQLReadQuery();
            this.propagateResultProperties();
            if (this.getDatabaseQuery() instanceof ReadAllQuery) {
                object = ((ReadAllQuery)this.getDatabaseQuery()).getContainerPolicy().getContainerClass();
                if (!Helper.classImplementsInterface((Class)object, ClassConstants.List_Class)) {
                    throw QueryException.invalidContainerClass((Class)object, ClassConstants.List_Class);
                }
            } else {
                if (this.getDatabaseQuery() instanceof ReadObjectQuery) {
                    throw QueryException.incorrectQueryObjectFound(this.getDatabaseQuery(), ReadAllQuery.class);
                }
                if (!(this.getDatabaseQuery() instanceof ReadQuery)) {
                    throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_result_list"));
                }
            }
            object = this.executeReadQuery();
            return (List)object;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public Object getSingleResult() {
        boolean bl = true;
        try {
            this.entityManager.verifyOpen();
            this.setAsSQLReadQuery();
            this.propagateResultProperties();
            if (!(this.getDatabaseQuery() instanceof ReadQuery)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("incorrect_query_for_get_single_result"));
            }
            Object object = this.executeReadQuery();
            if (object instanceof List) {
                List list = (List)object;
                if (list.isEmpty()) {
                    bl = false;
                    this.throwNoResultException(ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_single_result", null));
                } else if (list.size() > 1) {
                    bl = false;
                    this.throwNonUniqueResultException(ExceptionLocalization.buildMessage("too_many_results_for_get_single_result", null));
                }
                return list.get(0);
            }
            if (object == null) {
                bl = false;
                this.throwNoResultException(ExceptionLocalization.buildMessage("no_entities_retrieved_for_get_single_result", null));
            }
            return object;
        }
        catch (RuntimeException runtimeException) {
            if (bl) {
                this.setRollbackOnly();
            }
            throw runtimeException;
        }
    }

    protected List processParameters() {
        DatabaseQuery databaseQuery = this.getDatabaseQuery();
        Vector vector = databaseQuery.getArguments();
        if (vector.isEmpty()) {
            vector = new Vector(this.parameters.keySet());
            databaseQuery.setArguments(vector);
        }
        int n = vector.size();
        Vector vector2 = new Vector(n);
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.get(i);
            Object v = this.parameters.get(string);
            if (v == null && !this.parameters.containsKey(string)) {
                throw new IllegalStateException(ExceptionLocalization.buildMessage("missing_parameter_value", new Object[]{string}));
            }
            vector2.add(v);
        }
        return vector2;
    }

    @Override
    public void setDatabaseQuery(DatabaseQuery databaseQuery) {
        this.databaseQuery = databaseQuery;
    }

    public Query setFirstResult(int n) {
        try {
            this.entityManager.verifyOpen();
            this.setFirstResultInternal(n);
            return this;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    protected void setFirstResultInternal(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("negative_start_position", null));
        }
        this.firstResultIndex = n;
    }

    public Query setFlushMode(FlushModeType flushModeType) {
        try {
            this.entityManager.verifyOpen();
            if (flushModeType == null) {
                this.getDatabaseQuery().setFlushOnExecute(null);
            } else {
                this.cloneSharedQuery();
                this.getDatabaseQuery().setFlushOnExecute(flushModeType == FlushModeType.AUTO);
            }
            return this;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    protected static void applyArguments(List<String> list, DatabaseQuery databaseQuery) {
        for (String string : list) {
            databaseQuery.addArgument(string);
        }
    }

    protected static DatabaseQuery applyHints(Map<String, Object> map, DatabaseQuery databaseQuery, ClassLoader classLoader) {
        return QueryHintsHandler.apply(map, databaseQuery, classLoader);
    }

    protected boolean isFlushModeAUTO() {
        if (this.getDatabaseQuery().getFlushOnExecute() != null) {
            return this.getDatabaseQuery().getFlushOnExecute();
        }
        return this.entityManager.isFlushModeAUTO();
    }

    public Query setHint(String string, Object object) {
        try {
            this.entityManager.verifyOpen();
            this.setHintInternal(string, object);
            return this;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    protected void setHintInternal(String string, Object object) {
        this.cloneSharedQuery();
        ClassLoader classLoader = this.getEntityManager().getServerSession().getLoader();
        DatabaseQuery databaseQuery = QueryHintsHandler.apply(string, object, this.getDatabaseQuery(), classLoader);
        if (databaseQuery != null) {
            this.setDatabaseQuery(databaseQuery);
        }
    }

    public Query setLockMode(LockModeType lockModeType) {
        try {
            this.entityManager.verifyOpen();
            if (!this.getDatabaseQuery().isReadQuery()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_lock_query", null));
            }
            this.lockMode = lockModeType;
            return this;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    protected void cloneSharedQuery() {
        DatabaseQuery databaseQuery = this.getDatabaseQuery();
        if (this.isShared) {
            databaseQuery = (DatabaseQuery)this.databaseQuery.clone();
            this.setDatabaseQuery(databaseQuery);
            this.isShared = false;
        }
    }

    protected Object convertTemporalType(Object object, TemporalType temporalType) {
        ConversionManager conversionManager = ((AbstractSession)this.getEntityManager().getActiveSession()).getDatasourcePlatform().getConversionManager();
        if (temporalType == TemporalType.TIME) {
            return conversionManager.convertObject(object, ClassConstants.TIME);
        }
        if (temporalType == TemporalType.TIMESTAMP) {
            return conversionManager.convertObject(object, ClassConstants.TIMESTAMP);
        }
        if (temporalType == TemporalType.DATE) {
            return conversionManager.convertObject(object, ClassConstants.SQLDATE);
        }
        return object;
    }

    public Query setMaxResults(int n) {
        try {
            this.entityManager.verifyOpen();
            this.setMaxResultsInternal(n);
            return this;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public void setMaxResultsInternal(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("negative_max_result", null));
        }
        this.maxResults = n;
    }

    public Query setParameter(String string, Object object) {
        try {
            this.entityManager.verifyOpen();
            this.setParameterInternal(string, object, false);
            return this;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public Query setParameter(String string, Date date, TemporalType temporalType) {
        return this.setParameter(string, this.convertTemporalType(date, temporalType));
    }

    public Query setParameter(String string, Calendar calendar, TemporalType temporalType) {
        return this.setParameter(string, this.convertTemporalType(calendar, temporalType));
    }

    public Query setParameter(int n, Object object) {
        try {
            this.entityManager.verifyOpen();
            this.setParameterInternal(n, object);
            return this;
        }
        catch (RuntimeException runtimeException) {
            this.setRollbackOnly();
            throw runtimeException;
        }
    }

    public Query setParameter(int n, Date date, TemporalType temporalType) {
        return this.setParameter(n, this.convertTemporalType(date, temporalType));
    }

    public Query setParameter(int n, Calendar calendar, TemporalType temporalType) {
        return this.setParameter(n, this.convertTemporalType(calendar, temporalType));
    }

    protected void propagateResultProperties() {
        DatabaseQuery databaseQuery = this.getDatabaseQuery();
        if (databaseQuery.isReadQuery()) {
            ReadQuery readQuery = (ReadQuery)databaseQuery;
            if (this.maxResults >= 0) {
                this.cloneSharedQuery();
                readQuery = (ReadQuery)this.getDatabaseQuery();
                int n = this.maxResults + (this.firstResultIndex >= 0 ? this.firstResultIndex : 0);
                readQuery.setMaxRows(n);
                this.maxResults = -1;
            }
            if (this.firstResultIndex > -1) {
                this.cloneSharedQuery();
                readQuery = (ReadQuery)this.getDatabaseQuery();
                readQuery.setFirstResult(this.firstResultIndex);
                this.firstResultIndex = -1;
            }
        }
    }

    protected void setParameterInternal(String string, Object object, boolean bl) {
        DatabaseQuery databaseQuery = this.getDatabaseQuery();
        int n = databaseQuery.getArguments().indexOf(string);
        if (databaseQuery.getQueryMechanism().isJPQLCallQueryMechanism()) {
            if (n == -1) {
                if (bl) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-argument-index", new Object[]{string, databaseQuery.getEJBQLString()}));
                }
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-wrong-argument-name", new Object[]{string, databaseQuery.getEJBQLString()}));
            }
            Class clazz = (Class)databaseQuery.getArgumentTypes().get(n);
            if (clazz != null && clazz != ClassConstants.OBJECT && object != null && clazz != object.getClass() && !this.isValidActualParameter(object, clazz)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("ejb30-incorrect-parameter-type", new Object[]{string, object.getClass(), databaseQuery.getArgumentTypes().get(n), databaseQuery.getEJBQLString()}));
            }
        }
        this.parameters.put(string, object);
    }

    protected void setParameterInternal(int n, Object object) {
        this.setParameterInternal(String.valueOf(n), object, true);
    }

    protected boolean isValidActualParameter(Object object, Class clazz) {
        if (object == null) {
            return true;
        }
        return BasicTypeHelperImpl.getInstance().isAssignableFrom(clazz, object.getClass());
    }

    protected Session getActiveSession() {
        DatabaseQuery databaseQuery = this.getDatabaseQuery();
        if (databaseQuery.isObjectLevelReadQuery() && ((ObjectLevelReadQuery)databaseQuery).isReadOnly()) {
            return this.entityManager.getReadOnlySession();
        }
        return this.entityManager.getActiveSession();
    }

    protected void performPreQueryFlush() {
        if (this.entityManager.shouldFlushBeforeQuery()) {
            this.entityManager.flush();
        }
    }

    protected void setRollbackOnly() {
        this.entityManager.setRollbackOnly();
    }

    protected void throwNoResultException(String string) {
        throw new NoResultException(string);
    }

    protected void throwNonUniqueResultException(String string) {
        throw new NonUniqueResultException(string);
    }
}

