/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.jpa.deployment.Archive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryArchive
implements Archive {
    private File directory;
    private URL rootURL;
    private List<String> entries = new ArrayList<String>();
    private Logger logger;

    public DirectoryArchive(File file) throws MalformedURLException {
        this(file, Logger.global);
    }

    public DirectoryArchive(File file, Logger logger) throws MalformedURLException {
        logger.entering("DirectoryArchive", "DirectoryArchive", new Object[]{file});
        this.logger = logger;
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory." + "If it is a jar file, then use JarFileArchive.");
        }
        this.directory = file;
        this.rootURL = file.toURI().toURL();
        logger.logp(Level.FINER, "DirectoryArchive", "DirectoryArchive", "rootURL = {0}", this.rootURL);
        this.init(this.directory, this.directory);
    }

    private void init(File file, File file2) {
        File[] fileArray;
        File[] fileArray2 = fileArray = file2.listFiles();
        int n = fileArray2.length;
        for (int i = 0; i < n; ++i) {
            File file3 = fileArray2[i];
            if (file3.isDirectory()) continue;
            String object = file3.getPath().replace(File.separator, "/").substring(file.getPath().length() + 1);
            this.entries.add(object);
        }
        for (File file3 : fileArray2 = file2.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            this.init(file, file3);
        }
    }

    @Override
    public Iterator<String> getEntries() {
        return this.entries.iterator();
    }

    @Override
    public InputStream getEntry(String string) throws IOException {
        File file = this.getFile(string);
        FileInputStream fileInputStream = file.exists() ? new FileInputStream(file) : null;
        return fileInputStream;
    }

    @Override
    public URL getEntryAsURL(String string) throws IOException {
        File file = this.getFile(string);
        URL uRL = file.exists() ? file.toURI().toURL() : null;
        return uRL;
    }

    @Override
    public URL getRootURL() {
        return this.rootURL;
    }

    private File getFile(String string) {
        File file = new File(this.directory, string);
        return file;
    }
}

