/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Embeddable;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedAccessor
extends MappingAccessor {
    private List<AttributeOverrideMetadata> m_attributeOverrides;

    public EmbeddedAccessor() {
        super("<embedded>");
    }

    protected EmbeddedAccessor(String string) {
        super(string);
    }

    public EmbeddedAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        Object object;
        this.m_attributeOverrides = new ArrayList<AttributeOverrideMetadata>();
        Object t = this.getAnnotation(AttributeOverrides.class);
        if (t != null) {
            object = (Annotation[])MetadataHelper.invokeMethod("value", t);
            int n = ((T)object).length;
            for (int i = 0; i < n; ++i) {
                Object t2 = object[i];
                this.m_attributeOverrides.add(new AttributeOverrideMetadata((Annotation)t2, metadataAccessibleObject));
            }
        }
        if ((object = this.getAnnotation(AttributeOverride.class)) != null) {
            this.m_attributeOverrides.add(new AttributeOverrideMetadata((Annotation)object, metadataAccessibleObject));
        }
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObjects(this.m_attributeOverrides, metadataAccessibleObject);
        for (AttributeOverrideMetadata attributeOverrideMetadata : this.m_attributeOverrides) {
            attributeOverrideMetadata.getColumn().setAttributeName(attributeOverrideMetadata.getName());
        }
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public void process() {
        this.processEmbeddableClass();
        AggregateObjectMapping aggregateObjectMapping = new AggregateObjectMapping();
        aggregateObjectMapping.setIsReadOnly(false);
        aggregateObjectMapping.setIsNullAllowed(true);
        aggregateObjectMapping.setReferenceClassName(this.getReferenceClassName());
        aggregateObjectMapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods(aggregateObjectMapping);
        for (AttributeOverrideMetadata attributeOverrideMetadata : this.m_attributeOverrides) {
            this.processAttributeOverride(aggregateObjectMapping, attributeOverrideMetadata);
        }
        this.processAssociationOverrides(aggregateObjectMapping);
        this.processProperties(aggregateObjectMapping);
        this.processReturnInsertAndUpdate();
        this.getDescriptor().addEmbeddableDescriptor(this.getReferenceDescriptor());
        this.getDescriptor().addMapping(aggregateObjectMapping);
    }

    protected void processAssociationOverride(Object object, AggregateObjectMapping aggregateObjectMapping) {
        String string;
        MetadataDescriptor metadataDescriptor = this.getReferenceDescriptor();
        DatabaseMapping databaseMapping = metadataDescriptor.getMappingForAttributeName(string = (String)MetadataHelper.invokeMethod("name", object));
        if (databaseMapping != null && databaseMapping.isOneToOneMapping()) {
            int n = 0;
            for (Annotation annotation : (Annotation[])MetadataHelper.invokeMethod("joinColumns", object)) {
                DatabaseField databaseField = ((OneToOneMapping)databaseMapping).getForeignKeyFields().elementAt(n++);
                aggregateObjectMapping.addFieldNameTranslation((String)MetadataHelper.invokeMethod("name", annotation), databaseField.getName());
            }
        }
    }

    protected void processAssociationOverrides(AggregateObjectMapping aggregateObjectMapping) {
        Object object;
        Object t = this.getAnnotation(AssociationOverrides.class);
        if (t != null) {
            object = (Annotation[])MetadataHelper.invokeMethod("value", t);
            int n = ((T)object).length;
            for (int i = 0; i < n; ++i) {
                Object t2 = object[i];
                this.processAssociationOverride(t2, aggregateObjectMapping);
            }
        }
        if ((object = this.getAnnotation(AssociationOverride.class)) != null) {
            this.processAssociationOverride(object, aggregateObjectMapping);
        }
    }

    protected void processAttributeOverride(AggregateObjectMapping aggregateObjectMapping, AttributeOverrideMetadata attributeOverrideMetadata) {
        DatabaseField databaseField;
        String string = attributeOverrideMetadata.getName();
        DatabaseMapping databaseMapping = this.getReferenceDescriptor().getMappingForAttributeName(string);
        if (databaseMapping == null) {
            throw ValidationException.invalidEmbeddableAttribute(this.getReferenceDescriptor().getJavaClass(), string, this.getJavaClass(), aggregateObjectMapping.getAttributeName());
        }
        if (this.getDescriptor().hasAttributeOverrideFor(string)) {
            attributeOverrideMetadata.getColumn().setDatabaseField(this.getDescriptor().getAttributeOverrideFor(string).getColumn().getDatabaseField());
        }
        if ((databaseField = attributeOverrideMetadata.getColumn().getDatabaseField()).getTableName().equals("")) {
            databaseField.setTable(this.getOwningDescriptor().getPrimaryTable());
        }
        DatabaseField databaseField2 = databaseMapping.getField();
        if (this.getOwningDescriptor().isPrimaryKeyField(databaseField2)) {
            this.getOwningDescriptor().removePrimaryKeyField(databaseField2);
            this.getOwningDescriptor().addPrimaryKeyField(databaseField);
        }
        aggregateObjectMapping.addFieldNameTranslation(databaseField.getQualifiedName(), databaseField2.getName());
    }

    protected void processEmbeddableClass() {
        EmbeddableAccessor embeddableAccessor = this.getProject().getEmbeddableAccessor(this.getReferenceClassName());
        if (embeddableAccessor == null) {
            MetadataClass metadataClass = new MetadataClass(this.getReferenceClass());
            if (metadataClass.isAnnotationNotPresent(Embeddable.class)) {
                throw ValidationException.invalidEmbeddedAttribute(this.getJavaClass(), this.getAttributeName(), this.getReferenceClass());
            }
            embeddableAccessor = new EmbeddableAccessor((Annotation)metadataClass.getAnnotation(Embeddable.class), this.getReferenceClass(), this.getProject());
            this.getProject().addEmbeddableAccessor(embeddableAccessor);
        }
        if (embeddableAccessor.isProcessed()) {
            if (!embeddableAccessor.hasAccess() && !embeddableAccessor.getDescriptor().getDefaultAccess().equals(this.getOwningDescriptor().getDefaultAccess())) {
                throw ValidationException.conflictingAccessTypeForEmbeddable(embeddableAccessor.getJavaClass(), embeddableAccessor.usesPropertyAccess(), this.getOwningDescriptor().getJavaClass(), this.getOwningDescriptor().getClassAccessor().usesPropertyAccess());
            }
        } else {
            embeddableAccessor.setOwningDescriptor(this.getOwningDescriptor());
            embeddableAccessor.process();
            embeddableAccessor.setIsProcessed();
        }
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> list) {
        this.m_attributeOverrides = list;
    }
}

